"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dBConfigurationProvider = exports.onDidTerminateSession = exports.initializeRunConfiguration = void 0;
const vscode = require("vscode");
function initializeRunConfiguration() {
    return __awaiter(this, void 0, void 0, function* () {
        const java = yield vscode.workspace.findFiles('**/*.java', '**/node_modules/**', 1);
        if ((java === null || java === void 0 ? void 0 : java.length) > 0) {
            const maven = yield vscode.workspace.findFiles('pom.xml', '**/node_modules/**', 1);
            if ((maven === null || maven === void 0 ? void 0 : maven.length) > 0) {
                return true;
            }
            const gradle = yield vscode.workspace.findFiles('build.gradle', '**/node_modules/**', 1);
            if ((gradle === null || gradle === void 0 ? void 0 : gradle.length) > 0) {
                return true;
            }
        }
        return false;
    });
}
exports.initializeRunConfiguration = initializeRunConfiguration;
class DBConfigurationProvider {
    resolveDebugConfiguration(_folder, config, _token) {
        return new Promise(resolve => {
            resolve(config);
        });
    }
    resolveDebugConfigurationWithSubstitutedVariables(_folder, config, _token) {
        return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
            let o;
            try {
                o = yield vscode.commands.executeCommand('nbls.db.connection');
            }
            catch (err) {
                console.log(err);
                reject(err);
                return;
            }
            if (config === undefined) {
                config = {};
            }
            if (config.env === undefined) {
                config.env = {};
            }
            for (let val of Object.keys(o)) {
                let value = o[val];
                config.env[val] = value;
            }
            resolve(config);
        }));
    }
}
function onDidTerminateSession(session) {
    const config = session.configuration;
    if (config.env) {
        const file = config.env["MICRONAUT_CONFIG_FILES"];
        if (file) {
            vscode.workspace.fs.delete(vscode.Uri.file(file));
        }
    }
}
exports.onDidTerminateSession = onDidTerminateSession;
exports.dBConfigurationProvider = new DBConfigurationProvider();
//# sourceMappingURL=dbConfigurationProvider.js.map