"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GuidePanel = void 0;
const vscode = require("vscode");
const path = require("path");
const fs = require("fs");
const Handlebars = require("handlebars");
const util_1 = require("util");
const readFile = (0, util_1.promisify)(fs.readFile);
class GuidePanel {
    constructor(context, viewType, templatePath, properties) {
        this.webviewsFolder = "webviews";
        this.stylesFolder = "styles";
        this.scriptsFolder = "scripts";
        this.disposables = [];
        this.properties = properties;
        this.templatePath = templatePath;
        this.panel = vscode.window.createWebviewPanel(viewType, "Oracle Cloud Assets", { viewColumn: vscode.ViewColumn.One, preserveFocus: true }, {
            enableCommandUris: true,
            enableScripts: true,
            localResourceRoots: [vscode.Uri.file(path.join(context.extensionPath, this.webviewsFolder))],
        });
        this.disposables.push(this.panel.onDidDispose(() => this.dispose()));
        this.panel.onDidChangeViewState(() => {
            if (this.panel.visible) {
                this.setHtml(context);
            }
        }, null, this.disposables);
        this.panel.webview.onDidReceiveMessage((e) => this.messageHandler(e), undefined, this.disposables);
        this.setHtml(context);
    }
    getSources(context) {
        return {
            cssUri: this.panel.webview.asWebviewUri(vscode.Uri.file(path.join(context.extensionPath, this.webviewsFolder, this.stylesFolder, "guide.css"))),
            javascriptUri: this.panel.webview.asWebviewUri(vscode.Uri.file(path.join(context.extensionPath, this.webviewsFolder, this.scriptsFolder, "guide.js"))),
        };
    }
    setHtml(context) {
        return __awaiter(this, void 0, void 0, function* () {
            let templateFilePath = path.join(context.extensionPath, this.webviewsFolder, this.templatePath);
            const template = yield this.getTemplateFromPath(templateFilePath);
            this.panel.webview.html = template(Object.assign(Object.assign({ cspSource: this.panel.webview.cspSource }, this.getSources(context)), this.properties));
        });
    }
    getTemplateFromPath(path) {
        return __awaiter(this, void 0, void 0, function* () {
            const templateFile = yield readFile(path, "utf-8");
            return Handlebars.compile(templateFile);
        });
    }
    dispose() {
        this.panel.dispose();
        this.disposables.forEach(x => x === null || x === void 0 ? void 0 : x.dispose());
    }
}
exports.GuidePanel = GuidePanel;
//# sourceMappingURL=GuidePanel.js.map