"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunImageGuidePanel = exports.viewType = void 0;
const vscode = require("vscode");
const GuidePanel_1 = require("./GuidePanel");
const guidesUtil_1 = require("./guidesUtil");
exports.viewType = "runImageGuide";
const templatePath = "run-image-guide.handlebars";
class RunImageGuidePanel extends GuidePanel_1.GuidePanel {
    constructor(context, props) {
        const { ocid, publicIp, isRepositoryPrivate, registryUrl } = props;
        super(context, exports.viewType, templatePath, {
            ocid,
            publicIp,
            isRepositoryPrivate,
            registryUrl,
            dummyKeyPathLocation: guidesUtil_1.dummyKeyPathLocation,
            sshConfigLocation: guidesUtil_1.sshConfigLocation,
            showGuide: "",
        });
    }
    static createOrShow(context, props) {
        if (RunImageGuidePanel.currentPanel) {
            if (!this.propertiesUpdated(props)) {
                RunImageGuidePanel.currentPanel.panel.reveal();
                return;
            }
            RunImageGuidePanel.currentPanel.panel.dispose();
        }
        RunImageGuidePanel.currentPanel = new RunImageGuidePanel(context, props);
    }
    static propertiesUpdated(props) {
        var _a;
        const { ocid, publicIp } = props;
        return ((_a = RunImageGuidePanel.currentPanel) === null || _a === void 0 ? void 0 : _a.properties.ocid) !== ocid || RunImageGuidePanel.currentPanel.properties.publicIp !== publicIp;
    }
    messageHandler(message) {
        return __awaiter(this, void 0, void 0, function* () {
            if (message.command === "showGuide") {
                yield (0, guidesUtil_1.toggleGuideFor)(exports.viewType, this.properties.ocid);
                this.properties.showGuide = this.properties.showGuide === "checked" ? "" : "checked";
            }
            else if (message.command === "openSSHConfig") {
                vscode.workspace.openTextDocument(guidesUtil_1.sshConfigLocation).then(document => vscode.window.showTextDocument(document));
            }
        });
    }
    dispose() {
        RunImageGuidePanel.currentPanel = undefined;
        super.dispose();
    }
}
exports.RunImageGuidePanel = RunImageGuidePanel;
//# sourceMappingURL=RunImageGuidePanel.js.map