"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SshGuidePanel = exports.viewType = void 0;
const vscode = require("vscode");
const GuidePanel_1 = require("./GuidePanel");
const guidesUtil_1 = require("./guidesUtil");
exports.viewType = "sshGuide";
const templatePath = "ssh-guide.handlebars";
class SshGuidePanel extends GuidePanel_1.GuidePanel {
    constructor(context, props) {
        const { ocid, publicIp } = props;
        super(context, exports.viewType, templatePath, {
            ocid,
            publicIp,
            dummyKeyPathLocation: guidesUtil_1.dummyKeyPathLocation,
            sshConfigLocation: guidesUtil_1.sshConfigLocation,
            showGuide: "",
        });
    }
    static createOrShow(context, props) {
        if (SshGuidePanel.currentPanel) {
            if (!this.propertiesUpdated(props)) {
                SshGuidePanel.currentPanel.panel.reveal();
                return;
            }
            SshGuidePanel.currentPanel.panel.dispose();
        }
        SshGuidePanel.currentPanel = new SshGuidePanel(context, props);
    }
    static propertiesUpdated(props) {
        var _a;
        const { ocid, publicIp } = props;
        return ((_a = SshGuidePanel.currentPanel) === null || _a === void 0 ? void 0 : _a.properties.ocid) !== ocid || SshGuidePanel.currentPanel.properties.publicIp !== publicIp;
    }
    messageHandler(message) {
        return __awaiter(this, void 0, void 0, function* () {
            if (message.command === "showGuide") {
                yield (0, guidesUtil_1.toggleGuideFor)(exports.viewType, this.properties.ocid);
                this.properties.showGuide = this.properties.showGuide === "checked" ? "" : "checked";
            }
            else if (message.command === "openSSHConfig") {
                vscode.workspace.openTextDocument(guidesUtil_1.sshConfigLocation).then(document => vscode.window.showTextDocument(document));
            }
        });
    }
    dispose() {
        SshGuidePanel.currentPanel = undefined;
        super.dispose();
    }
}
exports.SshGuidePanel = SshGuidePanel;
//# sourceMappingURL=SshGuidePanel.js.map