"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.toggleGuideFor = exports.shouldHideGuideFor = exports.dummyKeyPathLocation = exports.sshConfigLocation = exports.GUIDE_NOTIFICATION_CONFIGURATION_KEY = void 0;
const vscode = require("vscode");
const path = require("path");
const os = require("os");
exports.GUIDE_NOTIFICATION_CONFIGURATION_KEY = 'guides.notified';
exports.sshConfigLocation = path.join(os.homedir(), '.ssh', 'config');
exports.dummyKeyPathLocation = path.join(os.homedir(), '<path-to-your-key>', 'ssh-key-yyyy-mm-dd.key');
function shouldHideGuideFor(viewType, ocid) {
    const notifiedGuides = vscode.workspace.getConfiguration('netbeans').get(exports.GUIDE_NOTIFICATION_CONFIGURATION_KEY);
    return notifiedGuides && notifiedGuides.find((notified) => notified.ocid === ocid && notified.viewType === viewType) ? true : false;
}
exports.shouldHideGuideFor = shouldHideGuideFor;
function toggleGuideFor(viewType, ocid) {
    return __awaiter(this, void 0, void 0, function* () {
        const notifiedGuides = vscode.workspace.getConfiguration('netbeans').get(exports.GUIDE_NOTIFICATION_CONFIGURATION_KEY) || [];
        const notifiedForOcid = notifiedGuides.find((notified) => notified.ocid === ocid && notified.viewType === viewType);
        if (notifiedForOcid) {
            try {
                const updatedNotifiedGuides = notifiedGuides.filter((notified) => notified.ocid !== ocid);
                yield vscode.workspace.getConfiguration('netbeans')
                    .update(exports.GUIDE_NOTIFICATION_CONFIGURATION_KEY, updatedNotifiedGuides.length > 0 ? updatedNotifiedGuides : undefined, true);
            }
            catch (err) {
                vscode.window.showErrorMessage(`Failed to update property: netbeans.${exports.GUIDE_NOTIFICATION_CONFIGURATION_KEY}, ${err}`);
            }
        }
        else {
            notifiedGuides.push({ ocid, viewType });
            try {
                yield vscode.workspace.getConfiguration('netbeans').update(exports.GUIDE_NOTIFICATION_CONFIGURATION_KEY, [...notifiedGuides], true);
            }
            catch (err) {
                vscode.window.showErrorMessage(`Failed to update property: netbeans.${exports.GUIDE_NOTIFICATION_CONFIGURATION_KEY}, ${err}`);
            }
        }
    });
}
exports.toggleGuideFor = toggleGuideFor;
//# sourceMappingURL=guidesUtil.js.map