/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.tenants;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.entity.UserEntity;

public class CreateUser
extends AbstractNiFiCommand<StringResult> {
    public CreateUser() {
        super("create-user", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates new user.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.USER_NAME.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String userId = this.getRequiredArg(properties, CommandOption.USER_NAME);
        UserDTO userDTO = new UserDTO();
        userDTO.setIdentity(userId);
        UserEntity userEntity = new UserEntity();
        userEntity.setComponent(userDTO);
        userEntity.setRevision(this.getInitialRevisionDTO());
        UserEntity createdEntity = client.getTenantsClient().createUser(userEntity);
        return new StringResult(createdEntity.getId(), this.getContext().isInteractive());
    }
}

