/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.inheritance;

public interface FlowInheritability {
    public boolean isInheritable();

    public String getExplanation();

    public static FlowInheritability inheritable() {
        return new FlowInheritability(){

            @Override
            public boolean isInheritable() {
                return true;
            }

            @Override
            public String getExplanation() {
                return null;
            }

            public String toString() {
                return "FlowInheritability[inheritable=true]";
            }
        };
    }

    public static FlowInheritability notInheritable(final String explanation) {
        return new FlowInheritability(){

            @Override
            public boolean isInheritable() {
                return false;
            }

            @Override
            public String getExplanation() {
                return explanation;
            }

            public String toString() {
                return "FlowInheritability[inheritable=false, explanation=" + explanation + "]";
            }
        };
    }
}

