/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import jetbrains.exodus.core.dataStructures.persistent.LongComparable;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import org.jetbrains.annotations.Nullable;

public class LongMapEntry<V>
implements PersistentLongMap.Entry<V>,
LongComparable<PersistentLongMap.Entry<V>> {
    private final long key;
    private final V value;

    public LongMapEntry(long k) {
        this(k, null);
    }

    public LongMapEntry(long k, @Nullable V v) {
        this.key = k;
        this.value = v;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public long getWeight() {
        return this.key;
    }

    @Override
    public int compareTo(PersistentLongMap.Entry<V> o) {
        long otherKey = o.getKey();
        return this.key > otherKey ? 1 : (this.key == otherKey ? 0 : -1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PersistentLongMap.Entry)) {
            return false;
        }
        PersistentLongMap.Entry that = (PersistentLongMap.Entry)o;
        return this.key == that.getKey() && (this.value != null ? this.value.equals(that.getValue()) : that.getValue() == null);
    }

    public int hashCode() {
        int result = (int)(this.key ^ this.key >>> 32);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

