/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.Date;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.JobHandler;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Job {
    private JobProcessor processor;
    private boolean wasQueued;
    @Nullable
    private JobHandler[] jobStartingHandlers;
    @Nullable
    private JobHandler[] jobFinishedHandlers;
    private Thread executingThread;
    private long startedAt;

    protected Job() {
        this.processor = null;
        this.wasQueued = false;
        this.jobStartingHandlers = null;
        this.jobFinishedHandlers = null;
        this.executingThread = null;
        this.startedAt = 0L;
    }

    protected Job(@NotNull JobProcessor processor) {
        this(processor, Priority.normal);
    }

    protected Job(@NotNull JobProcessor processor, @NotNull Priority priority) {
        this.processor = processor;
        this.jobStartingHandlers = null;
        this.jobFinishedHandlers = null;
        this.queue(priority);
    }

    public boolean queue(Priority priority) {
        return this.queue(this.processor, priority);
    }

    public boolean queue(JobProcessor processor, Priority priority) {
        this.wasQueued = processor.queue(this, priority);
        return this.wasQueued;
    }

    public JobProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(JobProcessor processor) {
        this.processor = processor;
    }

    public boolean wasQueued() {
        return this.wasQueued;
    }

    public String getName() {
        String name = this.getClass().getSimpleName();
        return name.isEmpty() ? "<anonymous>" : name;
    }

    public String getGroup() {
        return this.getClass().getName();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(100);
        result.append(this.getGroup());
        result.append(": ");
        result.append(this.getName());
        if (this.startedAt > 0L) {
            result.append(", started at: ");
            result.append(new Date(this.startedAt).toString().substring(4));
        }
        return result.toString();
    }

    public Thread getExecutingThread() {
        return this.executingThread;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public void registerJobStartingHandler(@NotNull JobHandler handler) {
        this.jobStartingHandlers = JobHandler.append(this.jobStartingHandlers, handler);
    }

    public void registerJobFinishedHandler(@NotNull JobHandler handler) {
        this.jobFinishedHandlers = JobHandler.append(this.jobFinishedHandlers, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void run(@Nullable JobProcessorExceptionHandler handler, @NotNull Thread executingThread) {
        this.executingThread = executingThread;
        this.startedAt = System.currentTimeMillis();
        Throwable exception = null;
        JobHandler.invokeHandlers(this.jobStartingHandlers, this);
        try {
            this.execute();
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            JobHandler.invokeHandlers(this.jobFinishedHandlers, this);
        }
        if (exception != null && handler != null) {
            handler.handle(this.processor, this, exception);
        }
    }

    public final boolean equals(Object job) {
        if (job == this) {
            return true;
        }
        return job != null && this.getClass() == job.getClass() && this.isEqualTo((Job)job);
    }

    public boolean isEqualTo(Job job) {
        return super.equals(job);
    }

    protected abstract void execute() throws Throwable;
}

