/****************************************************************************
 * arch/risc-v/src/hpm6750/hpm6750_iomux.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISCV_SRC_HPM6750_HPM6750_IOMUX_H
#define __ARCH_RISCV_SRC_HPM6750_HPM6750_IOMUX_H

/* IOC_PA00_FUNC_CTL function mux definitions */
#define IOC_PA00_FUNC_CTL_GPIO_A_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA00_FUNC_CTL_UART3_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA00_FUNC_CTL_SPI0_DAT3            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA00_FUNC_CTL_I2S1_TXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA00_FUNC_CTL_I2S2_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA00_FUNC_CTL_CAM0_D_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA01_FUNC_CTL function mux definitions */
#define IOC_PA01_FUNC_CTL_GPIO_A_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA01_FUNC_CTL_UART1_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA01_FUNC_CTL_SPI0_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA01_FUNC_CTL_CAN3_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA01_FUNC_CTL_I2S1_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA01_FUNC_CTL_CAM0_D_8             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA02_FUNC_CTL function mux definitions */
#define IOC_PA02_FUNC_CTL_GPIO_A_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA02_FUNC_CTL_UART1_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA02_FUNC_CTL_SPI0_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA02_FUNC_CTL_CAN3_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA02_FUNC_CTL_I2S1_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA02_FUNC_CTL_CAM0_D_9             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA03_FUNC_CTL function mux definitions */
#define IOC_PA03_FUNC_CTL_GPIO_A_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA03_FUNC_CTL_GPTMR1_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA03_FUNC_CTL_UART3_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA03_FUNC_CTL_I2S1_TXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA03_FUNC_CTL_I2S2_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA03_FUNC_CTL_CAM0_D_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA04_FUNC_CTL function mux definitions */
#define IOC_PA04_FUNC_CTL_GPIO_A_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA04_FUNC_CTL_GPTMR1_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA04_FUNC_CTL_UART4_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA04_FUNC_CTL_SPI0_DAT2            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA04_FUNC_CTL_I2S1_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA04_FUNC_CTL_I2S2_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA04_FUNC_CTL_CAM0_D_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA05_FUNC_CTL function mux definitions */
#define IOC_PA05_FUNC_CTL_GPIO_A_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA05_FUNC_CTL_GPTMR0_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA05_FUNC_CTL_UART6_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA05_FUNC_CTL_I2C0_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PA05_FUNC_CTL_SPI0_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA05_FUNC_CTL_I2S1_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA05_FUNC_CTL_DAOL_P               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PA05_FUNC_CTL_CAM0_HSYNC           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA06_FUNC_CTL function mux definitions */
#define IOC_PA06_FUNC_CTL_GPIO_A_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA06_FUNC_CTL_GPTMR0_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA06_FUNC_CTL_UART6_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA06_FUNC_CTL_I2C0_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PA06_FUNC_CTL_SPI0_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA06_FUNC_CTL_I2S1_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA06_FUNC_CTL_DAOR_P               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PA06_FUNC_CTL_CAM0_VSYNC           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA07_FUNC_CTL function mux definitions */
#define IOC_PA07_FUNC_CTL_GPIO_A_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA07_FUNC_CTL_GPTMR1_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA07_FUNC_CTL_UART5_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA07_FUNC_CTL_I2S1_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA07_FUNC_CTL_CAM0_D_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)
#define IOC_PA07_FUNC_CTL_SOC_REF1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PA08_FUNC_CTL function mux definitions */
#define IOC_PA08_FUNC_CTL_GPIO_A_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA08_FUNC_CTL_GPTMR1_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA08_FUNC_CTL_UART5_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA08_FUNC_CTL_I2S1_RXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA08_FUNC_CTL_I2S2_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA08_FUNC_CTL_CAM0_D_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA09_FUNC_CTL function mux definitions */
#define IOC_PA09_FUNC_CTL_GPIO_A_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA09_FUNC_CTL_UART4_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA09_FUNC_CTL_I2S1_RXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA09_FUNC_CTL_I2S2_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA09_FUNC_CTL_CAM0_D_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)
#define IOC_PA09_FUNC_CTL_SOC_REF0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PA10_FUNC_CTL function mux definitions */
#define IOC_PA10_FUNC_CTL_GPIO_A_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA10_FUNC_CTL_GPTMR0_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA10_FUNC_CTL_UART7_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA10_FUNC_CTL_I2C1_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PA10_FUNC_CTL_CAN3_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA10_FUNC_CTL_I2S1_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA10_FUNC_CTL_DAOL_N               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PA10_FUNC_CTL_CAM0_XCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA11_FUNC_CTL function mux definitions */
#define IOC_PA11_FUNC_CTL_GPIO_A_11            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA11_FUNC_CTL_GPTMR0_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA11_FUNC_CTL_UART7_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA11_FUNC_CTL_I2C1_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PA11_FUNC_CTL_CAN2_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA11_FUNC_CTL_I2S1_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA11_FUNC_CTL_DAOR_N               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PA11_FUNC_CTL_CAM0_PIXCLK          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA12_FUNC_CTL function mux definitions */
#define IOC_PA12_FUNC_CTL_GPIO_A_12            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA12_FUNC_CTL_GPTMR1_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA12_FUNC_CTL_UART9_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PA12_FUNC_CTL_I2C3_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PA12_FUNC_CTL_SPI1_DAT3            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA12_FUNC_CTL_I2S1_RXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA12_FUNC_CTL_DIS0_B_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA12_FUNC_CTL_CAM0_PIXCLK          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA13_FUNC_CTL function mux definitions */
#define IOC_PA13_FUNC_CTL_GPIO_A_13            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA13_FUNC_CTL_GPTMR1_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA13_FUNC_CTL_UART9_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PA13_FUNC_CTL_I2C3_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PA13_FUNC_CTL_SPI1_DAT2            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA13_FUNC_CTL_I2S1_RXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA13_FUNC_CTL_DIS0_B_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA13_FUNC_CTL_CAM0_HSYNC           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA14_FUNC_CTL function mux definitions */
#define IOC_PA14_FUNC_CTL_GPIO_A_14            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA14_FUNC_CTL_GPTMR0_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA14_FUNC_CTL_UART8_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PA14_FUNC_CTL_I2C2_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PA14_FUNC_CTL_CAN1_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA14_FUNC_CTL_I2S2_TXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA14_FUNC_CTL_I2S1_TXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA14_FUNC_CTL_DIS0_VSYNC           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)

/* IOC_PA15_FUNC_CTL function mux definitions */
#define IOC_PA15_FUNC_CTL_GPIO_A_15            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA15_FUNC_CTL_GPTMR0_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA15_FUNC_CTL_UART8_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA15_FUNC_CTL_UART8_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PA15_FUNC_CTL_I2C2_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PA15_FUNC_CTL_CAN0_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA15_FUNC_CTL_I2S2_TXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA15_FUNC_CTL_I2S1_TXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA15_FUNC_CTL_DIS0_EN              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)

/* IOC_PA16_FUNC_CTL function mux definitions */
#define IOC_PA16_FUNC_CTL_GPIO_A_16            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA16_FUNC_CTL_GPTMR1_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA16_FUNC_CTL_UART10_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PA16_FUNC_CTL_SPI1_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA16_FUNC_CTL_CAN0_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA16_FUNC_CTL_I2S1_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA16_FUNC_CTL_DIS0_B_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA16_FUNC_CTL_CAM0_XCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA17_FUNC_CTL function mux definitions */
#define IOC_PA17_FUNC_CTL_GPIO_A_17            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA17_FUNC_CTL_GPTMR1_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA17_FUNC_CTL_UART10_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA17_FUNC_CTL_UART10_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PA17_FUNC_CTL_CAN0_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA17_FUNC_CTL_I2S1_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA17_FUNC_CTL_DIS0_B_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA17_FUNC_CTL_CAM0_VSYNC           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA18_FUNC_CTL function mux definitions */
#define IOC_PA18_FUNC_CTL_GPIO_A_18            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA18_FUNC_CTL_UART10_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA18_FUNC_CTL_SPI1_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA18_FUNC_CTL_I2S1_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA18_FUNC_CTL_DIS0_B_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA18_FUNC_CTL_CAM0_D_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA19_FUNC_CTL function mux definitions */
#define IOC_PA19_FUNC_CTL_GPIO_A_19            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA19_FUNC_CTL_GPTMR0_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA19_FUNC_CTL_UART11_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PA19_FUNC_CTL_CAN1_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA19_FUNC_CTL_I2S2_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA19_FUNC_CTL_I2S1_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA19_FUNC_CTL_PWM1_P_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA19_FUNC_CTL_DIS0_HSYNC           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)

/* IOC_PA20_FUNC_CTL function mux definitions */
#define IOC_PA20_FUNC_CTL_GPIO_A_20            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA20_FUNC_CTL_GPTMR0_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PA20_FUNC_CTL_UART11_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA20_FUNC_CTL_UART11_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PA20_FUNC_CTL_CAN1_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA20_FUNC_CTL_I2S2_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA20_FUNC_CTL_I2S1_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA20_FUNC_CTL_PWM1_P_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA20_FUNC_CTL_DIS0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)

/* IOC_PA21_FUNC_CTL function mux definitions */
#define IOC_PA21_FUNC_CTL_GPIO_A_21            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA21_FUNC_CTL_UART11_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA21_FUNC_CTL_SPI1_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA21_FUNC_CTL_I2S3_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA21_FUNC_CTL_DAOL_P               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PA21_FUNC_CTL_PWM0_P_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA21_FUNC_CTL_DIS0_R_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)

/* IOC_PA22_FUNC_CTL function mux definitions */
#define IOC_PA22_FUNC_CTL_GPIO_A_22            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA22_FUNC_CTL_UART11_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA22_FUNC_CTL_I2S1_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA22_FUNC_CTL_DAOR_P               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PA22_FUNC_CTL_PWM0_P_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA22_FUNC_CTL_DIS0_G_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA22_FUNC_CTL_CAM0_D_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA23_FUNC_CTL function mux definitions */
#define IOC_PA23_FUNC_CTL_GPIO_A_23            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA23_FUNC_CTL_UART10_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA23_FUNC_CTL_SPI1_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA23_FUNC_CTL_I2S2_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA23_FUNC_CTL_PWM0_P_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA23_FUNC_CTL_DIS0_G_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA23_FUNC_CTL_CAM0_D_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA24_FUNC_CTL function mux definitions */
#define IOC_PA24_FUNC_CTL_GPIO_A_24            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA24_FUNC_CTL_UART8_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA24_FUNC_CTL_CAN2_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA24_FUNC_CTL_I2S2_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA24_FUNC_CTL_PWM1_P_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA24_FUNC_CTL_DIS0_G_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA24_FUNC_CTL_CAM0_D_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA25_FUNC_CTL function mux definitions */
#define IOC_PA25_FUNC_CTL_GPIO_A_25            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA25_FUNC_CTL_UART8_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA25_FUNC_CTL_CAN2_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA25_FUNC_CTL_I2S2_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA25_FUNC_CTL_PWM1_P_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA25_FUNC_CTL_DIS0_G_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA25_FUNC_CTL_CAM0_D_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA26_FUNC_CTL function mux definitions */
#define IOC_PA26_FUNC_CTL_GPIO_A_26            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA26_FUNC_CTL_UART12_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA26_FUNC_CTL_SPI2_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA26_FUNC_CTL_I2S3_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA26_FUNC_CTL_DAOL_N               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PA26_FUNC_CTL_PWM0_P_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA26_FUNC_CTL_DIS0_R_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)

/* IOC_PA27_FUNC_CTL function mux definitions */
#define IOC_PA27_FUNC_CTL_GPIO_A_27            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA27_FUNC_CTL_UART12_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA27_FUNC_CTL_SPI2_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA27_FUNC_CTL_I2S3_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA27_FUNC_CTL_DAOR_N               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PA27_FUNC_CTL_PWM0_P_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA27_FUNC_CTL_DIS0_R_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)

/* IOC_PA28_FUNC_CTL function mux definitions */
#define IOC_PA28_FUNC_CTL_GPIO_A_28            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA28_FUNC_CTL_UART13_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA28_FUNC_CTL_I2S3_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA28_FUNC_CTL_PWM0_P_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA28_FUNC_CTL_DIS0_R_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA28_FUNC_CTL_CAM0_D_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA29_FUNC_CTL function mux definitions */
#define IOC_PA29_FUNC_CTL_GPIO_A_29            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA29_FUNC_CTL_UART9_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA29_FUNC_CTL_CAN3_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA29_FUNC_CTL_I2S2_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA29_FUNC_CTL_I2S3_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA29_FUNC_CTL_PWM1_P_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA29_FUNC_CTL_DIS0_G_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA29_FUNC_CTL_CAM0_D_9             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA30_FUNC_CTL function mux definitions */
#define IOC_PA30_FUNC_CTL_GPIO_A_30            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA30_FUNC_CTL_UART9_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PA30_FUNC_CTL_CAN3_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PA30_FUNC_CTL_I2S2_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PA30_FUNC_CTL_I2S3_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA30_FUNC_CTL_PWM1_P_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA30_FUNC_CTL_DIS0_G_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PA30_FUNC_CTL_CAM0_D_8             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PA31_FUNC_CTL function mux definitions */
#define IOC_PA31_FUNC_CTL_GPIO_A_31            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PA31_FUNC_CTL_UART13_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PA31_FUNC_CTL_I2C1_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PA31_FUNC_CTL_SPI2_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PA31_FUNC_CTL_I2S3_TXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PA31_FUNC_CTL_PWM0_P_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PA31_FUNC_CTL_DIS0_R_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)

/* IOC_PB00_FUNC_CTL function mux definitions */
#define IOC_PB00_FUNC_CTL_GPIO_B_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB00_FUNC_CTL_UART13_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB00_FUNC_CTL_UART13_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB00_FUNC_CTL_I2C1_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PB00_FUNC_CTL_SPI2_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB00_FUNC_CTL_I2S3_TXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PB00_FUNC_CTL_PWM0_P_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB00_FUNC_CTL_DIS0_R_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)

/* IOC_PB01_FUNC_CTL function mux definitions */
#define IOC_PB01_FUNC_CTL_GPIO_B_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB01_FUNC_CTL_UART14_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB01_FUNC_CTL_I2S2_RXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB01_FUNC_CTL_I2S3_RXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PB01_FUNC_CTL_PWM1_P_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB01_FUNC_CTL_DIS0_G_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PB01_FUNC_CTL_SYSCTL_CLK_OBS_1     IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PB02_FUNC_CTL function mux definitions */
#define IOC_PB02_FUNC_CTL_GPIO_B_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB02_FUNC_CTL_UART14_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB02_FUNC_CTL_I2S2_RXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB02_FUNC_CTL_I2S3_RXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PB02_FUNC_CTL_PWM1_P_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB02_FUNC_CTL_DIS0_B_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PB02_FUNC_CTL_SYSCTL_CLK_OBS_0     IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PB03_FUNC_CTL function mux definitions */
#define IOC_PB03_FUNC_CTL_GPIO_B_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB03_FUNC_CTL_UART14_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB03_FUNC_CTL_I2C2_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PB03_FUNC_CTL_I2S3_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PB03_FUNC_CTL_TRGM0_P_11           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB03_FUNC_CTL_DIS0_R_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PB03_FUNC_CTL_CAM1_D_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB04_FUNC_CTL function mux definitions */
#define IOC_PB04_FUNC_CTL_GPIO_B_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB04_FUNC_CTL_UART14_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB04_FUNC_CTL_UART14_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB04_FUNC_CTL_I2C2_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PB04_FUNC_CTL_I2S3_RXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB04_FUNC_CTL_I2S2_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PB04_FUNC_CTL_TRGM0_P_10           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB04_FUNC_CTL_DIS0_R_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PB04_FUNC_CTL_CAM1_D_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB05_FUNC_CTL function mux definitions */
#define IOC_PB05_FUNC_CTL_GPIO_B_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB05_FUNC_CTL_UART13_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB05_FUNC_CTL_I2S3_RXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB05_FUNC_CTL_I2S2_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PB05_FUNC_CTL_TRGM0_P_08           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB05_FUNC_CTL_DIS0_B_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PB05_FUNC_CTL_CAM1_D_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB06_FUNC_CTL function mux definitions */
#define IOC_PB06_FUNC_CTL_GPIO_B_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB06_FUNC_CTL_UART15_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB06_FUNC_CTL_I2S3_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB06_FUNC_CTL_TRGM1_P_05           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB06_FUNC_CTL_DIS0_G_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PB06_FUNC_CTL_CAM1_PIXCLK          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)
#define IOC_PB06_FUNC_CTL_SYSCTL_CLK_OBS_2     IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PB07_FUNC_CTL function mux definitions */
#define IOC_PB07_FUNC_CTL_GPIO_B_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB07_FUNC_CTL_UART15_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB07_FUNC_CTL_I2S3_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB07_FUNC_CTL_TRGM1_P_02           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB07_FUNC_CTL_DIS0_B_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(20)
#define IOC_PB07_FUNC_CTL_CAM1_HSYNC           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)
#define IOC_PB07_FUNC_CTL_SYSCTL_CLK_OBS_3     IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PB08_FUNC_CTL function mux definitions */
#define IOC_PB08_FUNC_CTL_GPIO_B_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB08_FUNC_CTL_UART2_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB08_FUNC_CTL_CAN2_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB08_FUNC_CTL_I2S3_TXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB08_FUNC_CTL_I2S2_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PB08_FUNC_CTL_TRGM0_P_09           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB08_FUNC_CTL_CAM1_D_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB09_FUNC_CTL function mux definitions */
#define IOC_PB09_FUNC_CTL_GPIO_B_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB09_FUNC_CTL_UART2_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB09_FUNC_CTL_UART2_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB09_FUNC_CTL_CAN2_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB09_FUNC_CTL_I2S3_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB09_FUNC_CTL_I2S2_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PB09_FUNC_CTL_TRGM0_P_07           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB09_FUNC_CTL_CAM1_D_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB10_FUNC_CTL function mux definitions */
#define IOC_PB10_FUNC_CTL_GPIO_B_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB10_FUNC_CTL_UART12_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB10_FUNC_CTL_I2C0_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PB10_FUNC_CTL_CAN3_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB10_FUNC_CTL_I2S3_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB10_FUNC_CTL_TRGM1_P_04           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB10_FUNC_CTL_CAM1_XCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB11_FUNC_CTL function mux definitions */
#define IOC_PB11_FUNC_CTL_GPIO_B_11            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB11_FUNC_CTL_UART12_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB11_FUNC_CTL_UART12_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB11_FUNC_CTL_I2C0_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PB11_FUNC_CTL_CAN2_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB11_FUNC_CTL_I2S3_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB11_FUNC_CTL_TRGM1_P_01           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB11_FUNC_CTL_CAM1_VSYNC           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB12_FUNC_CTL function mux definitions */
#define IOC_PB12_FUNC_CTL_GPIO_B_12            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB12_FUNC_CTL_UART3_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB12_FUNC_CTL_UART3_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB12_FUNC_CTL_CAN3_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB12_FUNC_CTL_I2S3_TXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB12_FUNC_CTL_I2S2_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PB12_FUNC_CTL_TRGM0_P_06           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB12_FUNC_CTL_CAM1_D_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB13_FUNC_CTL function mux definitions */
#define IOC_PB13_FUNC_CTL_GPIO_B_13            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB13_FUNC_CTL_UART15_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB13_FUNC_CTL_I2C3_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PB13_FUNC_CTL_CAN1_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB13_FUNC_CTL_I2S3_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB13_FUNC_CTL_TRGM1_P_03           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB13_FUNC_CTL_CAM1_D_8             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB14_FUNC_CTL function mux definitions */
#define IOC_PB14_FUNC_CTL_GPIO_B_14            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB14_FUNC_CTL_UART15_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB14_FUNC_CTL_UART15_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB14_FUNC_CTL_I2C3_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PB14_FUNC_CTL_CAN0_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB14_FUNC_CTL_I2S3_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PB14_FUNC_CTL_TRGM1_P_00           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB14_FUNC_CTL_CAM1_D_9             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(22)

/* IOC_PB15_FUNC_CTL function mux definitions */
#define IOC_PB15_FUNC_CTL_GPIO_B_15            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB15_FUNC_CTL_UART0_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB15_FUNC_CTL_UART0_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB15_FUNC_CTL_CAN0_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB15_FUNC_CTL_DAOR_P               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PB15_FUNC_CTL_PWM0_FAULT_0         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PB15_FUNC_CTL_SOC_REF0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PB16_FUNC_CTL function mux definitions */
#define IOC_PB16_FUNC_CTL_GPIO_B_16            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB16_FUNC_CTL_UART0_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB16_FUNC_CTL_DAOR_N               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PB16_FUNC_CTL_PWM1_FAULT_1         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB17_FUNC_CTL function mux definitions */
#define IOC_PB17_FUNC_CTL_GPIO_B_17            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB17_FUNC_CTL_UART0_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB17_FUNC_CTL_CAN0_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB17_FUNC_CTL_DAOL_P               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PB17_FUNC_CTL_PWM0_FAULT_1         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB18_FUNC_CTL function mux definitions */
#define IOC_PB18_FUNC_CTL_GPIO_B_18            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB18_FUNC_CTL_UART1_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB18_FUNC_CTL_CAN1_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB18_FUNC_CTL_DAOL_N               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PB18_FUNC_CTL_FEMC_DQ_25           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB18_FUNC_CTL_PWM1_P_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB19_FUNC_CTL function mux definitions */
#define IOC_PB19_FUNC_CTL_GPIO_B_19            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB19_FUNC_CTL_UART1_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB19_FUNC_CTL_UART1_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB19_FUNC_CTL_CAN1_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB19_FUNC_CTL_FEMC_DQ_24           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB19_FUNC_CTL_PWM1_P_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB20_FUNC_CTL function mux definitions */
#define IOC_PB20_FUNC_CTL_GPIO_B_20            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB20_FUNC_CTL_UART3_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PB20_FUNC_CTL_SPI2_DAT3            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB20_FUNC_CTL_CAN3_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PB20_FUNC_CTL_FEMC_DQ_23           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB20_FUNC_CTL_PWM0_P_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB21_FUNC_CTL function mux definitions */
#define IOC_PB21_FUNC_CTL_GPIO_B_21            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB21_FUNC_CTL_UART2_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB21_FUNC_CTL_SPI2_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB21_FUNC_CTL_FEMC_DQ_27           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB21_FUNC_CTL_PWM1_P_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB22_FUNC_CTL function mux definitions */
#define IOC_PB22_FUNC_CTL_GPIO_B_22            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB22_FUNC_CTL_UART2_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB22_FUNC_CTL_SPI2_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB22_FUNC_CTL_FEMC_DQ_26           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB22_FUNC_CTL_PWM1_P_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB23_FUNC_CTL function mux definitions */
#define IOC_PB23_FUNC_CTL_GPIO_B_23            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB23_FUNC_CTL_UART0_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB23_FUNC_CTL_SPI2_DAT2            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB23_FUNC_CTL_FEMC_DQ_22           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB23_FUNC_CTL_PWM0_P_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB24_FUNC_CTL function mux definitions */
#define IOC_PB24_FUNC_CTL_GPIO_B_24            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB24_FUNC_CTL_UART3_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB24_FUNC_CTL_SPI2_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB24_FUNC_CTL_FEMC_DQ_29           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB24_FUNC_CTL_PWM1_P_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB25_FUNC_CTL function mux definitions */
#define IOC_PB25_FUNC_CTL_GPIO_B_25            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB25_FUNC_CTL_UART3_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB25_FUNC_CTL_SPI2_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB25_FUNC_CTL_FEMC_DQ_28           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB25_FUNC_CTL_PWM1_P_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB26_FUNC_CTL function mux definitions */
#define IOC_PB26_FUNC_CTL_GPIO_B_26            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB26_FUNC_CTL_UART1_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB26_FUNC_CTL_FEMC_DQ_21           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB26_FUNC_CTL_PWM0_P_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB27_FUNC_CTL function mux definitions */
#define IOC_PB27_FUNC_CTL_GPIO_B_27            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB27_FUNC_CTL_UART1_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB27_FUNC_CTL_FEMC_DQ_20           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB27_FUNC_CTL_PWM0_P_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB28_FUNC_CTL function mux definitions */
#define IOC_PB28_FUNC_CTL_GPIO_B_28            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB28_FUNC_CTL_UART0_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB28_FUNC_CTL_SPI3_DAT2            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB28_FUNC_CTL_FEMC_DQ_19           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB28_FUNC_CTL_PWM0_P_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB29_FUNC_CTL function mux definitions */
#define IOC_PB29_FUNC_CTL_GPIO_B_29            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB29_FUNC_CTL_UART4_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB29_FUNC_CTL_SPI3_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB29_FUNC_CTL_FEMC_DQ_31           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB29_FUNC_CTL_PWM1_P_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB30_FUNC_CTL function mux definitions */
#define IOC_PB30_FUNC_CTL_GPIO_B_30            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB30_FUNC_CTL_UART4_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB30_FUNC_CTL_SPI3_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PB30_FUNC_CTL_FEMC_DQ_30           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB30_FUNC_CTL_PWM1_P_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PB31_FUNC_CTL function mux definitions */
#define IOC_PB31_FUNC_CTL_GPIO_B_31            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PB31_FUNC_CTL_UART5_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PB31_FUNC_CTL_FEMC_DQ_18           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PB31_FUNC_CTL_PWM0_P_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC00_FUNC_CTL function mux definitions */
#define IOC_PC00_FUNC_CTL_GPIO_C_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC00_FUNC_CTL_UART5_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC00_FUNC_CTL_FEMC_DQ_17           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC00_FUNC_CTL_PWM0_P_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC01_FUNC_CTL function mux definitions */
#define IOC_PC01_FUNC_CTL_GPIO_C_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC01_FUNC_CTL_UART6_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC01_FUNC_CTL_SPI3_DAT3            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PC01_FUNC_CTL_FEMC_DQ_16           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC01_FUNC_CTL_PWM0_P_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC02_FUNC_CTL function mux definitions */
#define IOC_PC02_FUNC_CTL_GPIO_C_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC02_FUNC_CTL_UART7_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC02_FUNC_CTL_SPI3_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PC02_FUNC_CTL_FEMC_DM_2            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC02_FUNC_CTL_TRGM0_P_03           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC03_FUNC_CTL function mux definitions */
#define IOC_PC03_FUNC_CTL_GPIO_C_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC03_FUNC_CTL_UART7_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC03_FUNC_CTL_SPI3_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PC03_FUNC_CTL_FEMC_DM_3            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC03_FUNC_CTL_PWM1_FAULT_0         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC04_FUNC_CTL function mux definitions */
#define IOC_PC04_FUNC_CTL_GPIO_C_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC04_FUNC_CTL_UART10_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC04_FUNC_CTL_FEMC_A_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC04_FUNC_CTL_TRGM1_P_11           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC05_FUNC_CTL function mux definitions */
#define IOC_PC05_FUNC_CTL_GPIO_C_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC05_FUNC_CTL_UART10_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC05_FUNC_CTL_FEMC_A_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC05_FUNC_CTL_TRGM1_P_09           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC06_FUNC_CTL function mux definitions */
#define IOC_PC06_FUNC_CTL_GPIO_C_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC06_FUNC_CTL_UART8_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC06_FUNC_CTL_FEMC_A_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC06_FUNC_CTL_XPI1_CB_D_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC06_FUNC_CTL_TRGM0_P_04           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC07_FUNC_CTL function mux definitions */
#define IOC_PC07_FUNC_CTL_GPIO_C_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC07_FUNC_CTL_UART8_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC07_FUNC_CTL_FEMC_A_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC07_FUNC_CTL_XPI1_CB_D_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC07_FUNC_CTL_TRGM0_P_02           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC08_FUNC_CTL function mux definitions */
#define IOC_PC08_FUNC_CTL_GPIO_C_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC08_FUNC_CTL_UART11_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC08_FUNC_CTL_FEMC_A_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC08_FUNC_CTL_TRGM1_P_10           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC08_FUNC_CTL_ETH1_EVTO_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC09_FUNC_CTL function mux definitions */
#define IOC_PC09_FUNC_CTL_GPIO_C_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC09_FUNC_CTL_UART11_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC09_FUNC_CTL_FEMC_A_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC09_FUNC_CTL_XPI1_CB_CS1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC09_FUNC_CTL_TRGM1_P_08           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC09_FUNC_CTL_ETH1_EVTO_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC10_FUNC_CTL function mux definitions */
#define IOC_PC10_FUNC_CTL_GPIO_C_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC10_FUNC_CTL_UART6_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC10_FUNC_CTL_FEMC_A_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC10_FUNC_CTL_XPI1_CB_CS0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC10_FUNC_CTL_TRGM1_P_07           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC11_FUNC_CTL function mux definitions */
#define IOC_PC11_FUNC_CTL_GPIO_C_11            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC11_FUNC_CTL_UART9_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC11_FUNC_CTL_FEMC_A_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC11_FUNC_CTL_XPI1_CB_D_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC11_FUNC_CTL_TRGM0_P_05           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC12_FUNC_CTL function mux definitions */
#define IOC_PC12_FUNC_CTL_GPIO_C_12            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC12_FUNC_CTL_UART9_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC12_FUNC_CTL_FEMC_A_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC12_FUNC_CTL_XPI1_CB_D_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC12_FUNC_CTL_TRGM0_P_01           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC13_FUNC_CTL function mux definitions */
#define IOC_PC13_FUNC_CTL_GPIO_C_13            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC13_FUNC_CTL_UART13_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC13_FUNC_CTL_FEMC_BA0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC13_FUNC_CTL_ETH1_EVTO_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC14_FUNC_CTL function mux definitions */
#define IOC_PC14_FUNC_CTL_GPIO_C_14            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC14_FUNC_CTL_UART13_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC14_FUNC_CTL_FEMC_BA1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC14_FUNC_CTL_XPI1_CB_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC14_FUNC_CTL_TRGM3_P_07           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC14_FUNC_CTL_ETH1_EVTO_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC15_FUNC_CTL function mux definitions */
#define IOC_PC15_FUNC_CTL_GPIO_C_15            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC15_FUNC_CTL_UART12_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC15_FUNC_CTL_FEMC_A_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC15_FUNC_CTL_XPI1_CB_SCLK         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC15_FUNC_CTL_TRGM1_P_06           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC16_FUNC_CTL function mux definitions */
#define IOC_PC16_FUNC_CTL_GPIO_C_16            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC16_FUNC_CTL_UART14_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC16_FUNC_CTL_FEMC_DQS             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC16_FUNC_CTL_XPI1_CA_CS0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC16_FUNC_CTL_TRGM2_P_02           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC17_FUNC_CTL function mux definitions */
#define IOC_PC17_FUNC_CTL_GPIO_C_17            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC17_FUNC_CTL_UART14_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC17_FUNC_CTL_FEMC_A_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC17_FUNC_CTL_XPI1_CA_SCLK         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC17_FUNC_CTL_TRGM0_P_00           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC18_FUNC_CTL function mux definitions */
#define IOC_PC18_FUNC_CTL_GPIO_C_18            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC18_FUNC_CTL_UART1_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC18_FUNC_CTL_FEMC_RAS             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC18_FUNC_CTL_TRGM3_P_10           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC18_FUNC_CTL_ETH1_EVTI_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC19_FUNC_CTL function mux definitions */
#define IOC_PC19_FUNC_CTL_GPIO_C_19            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC19_FUNC_CTL_UART1_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC19_FUNC_CTL_FEMC_CS_0            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC19_FUNC_CTL_XPI1_CA_CS1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC19_FUNC_CTL_TRGM3_P_08           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC19_FUNC_CTL_ETH1_EVTI_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC20_FUNC_CTL function mux definitions */
#define IOC_PC20_FUNC_CTL_GPIO_C_20            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC20_FUNC_CTL_UART12_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC20_FUNC_CTL_FEMC_CS_1            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC20_FUNC_CTL_XPI1_CA_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC20_FUNC_CTL_TRGM3_P_06           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC21_FUNC_CTL function mux definitions */
#define IOC_PC21_FUNC_CTL_GPIO_C_21            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC21_FUNC_CTL_UART15_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC21_FUNC_CTL_FEMC_A_11            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC21_FUNC_CTL_XPI1_CA_D_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC21_FUNC_CTL_TRGM2_P_03           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC22_FUNC_CTL function mux definitions */
#define IOC_PC22_FUNC_CTL_GPIO_C_22            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC22_FUNC_CTL_UART15_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC22_FUNC_CTL_FEMC_A_12            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC22_FUNC_CTL_XPI1_CA_D_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC22_FUNC_CTL_TRGM2_P_00           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC23_FUNC_CTL function mux definitions */
#define IOC_PC23_FUNC_CTL_GPIO_C_23            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC23_FUNC_CTL_UART2_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC23_FUNC_CTL_FEMC_CAS             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC23_FUNC_CTL_TRGM3_P_11           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC23_FUNC_CTL_ETH1_EVTI_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC24_FUNC_CTL function mux definitions */
#define IOC_PC24_FUNC_CTL_GPIO_C_24            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC24_FUNC_CTL_UART2_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC24_FUNC_CTL_FEMC_WE              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC24_FUNC_CTL_TRGM3_P_09           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC24_FUNC_CTL_ETH1_EVTI_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC25_FUNC_CTL function mux definitions */
#define IOC_PC25_FUNC_CTL_GPIO_C_25            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC25_FUNC_CTL_UART0_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC25_FUNC_CTL_FEMC_CKE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC25_FUNC_CTL_XPI1_CA_D_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC25_FUNC_CTL_TRGM2_P_04           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC26_FUNC_CTL function mux definitions */
#define IOC_PC26_FUNC_CTL_GPIO_C_26            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC26_FUNC_CTL_UART0_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC26_FUNC_CTL_FEMC_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC26_FUNC_CTL_XPI1_CA_D_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC26_FUNC_CTL_TRGM2_P_01           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC27_FUNC_CTL function mux definitions */
#define IOC_PC27_FUNC_CTL_GPIO_C_27            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC27_FUNC_CTL_UART6_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC27_FUNC_CTL_FEMC_DQ_05           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC27_FUNC_CTL_PWM3_P_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC27_FUNC_CTL_ETH1_EVTO_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC28_FUNC_CTL function mux definitions */
#define IOC_PC28_FUNC_CTL_GPIO_C_28            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC28_FUNC_CTL_UART6_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC28_FUNC_CTL_FEMC_DQ_06           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC28_FUNC_CTL_PWM3_P_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC28_FUNC_CTL_ETH1_EVTO_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC29_FUNC_CTL function mux definitions */
#define IOC_PC29_FUNC_CTL_GPIO_C_29            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC29_FUNC_CTL_UART7_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC29_FUNC_CTL_FEMC_DQ_07           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC29_FUNC_CTL_XPI1_CB_CS1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC29_FUNC_CTL_PWM3_P_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PC29_FUNC_CTL_ETH1_EVTI_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PC30_FUNC_CTL function mux definitions */
#define IOC_PC30_FUNC_CTL_GPIO_C_30            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC30_FUNC_CTL_UART3_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC30_FUNC_CTL_FEMC_DM_0            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC30_FUNC_CTL_XPI1_CB_CS0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC30_FUNC_CTL_TRGM2_P_05           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PC31_FUNC_CTL function mux definitions */
#define IOC_PC31_FUNC_CTL_GPIO_C_31            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PC31_FUNC_CTL_UART3_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PC31_FUNC_CTL_FEMC_DM_1            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PC31_FUNC_CTL_XPI1_CB_SCLK         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PC31_FUNC_CTL_PWM2_FAULT_0         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PD00_FUNC_CTL function mux definitions */
#define IOC_PD00_FUNC_CTL_GPIO_D_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD00_FUNC_CTL_UART4_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD00_FUNC_CTL_I2C0_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PD00_FUNC_CTL_FEMC_DQ_02           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD00_FUNC_CTL_PWM3_P_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD00_FUNC_CTL_ETH1_EVTO_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PD01_FUNC_CTL function mux definitions */
#define IOC_PD01_FUNC_CTL_GPIO_D_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD01_FUNC_CTL_UART4_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD01_FUNC_CTL_UART4_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD01_FUNC_CTL_I2C0_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PD01_FUNC_CTL_FEMC_DQ_03           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD01_FUNC_CTL_PWM3_P_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD01_FUNC_CTL_ETH1_EVTO_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PD02_FUNC_CTL function mux definitions */
#define IOC_PD02_FUNC_CTL_GPIO_D_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD02_FUNC_CTL_UART7_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD02_FUNC_CTL_FEMC_DQ_04           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD02_FUNC_CTL_XPI1_CB_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD02_FUNC_CTL_PWM3_P_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD02_FUNC_CTL_ETH1_EVTI_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PD03_FUNC_CTL function mux definitions */
#define IOC_PD03_FUNC_CTL_GPIO_D_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD03_FUNC_CTL_UART4_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD03_FUNC_CTL_FEMC_DQ_09           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD03_FUNC_CTL_XPI1_CB_D_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD03_FUNC_CTL_PWM2_P_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PD04_FUNC_CTL function mux definitions */
#define IOC_PD04_FUNC_CTL_GPIO_D_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD04_FUNC_CTL_UART4_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD04_FUNC_CTL_FEMC_DQ_08           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD04_FUNC_CTL_XPI1_CB_D_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD04_FUNC_CTL_PWM2_P_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PD05_FUNC_CTL function mux definitions */
#define IOC_PD05_FUNC_CTL_GPIO_D_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD05_FUNC_CTL_UART5_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD05_FUNC_CTL_UART5_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD05_FUNC_CTL_I2C1_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PD05_FUNC_CTL_FEMC_DQ_01           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD05_FUNC_CTL_PWM3_P_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD05_FUNC_CTL_ETH1_EVTI_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PD06_FUNC_CTL function mux definitions */
#define IOC_PD06_FUNC_CTL_GPIO_D_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD06_FUNC_CTL_UART5_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD06_FUNC_CTL_FEMC_DQ_11           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD06_FUNC_CTL_XPI1_CB_D_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD06_FUNC_CTL_PWM2_P_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PD07_FUNC_CTL function mux definitions */
#define IOC_PD07_FUNC_CTL_GPIO_D_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD07_FUNC_CTL_UART5_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD07_FUNC_CTL_FEMC_DQ_10           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD07_FUNC_CTL_XPI1_CB_D_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD07_FUNC_CTL_PWM2_P_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PD08_FUNC_CTL function mux definitions */
#define IOC_PD08_FUNC_CTL_GPIO_D_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD08_FUNC_CTL_UART5_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD08_FUNC_CTL_I2C1_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PD08_FUNC_CTL_FEMC_DQ_00           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD08_FUNC_CTL_XPI1_CA_CS1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD08_FUNC_CTL_PWM3_P_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD08_FUNC_CTL_ETH1_EVTI_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PD09_FUNC_CTL function mux definitions */
#define IOC_PD09_FUNC_CTL_GPIO_D_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD09_FUNC_CTL_UART6_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD09_FUNC_CTL_I2C2_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PD09_FUNC_CTL_CAN2_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD09_FUNC_CTL_FEMC_DQ_13           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD09_FUNC_CTL_XPI1_CA_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD09_FUNC_CTL_PWM2_P_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PD10_FUNC_CTL function mux definitions */
#define IOC_PD10_FUNC_CTL_GPIO_D_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD10_FUNC_CTL_UART6_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD10_FUNC_CTL_UART6_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD10_FUNC_CTL_I2C2_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PD10_FUNC_CTL_CAN0_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD10_FUNC_CTL_FEMC_DQ_12           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD10_FUNC_CTL_XPI1_CA_SCLK         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD10_FUNC_CTL_PWM2_P_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PD11_FUNC_CTL function mux definitions */
#define IOC_PD11_FUNC_CTL_GPIO_D_11            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD11_FUNC_CTL_UART8_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD11_FUNC_CTL_CAN0_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD11_FUNC_CTL_XPI1_CA_D_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD11_FUNC_CTL_PWM3_FAULT_1         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD11_FUNC_CTL_ETH1_MDC             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PD12_FUNC_CTL function mux definitions */
#define IOC_PD12_FUNC_CTL_GPIO_D_12            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD12_FUNC_CTL_UART7_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD12_FUNC_CTL_I2C3_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PD12_FUNC_CTL_CAN3_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD12_FUNC_CTL_FEMC_DQ_15           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD12_FUNC_CTL_XPI1_CA_D_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD12_FUNC_CTL_PWM2_P_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD12_FUNC_CTL_ETH0_MDC             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PD13_FUNC_CTL function mux definitions */
#define IOC_PD13_FUNC_CTL_GPIO_D_13            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD13_FUNC_CTL_UART7_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD13_FUNC_CTL_UART7_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD13_FUNC_CTL_I2C3_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PD13_FUNC_CTL_CAN1_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD13_FUNC_CTL_FEMC_DQ_14           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PD13_FUNC_CTL_XPI1_CA_CS0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD13_FUNC_CTL_PWM2_P_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PD14_FUNC_CTL function mux definitions */
#define IOC_PD14_FUNC_CTL_GPIO_D_14            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD14_FUNC_CTL_UART8_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD14_FUNC_CTL_UART8_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD14_FUNC_CTL_CAN0_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD14_FUNC_CTL_XPI1_CA_D_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD14_FUNC_CTL_PWM3_FAULT_0         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD14_FUNC_CTL_ETH1_MDIO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PD15_FUNC_CTL function mux definitions */
#define IOC_PD15_FUNC_CTL_GPIO_D_15            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD15_FUNC_CTL_UART8_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD15_FUNC_CTL_XPI1_CA_D_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD15_FUNC_CTL_PWM2_FAULT_1         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD15_FUNC_CTL_ETH0_MDIO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PD16_FUNC_CTL function mux definitions */
#define IOC_PD16_FUNC_CTL_GPIO_D_16            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD16_FUNC_CTL_UART9_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD16_FUNC_CTL_UART9_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD16_FUNC_CTL_CAN1_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD16_FUNC_CTL_TRGM2_P_06           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD16_FUNC_CTL_SDC1_DATA_4          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD16_FUNC_CTL_ETH1_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD17_FUNC_CTL function mux definitions */
#define IOC_PD17_FUNC_CTL_GPIO_D_17            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD17_FUNC_CTL_UART11_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD17_FUNC_CTL_CAN3_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD17_FUNC_CTL_TRGM3_P_03           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD17_FUNC_CTL_SDC1_DATA_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD17_FUNC_CTL_ETH1_RXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD18_FUNC_CTL function mux definitions */
#define IOC_PD18_FUNC_CTL_GPIO_D_18            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD18_FUNC_CTL_UART11_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD18_FUNC_CTL_UART11_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD18_FUNC_CTL_CAN3_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD18_FUNC_CTL_TRGM3_P_00           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD18_FUNC_CTL_SDC1_DATA_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD18_FUNC_CTL_ETH1_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD19_FUNC_CTL function mux definitions */
#define IOC_PD19_FUNC_CTL_GPIO_D_19            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD19_FUNC_CTL_UART9_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD19_FUNC_CTL_SPI0_DAT2            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PD19_FUNC_CTL_CAN1_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD19_FUNC_CTL_TRGM2_P_09           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD19_FUNC_CTL_SDC1_DATA_6          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD19_FUNC_CTL_ETH1_TXEN            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD20_FUNC_CTL function mux definitions */
#define IOC_PD20_FUNC_CTL_GPIO_D_20            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD20_FUNC_CTL_UART10_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD20_FUNC_CTL_UART10_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD20_FUNC_CTL_CAN2_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD20_FUNC_CTL_TRGM2_P_07           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD20_FUNC_CTL_SDC1_DS              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD20_FUNC_CTL_ETH1_TXCK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD21_FUNC_CTL function mux definitions */
#define IOC_PD21_FUNC_CTL_GPIO_D_21            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD21_FUNC_CTL_UART8_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD21_FUNC_CTL_SPI0_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PD21_FUNC_CTL_TRGM3_P_04           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD21_FUNC_CTL_SDC1_CMD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD21_FUNC_CTL_ETH1_RXDV            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD22_FUNC_CTL function mux definitions */
#define IOC_PD22_FUNC_CTL_GPIO_D_22            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD22_FUNC_CTL_UART8_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD22_FUNC_CTL_SPI0_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PD22_FUNC_CTL_TRGM3_P_01           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD22_FUNC_CTL_SDC1_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD22_FUNC_CTL_ETH1_RXCK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD23_FUNC_CTL function mux definitions */
#define IOC_PD23_FUNC_CTL_GPIO_D_23            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD23_FUNC_CTL_UART10_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD23_FUNC_CTL_TRGM2_P_11           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD23_FUNC_CTL_SDC1_RSTN            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD23_FUNC_CTL_ETH1_TXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD24_FUNC_CTL function mux definitions */
#define IOC_PD24_FUNC_CTL_GPIO_D_24            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD24_FUNC_CTL_UART10_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD24_FUNC_CTL_SPI0_DAT3            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PD24_FUNC_CTL_TRGM2_P_10           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD24_FUNC_CTL_SDC1_DATA_7          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD24_FUNC_CTL_ETH1_TXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD25_FUNC_CTL function mux definitions */
#define IOC_PD25_FUNC_CTL_GPIO_D_25            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD25_FUNC_CTL_UART10_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PD25_FUNC_CTL_CAN2_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD25_FUNC_CTL_TRGM2_P_08           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD25_FUNC_CTL_SDC1_DATA_5          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD25_FUNC_CTL_ETH1_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD26_FUNC_CTL function mux definitions */
#define IOC_PD26_FUNC_CTL_GPIO_D_26            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD26_FUNC_CTL_UART9_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD26_FUNC_CTL_SPI0_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PD26_FUNC_CTL_TRGM3_P_05           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD26_FUNC_CTL_SDC1_DATA_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD26_FUNC_CTL_ETH1_RXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD27_FUNC_CTL function mux definitions */
#define IOC_PD27_FUNC_CTL_GPIO_D_27            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD27_FUNC_CTL_UART9_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD27_FUNC_CTL_SPI0_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PD27_FUNC_CTL_TRGM3_P_02           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD27_FUNC_CTL_SDC1_DATA_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD27_FUNC_CTL_ETH1_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD28_FUNC_CTL function mux definitions */
#define IOC_PD28_FUNC_CTL_GPIO_D_28            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD28_FUNC_CTL_UART11_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD28_FUNC_CTL_XPI0_CA_CS1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD28_FUNC_CTL_PWM2_P_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD28_FUNC_CTL_SDC1_CDN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD28_FUNC_CTL_ETH0_TXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD29_FUNC_CTL function mux definitions */
#define IOC_PD29_FUNC_CTL_GPIO_D_29            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD29_FUNC_CTL_UART11_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD29_FUNC_CTL_XPI0_CB_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD29_FUNC_CTL_PWM2_P_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD29_FUNC_CTL_SDC1_VSEL            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PD29_FUNC_CTL_ETH0_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD30_FUNC_CTL function mux definitions */
#define IOC_PD30_FUNC_CTL_GPIO_D_30            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD30_FUNC_CTL_UART14_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD30_FUNC_CTL_SPI1_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PD30_FUNC_CTL_CAN0_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD30_FUNC_CTL_XPI0_CB_D_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD30_FUNC_CTL_PWM2_P_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD30_FUNC_CTL_ETH0_RXDV            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PD31_FUNC_CTL function mux definitions */
#define IOC_PD31_FUNC_CTL_GPIO_D_31            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PD31_FUNC_CTL_UART14_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PD31_FUNC_CTL_SPI1_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PD31_FUNC_CTL_CAN0_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PD31_FUNC_CTL_XPI0_CB_D_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PD31_FUNC_CTL_PWM2_P_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PD31_FUNC_CTL_ETH0_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE00_FUNC_CTL function mux definitions */
#define IOC_PE00_FUNC_CTL_GPIO_E_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE00_FUNC_CTL_UART12_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE00_FUNC_CTL_XPI0_CA_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE00_FUNC_CTL_PWM2_P_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE00_FUNC_CTL_SDC1_WP              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE00_FUNC_CTL_ETH0_TXEN            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE01_FUNC_CTL function mux definitions */
#define IOC_PE01_FUNC_CTL_GPIO_E_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE01_FUNC_CTL_UART12_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE01_FUNC_CTL_XPI0_CB_CS1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE01_FUNC_CTL_PWM2_P_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE01_FUNC_CTL_SDC0_CDN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE01_FUNC_CTL_ETH0_TXCK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE02_FUNC_CTL function mux definitions */
#define IOC_PE02_FUNC_CTL_GPIO_E_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE02_FUNC_CTL_UART13_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE02_FUNC_CTL_SPI1_DAT2            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE02_FUNC_CTL_XPI0_CB_CS0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE02_FUNC_CTL_PWM3_P_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE02_FUNC_CTL_ETH0_RXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE03_FUNC_CTL function mux definitions */
#define IOC_PE03_FUNC_CTL_GPIO_E_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE03_FUNC_CTL_UART15_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE03_FUNC_CTL_SPI1_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE03_FUNC_CTL_CAN1_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE03_FUNC_CTL_XPI0_CB_D_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE03_FUNC_CTL_PWM2_P_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE03_FUNC_CTL_ETH0_RXCK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE04_FUNC_CTL function mux definitions */
#define IOC_PE04_FUNC_CTL_GPIO_E_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE04_FUNC_CTL_UART15_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE04_FUNC_CTL_SPI1_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE04_FUNC_CTL_CAN1_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE04_FUNC_CTL_XPI0_CB_D_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE04_FUNC_CTL_PWM2_P_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE04_FUNC_CTL_ETH0_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE05_FUNC_CTL function mux definitions */
#define IOC_PE05_FUNC_CTL_GPIO_E_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE05_FUNC_CTL_UART13_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE05_FUNC_CTL_CAN3_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE05_FUNC_CTL_PWM3_P_4             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE05_FUNC_CTL_SDC0_WP              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE05_FUNC_CTL_ETH0_TXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE06_FUNC_CTL function mux definitions */
#define IOC_PE06_FUNC_CTL_GPIO_E_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE06_FUNC_CTL_UART13_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE06_FUNC_CTL_UART13_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE06_FUNC_CTL_CAN3_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE06_FUNC_CTL_PWM3_P_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE06_FUNC_CTL_SDC0_VSEL            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE06_FUNC_CTL_ETH0_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE07_FUNC_CTL function mux definitions */
#define IOC_PE07_FUNC_CTL_GPIO_E_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE07_FUNC_CTL_UART13_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE07_FUNC_CTL_SPI1_DAT3            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE07_FUNC_CTL_XPI0_CB_SCLK         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE07_FUNC_CTL_PWM3_P_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE07_FUNC_CTL_ETH0_RXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE08_FUNC_CTL function mux definitions */
#define IOC_PE08_FUNC_CTL_GPIO_E_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE08_FUNC_CTL_UART12_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE08_FUNC_CTL_CAN2_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE08_FUNC_CTL_XPI0_CA_CS0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE08_FUNC_CTL_SDC0_DATA_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE08_FUNC_CTL_ETH0_MDC             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE09_FUNC_CTL function mux definitions */
#define IOC_PE09_FUNC_CTL_GPIO_E_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE09_FUNC_CTL_UART12_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE09_FUNC_CTL_UART12_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE09_FUNC_CTL_CAN2_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE09_FUNC_CTL_XPI0_CA_SCLK         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE09_FUNC_CTL_SDC0_DATA_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE09_FUNC_CTL_ETH0_MDIO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE10_FUNC_CTL function mux definitions */
#define IOC_PE10_FUNC_CTL_GPIO_E_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE10_FUNC_CTL_UART15_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE10_FUNC_CTL_I2C1_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PE10_FUNC_CTL_CAN0_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE10_FUNC_CTL_XPI0_CA_D_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE10_FUNC_CTL_SDC0_CMD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE10_FUNC_CTL_ETH1_MDC             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE11_FUNC_CTL function mux definitions */
#define IOC_PE11_FUNC_CTL_GPIO_E_11            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE11_FUNC_CTL_UART15_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE11_FUNC_CTL_UART15_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE11_FUNC_CTL_I2C1_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PE11_FUNC_CTL_CAN1_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE11_FUNC_CTL_XPI0_CA_D_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE11_FUNC_CTL_SDC0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE11_FUNC_CTL_ETH1_MDIO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE12_FUNC_CTL function mux definitions */
#define IOC_PE12_FUNC_CTL_GPIO_E_12            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE12_FUNC_CTL_UART0_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE12_FUNC_CTL_I2C2_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PE12_FUNC_CTL_CAN2_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE12_FUNC_CTL_XPI0_CA_D_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE12_FUNC_CTL_SDC0_DATA_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)

/* IOC_PE13_FUNC_CTL function mux definitions */
#define IOC_PE13_FUNC_CTL_GPIO_E_13            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE13_FUNC_CTL_UART0_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE13_FUNC_CTL_I2C2_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PE13_FUNC_CTL_CAN3_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE13_FUNC_CTL_XPI0_CA_D_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PE13_FUNC_CTL_SDC0_DATA_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)

/* IOC_PE14_FUNC_CTL function mux definitions */
#define IOC_PE14_FUNC_CTL_GPIO_E_14            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE14_FUNC_CTL_GPTMR3_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE14_FUNC_CTL_UART14_CTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE14_FUNC_CTL_I2C0_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PE14_FUNC_CTL_I2S0_TXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE14_FUNC_CTL_PWM3_P_5             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE14_FUNC_CTL_SDC1_WP              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE14_FUNC_CTL_ETH1_TXEN            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE14_FUNC_CTL_ETH0_EVTO_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE15_FUNC_CTL function mux definitions */
#define IOC_PE15_FUNC_CTL_GPIO_E_15            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE15_FUNC_CTL_UART14_DE            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE15_FUNC_CTL_UART14_RTS           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE15_FUNC_CTL_I2C0_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PE15_FUNC_CTL_I2S0_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE15_FUNC_CTL_SDC1_CDN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE15_FUNC_CTL_ETH1_RXDV            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE15_FUNC_CTL_ETH0_EVTO_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE16_FUNC_CTL function mux definitions */
#define IOC_PE16_FUNC_CTL_GPIO_E_16            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE16_FUNC_CTL_GPTMR2_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE16_FUNC_CTL_UART2_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE16_FUNC_CTL_I2S0_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE16_FUNC_CTL_PWM3_P_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE16_FUNC_CTL_SDC1_VSEL            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE16_FUNC_CTL_ETH1_REFCLK          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE17_FUNC_CTL function mux definitions */
#define IOC_PE17_FUNC_CTL_GPIO_E_17            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE17_FUNC_CTL_GPTMR3_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE17_FUNC_CTL_UART3_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE17_FUNC_CTL_I2S0_TXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE17_FUNC_CTL_PWM3_P_6             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE17_FUNC_CTL_SDC0_WP              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE17_FUNC_CTL_ETH1_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE17_FUNC_CTL_ETH0_EVTO_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE18_FUNC_CTL function mux definitions */
#define IOC_PE18_FUNC_CTL_GPIO_E_18            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE18_FUNC_CTL_GPTMR2_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE18_FUNC_CTL_UART3_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE18_FUNC_CTL_I2S0_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE18_FUNC_CTL_PWM3_P_7             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE18_FUNC_CTL_SDC0_CDN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE18_FUNC_CTL_ETH1_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE18_FUNC_CTL_ETH0_EVTO_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE19_FUNC_CTL function mux definitions */
#define IOC_PE19_FUNC_CTL_GPIO_E_19            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE19_FUNC_CTL_GPTMR3_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE19_FUNC_CTL_UART4_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE19_FUNC_CTL_I2S0_RXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE19_FUNC_CTL_ACMP_COMP_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE19_FUNC_CTL_ETH1_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE19_FUNC_CTL_ETH0_EVTI_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE20_FUNC_CTL function mux definitions */
#define IOC_PE20_FUNC_CTL_GPIO_E_20            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE20_FUNC_CTL_UART4_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE20_FUNC_CTL_I2S0_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE20_FUNC_CTL_ACMP_COMP_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE20_FUNC_CTL_SDC0_VSEL            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE20_FUNC_CTL_ETH1_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE20_FUNC_CTL_ETH0_EVTI_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE21_FUNC_CTL function mux definitions */
#define IOC_PE21_FUNC_CTL_GPIO_E_21            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE21_FUNC_CTL_GPTMR4_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE21_FUNC_CTL_UART2_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE21_FUNC_CTL_I2S0_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE21_FUNC_CTL_PDM0_D_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PE21_FUNC_CTL_SDC0_DATA_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE21_FUNC_CTL_ETH0_RXDV            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE22_FUNC_CTL function mux definitions */
#define IOC_PE22_FUNC_CTL_GPIO_E_22            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE22_FUNC_CTL_GPTMR4_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE22_FUNC_CTL_UART1_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE22_FUNC_CTL_I2C3_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PE22_FUNC_CTL_PDM0_D_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PE22_FUNC_CTL_SDC0_CMD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE22_FUNC_CTL_ETH0_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE22_FUNC_CTL_ETH0_MDC             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE23_FUNC_CTL function mux definitions */
#define IOC_PE23_FUNC_CTL_GPIO_E_23            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE23_FUNC_CTL_GPTMR2_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE23_FUNC_CTL_UART1_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE23_FUNC_CTL_I2C3_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PE23_FUNC_CTL_PDM0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PE23_FUNC_CTL_SDC0_DATA_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE23_FUNC_CTL_ETH0_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE23_FUNC_CTL_ETH0_MDIO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE24_FUNC_CTL function mux definitions */
#define IOC_PE24_FUNC_CTL_GPIO_E_24            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE24_FUNC_CTL_GPTMR3_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE24_FUNC_CTL_UART5_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE24_FUNC_CTL_I2S0_RXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE24_FUNC_CTL_ACMP_COMP_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE24_FUNC_CTL_ETH0_EVTI_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)
#define IOC_PE24_FUNC_CTL_SOC_REF1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PE25_FUNC_CTL function mux definitions */
#define IOC_PE25_FUNC_CTL_GPIO_E_25            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE25_FUNC_CTL_GPTMR4_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE25_FUNC_CTL_UART5_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE25_FUNC_CTL_I2S0_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE25_FUNC_CTL_ACMP_COMP_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)
#define IOC_PE25_FUNC_CTL_ETH0_EVTI_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE26_FUNC_CTL function mux definitions */
#define IOC_PE26_FUNC_CTL_GPIO_E_26            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE26_FUNC_CTL_UART1_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE26_FUNC_CTL_UART1_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE26_FUNC_CTL_SPI2_DAT3            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE26_FUNC_CTL_CAN3_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE26_FUNC_CTL_I2S0_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PE26_FUNC_CTL_SDC0_DATA_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE26_FUNC_CTL_ETH0_TXEN            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PE27_FUNC_CTL function mux definitions */
#define IOC_PE27_FUNC_CTL_GPIO_E_27            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE27_FUNC_CTL_GPTMR4_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE27_FUNC_CTL_UART6_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE27_FUNC_CTL_SPI2_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE27_FUNC_CTL_CAN0_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE27_FUNC_CTL_SDC0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE27_FUNC_CTL_ETH0_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE27_FUNC_CTL_ETH1_MDC             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE28_FUNC_CTL function mux definitions */
#define IOC_PE28_FUNC_CTL_GPIO_E_28            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE28_FUNC_CTL_GPTMR2_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PE28_FUNC_CTL_UART6_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE28_FUNC_CTL_SPI2_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE28_FUNC_CTL_CAN0_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE28_FUNC_CTL_SDC0_DATA_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PE28_FUNC_CTL_ETH0_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)
#define IOC_PE28_FUNC_CTL_ETH1_MDIO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PE29_FUNC_CTL function mux definitions */
#define IOC_PE29_FUNC_CTL_GPIO_E_29            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE29_FUNC_CTL_UART1_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PE29_FUNC_CTL_SPI2_DAT2            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE29_FUNC_CTL_CAN3_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE29_FUNC_CTL_PDM0_D_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PE29_FUNC_CTL_USB0_OC              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PE30_FUNC_CTL function mux definitions */
#define IOC_PE30_FUNC_CTL_GPIO_E_30            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE30_FUNC_CTL_UART7_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE30_FUNC_CTL_SPI2_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE30_FUNC_CTL_CAN1_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE30_FUNC_CTL_PDM0_D_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PE30_FUNC_CTL_USB1_OC              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PE31_FUNC_CTL function mux definitions */
#define IOC_PE31_FUNC_CTL_GPIO_E_31            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PE31_FUNC_CTL_UART7_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PE31_FUNC_CTL_SPI2_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PE31_FUNC_CTL_CAN1_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PE31_FUNC_CTL_PDM0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PE31_FUNC_CTL_ETH0_REFCLK          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(18)

/* IOC_PF00_FUNC_CTL function mux definitions */
#define IOC_PF00_FUNC_CTL_GPIO_F_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF00_FUNC_CTL_UART0_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PF00_FUNC_CTL_UART0_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PF00_FUNC_CTL_CAN2_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PF00_FUNC_CTL_I2S0_TXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF00_FUNC_CTL_PDM0_D_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PF00_FUNC_CTL_ETH0_EVTI_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PF01_FUNC_CTL function mux definitions */
#define IOC_PF01_FUNC_CTL_GPIO_F_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF01_FUNC_CTL_UART3_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PF01_FUNC_CTL_UART3_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PF01_FUNC_CTL_I2C1_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PF01_FUNC_CTL_I2S0_RXD_3           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF01_FUNC_CTL_PDM0_D_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PF01_FUNC_CTL_ETH0_EVTI_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PF02_FUNC_CTL function mux definitions */
#define IOC_PF02_FUNC_CTL_GPIO_F_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF02_FUNC_CTL_UART0_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PF02_FUNC_CTL_CAN2_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PF02_FUNC_CTL_I2S0_RXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF02_FUNC_CTL_PDM0_D_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PF02_FUNC_CTL_ETH0_EVTI_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PF03_FUNC_CTL function mux definitions */
#define IOC_PF03_FUNC_CTL_GPIO_F_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF03_FUNC_CTL_UART3_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PF03_FUNC_CTL_I2C1_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PF03_FUNC_CTL_SPI3_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PF03_FUNC_CTL_I2S0_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF03_FUNC_CTL_PDM0_D_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PF03_FUNC_CTL_ETH0_EVTI_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)

/* IOC_PF04_FUNC_CTL function mux definitions */
#define IOC_PF04_FUNC_CTL_GPIO_F_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF04_FUNC_CTL_GPTMR5_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PF04_FUNC_CTL_SPI3_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PF04_FUNC_CTL_I2S0_TXD_2           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF04_FUNC_CTL_PDM0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)

/* IOC_PF05_FUNC_CTL function mux definitions */
#define IOC_PF05_FUNC_CTL_GPIO_F_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF05_FUNC_CTL_UART2_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PF05_FUNC_CTL_UART2_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PF05_FUNC_CTL_I2C0_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PF05_FUNC_CTL_I2S0_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF05_FUNC_CTL_ETH0_EVTO_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)
#define IOC_PF05_FUNC_CTL_USB1_OC              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PF06_FUNC_CTL function mux definitions */
#define IOC_PF06_FUNC_CTL_GPIO_F_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF06_FUNC_CTL_GPTMR5_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PF06_FUNC_CTL_UART8_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PF06_FUNC_CTL_I2C2_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PF06_FUNC_CTL_SPI3_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PF06_FUNC_CTL_I2S0_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF06_FUNC_CTL_ETH0_EVTO_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)
#define IOC_PF06_FUNC_CTL_USB1_PWR             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PF07_FUNC_CTL function mux definitions */
#define IOC_PF07_FUNC_CTL_GPIO_F_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF07_FUNC_CTL_UART8_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PF07_FUNC_CTL_I2C2_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PF07_FUNC_CTL_SPI3_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PF07_FUNC_CTL_I2S0_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF07_FUNC_CTL_PDM0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PF07_FUNC_CTL_USB1_ID              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PF08_FUNC_CTL function mux definitions */
#define IOC_PF08_FUNC_CTL_GPIO_F_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF08_FUNC_CTL_GPTMR5_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PF08_FUNC_CTL_UART2_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PF08_FUNC_CTL_I2C0_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PF08_FUNC_CTL_I2S0_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF08_FUNC_CTL_ETH0_EVTO_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)
#define IOC_PF08_FUNC_CTL_USB0_OC              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PF09_FUNC_CTL function mux definitions */
#define IOC_PF09_FUNC_CTL_GPIO_F_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF09_FUNC_CTL_GPTMR5_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PF09_FUNC_CTL_UART9_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PF09_FUNC_CTL_I2C3_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PF09_FUNC_CTL_SPI3_DAT3            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PF09_FUNC_CTL_I2S0_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF09_FUNC_CTL_ETH0_EVTO_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(19)
#define IOC_PF09_FUNC_CTL_USB0_PWR             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PF10_FUNC_CTL function mux definitions */
#define IOC_PF10_FUNC_CTL_GPIO_F_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PF10_FUNC_CTL_UART9_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PF10_FUNC_CTL_I2C3_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PF10_FUNC_CTL_SPI3_DAT2            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PF10_FUNC_CTL_I2S0_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(9)
#define IOC_PF10_FUNC_CTL_USB0_ID              IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PX00_FUNC_CTL function mux definitions */
#define IOC_PX00_FUNC_CTL_GPIO_X_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX00_FUNC_CTL_XPI0_CB_D_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PX00_FUNC_CTL_SDC1_DATA_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)

/* IOC_PX01_FUNC_CTL function mux definitions */
#define IOC_PX01_FUNC_CTL_GPIO_X_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX01_FUNC_CTL_FEMC_DQS             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PX01_FUNC_CTL_XPI0_CB_D_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PX01_FUNC_CTL_SDC1_DATA_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)

/* IOC_PX02_FUNC_CTL function mux definitions */
#define IOC_PX02_FUNC_CTL_GPIO_X_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX02_FUNC_CTL_XPI0_CA_D_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PX02_FUNC_CTL_XPI0_CA_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PX03_FUNC_CTL function mux definitions */
#define IOC_PX03_FUNC_CTL_GPIO_X_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX03_FUNC_CTL_XPI0_CA_D_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PX03_FUNC_CTL_XPI1_CA_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PX04_FUNC_CTL function mux definitions */
#define IOC_PX04_FUNC_CTL_GPIO_X_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX04_FUNC_CTL_XPI0_CA_CS1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PX04_FUNC_CTL_SDC1_CMD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)
#define IOC_PX04_FUNC_CTL_XPI1_CA_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(24)

/* IOC_PX05_FUNC_CTL function mux definitions */
#define IOC_PX05_FUNC_CTL_GPIO_X_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX05_FUNC_CTL_XPI0_CA_DQS          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PX05_FUNC_CTL_SDC1_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)

/* IOC_PX06_FUNC_CTL function mux definitions */
#define IOC_PX06_FUNC_CTL_GPIO_X_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX06_FUNC_CTL_FEMC_DQS             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(12)
#define IOC_PX06_FUNC_CTL_XPI0_CA_CS0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)

/* IOC_PX07_FUNC_CTL function mux definitions */
#define IOC_PX07_FUNC_CTL_GPIO_X_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX07_FUNC_CTL_XPI0_CA_SCLK         IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)

/* IOC_PX08_FUNC_CTL function mux definitions */
#define IOC_PX08_FUNC_CTL_GPIO_X_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX08_FUNC_CTL_XPI0_CB_D_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PX08_FUNC_CTL_SDC1_DATA_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)

/* IOC_PX09_FUNC_CTL function mux definitions */
#define IOC_PX09_FUNC_CTL_GPIO_X_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX09_FUNC_CTL_XPI0_CB_D_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)
#define IOC_PX09_FUNC_CTL_SDC1_DATA_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(17)

/* IOC_PX10_FUNC_CTL function mux definitions */
#define IOC_PX10_FUNC_CTL_GPIO_X_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX10_FUNC_CTL_XPI0_CA_D_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)

/* IOC_PX11_FUNC_CTL function mux definitions */
#define IOC_PX11_FUNC_CTL_GPIO_X_11            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PX11_FUNC_CTL_XPI0_CA_D_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(14)

/* IOC_PY00_FUNC_CTL function mux definitions */
#define IOC_PY00_FUNC_CTL_GPIO_Y_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY00_FUNC_CTL_UART4_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PY00_FUNC_CTL_UART4_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PY00_FUNC_CTL_I2C2_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PY00_FUNC_CTL_SPI3_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PY00_FUNC_CTL_I2S1_TXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)

/* IOC_PY01_FUNC_CTL function mux definitions */
#define IOC_PY01_FUNC_CTL_GPIO_Y_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY01_FUNC_CTL_UART4_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PY01_FUNC_CTL_I2C2_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PY01_FUNC_CTL_SPI3_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PY01_FUNC_CTL_I2S1_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)

/* IOC_PY02_FUNC_CTL function mux definitions */
#define IOC_PY02_FUNC_CTL_GPIO_Y_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY02_FUNC_CTL_UART6_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PY02_FUNC_CTL_UART6_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PY02_FUNC_CTL_SPI3_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PY02_FUNC_CTL_CAN0_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PY02_FUNC_CTL_I2S1_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)

/* IOC_PY03_FUNC_CTL function mux definitions */
#define IOC_PY03_FUNC_CTL_GPIO_Y_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY03_FUNC_CTL_UART6_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PY03_FUNC_CTL_SPI3_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PY03_FUNC_CTL_CAN0_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)

/* IOC_PY04_FUNC_CTL function mux definitions */
#define IOC_PY04_FUNC_CTL_GPIO_Y_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY04_FUNC_CTL_GPTMR6_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PY04_FUNC_CTL_UART5_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PY04_FUNC_CTL_UART5_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PY04_FUNC_CTL_I2C3_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PY04_FUNC_CTL_SPI1_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PY04_FUNC_CTL_CAN2_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PY04_FUNC_CTL_DAOL_P               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PY04_FUNC_CTL_ACMP_COMP_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PY05_FUNC_CTL function mux definitions */
#define IOC_PY05_FUNC_CTL_GPIO_Y_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY05_FUNC_CTL_GPTMR6_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PY05_FUNC_CTL_UART5_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PY05_FUNC_CTL_I2C3_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PY05_FUNC_CTL_SPI1_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PY05_FUNC_CTL_CAN0_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PY05_FUNC_CTL_DAOL_N               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PY05_FUNC_CTL_ACMP_COMP_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PY06_FUNC_CTL function mux definitions */
#define IOC_PY06_FUNC_CTL_GPIO_Y_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY06_FUNC_CTL_UART0_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PY06_FUNC_CTL_CAN1_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PY06_FUNC_CTL_I2S1_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)

/* IOC_PY07_FUNC_CTL function mux definitions */
#define IOC_PY07_FUNC_CTL_GPIO_Y_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY07_FUNC_CTL_UART0_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PY07_FUNC_CTL_CAN1_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PY07_FUNC_CTL_I2S1_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)

/* IOC_PY08_FUNC_CTL function mux definitions */
#define IOC_PY08_FUNC_CTL_GPIO_Y_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY08_FUNC_CTL_GPTMR6_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PY08_FUNC_CTL_UART2_TXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PY08_FUNC_CTL_SPI1_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PY08_FUNC_CTL_DAOR_P               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PY08_FUNC_CTL_ACMP_COMP_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PY09_FUNC_CTL function mux definitions */
#define IOC_PY09_FUNC_CTL_GPIO_Y_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY09_FUNC_CTL_GPTMR6_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PY09_FUNC_CTL_UART2_RXD            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PY09_FUNC_CTL_SPI1_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PY09_FUNC_CTL_DAOR_N               IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)
#define IOC_PY09_FUNC_CTL_ACMP_COMP_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PY10_FUNC_CTL function mux definitions */
#define IOC_PY10_FUNC_CTL_GPIO_Y_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY10_FUNC_CTL_UART7_DE             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PY10_FUNC_CTL_UART7_RTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PY10_FUNC_CTL_CAN2_TXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PY10_FUNC_CTL_I2S1_RXD_1           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PY10_FUNC_CTL_PDM0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)

/* IOC_PY11_FUNC_CTL function mux definitions */
#define IOC_PY11_FUNC_CTL_GPIO_Y_11            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PY11_FUNC_CTL_UART7_CTS            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(3)
#define IOC_PY11_FUNC_CTL_CAN2_RXD             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PY11_FUNC_CTL_I2S1_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PY11_FUNC_CTL_PDM0_D_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)

/* IOC_PZ00_FUNC_CTL function mux definitions */
#define IOC_PZ00_FUNC_CTL_GPIO_Z_00            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ00_FUNC_CTL_UART15_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ00_FUNC_CTL_I2C1_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)

/* IOC_PZ01_FUNC_CTL function mux definitions */
#define IOC_PZ01_FUNC_CTL_GPIO_Z_01            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ01_FUNC_CTL_UART15_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ01_FUNC_CTL_I2C1_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)

/* IOC_PZ02_FUNC_CTL function mux definitions */
#define IOC_PZ02_FUNC_CTL_GPIO_Z_02            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ02_FUNC_CTL_UART10_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ02_FUNC_CTL_SPI0_CSN             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PZ02_FUNC_CTL_PDM0_D_1             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)

/* IOC_PZ03_FUNC_CTL function mux definitions */
#define IOC_PZ03_FUNC_CTL_GPIO_Z_03            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ03_FUNC_CTL_UART10_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ03_FUNC_CTL_SPI0_SCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PZ03_FUNC_CTL_PDM0_D_0             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)

/* IOC_PZ04_FUNC_CTL function mux definitions */
#define IOC_PZ04_FUNC_CTL_GPIO_Z_04            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ04_FUNC_CTL_GPTMR7_CAPT_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PZ04_FUNC_CTL_UART11_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ04_FUNC_CTL_SPI0_MOSI            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PZ04_FUNC_CTL_I2S0_FCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PZ04_FUNC_CTL_PDM0_D_3             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)

/* IOC_PZ05_FUNC_CTL function mux definitions */
#define IOC_PZ05_FUNC_CTL_GPIO_Z_05            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ05_FUNC_CTL_UART11_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ05_FUNC_CTL_SPI0_MISO            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(5)
#define IOC_PZ05_FUNC_CTL_PDM0_D_2             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)

/* IOC_PZ06_FUNC_CTL function mux definitions */
#define IOC_PZ06_FUNC_CTL_GPIO_Z_06            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ06_FUNC_CTL_GPTMR7_COMP_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PZ06_FUNC_CTL_UART12_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ06_FUNC_CTL_I2S0_BCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PZ06_FUNC_CTL_PDM0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)

/* IOC_PZ07_FUNC_CTL function mux definitions */
#define IOC_PZ07_FUNC_CTL_GPIO_Z_07            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ07_FUNC_CTL_UART12_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ07_FUNC_CTL_I2S0_TXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PZ07_FUNC_CTL_PDM0_CLK             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(10)

/* IOC_PZ08_FUNC_CTL function mux definitions */
#define IOC_PZ08_FUNC_CTL_GPIO_Z_08            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ08_FUNC_CTL_GPTMR7_COMP_0        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PZ08_FUNC_CTL_UART13_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ08_FUNC_CTL_I2S0_RXD_0           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PZ08_FUNC_CTL_ACMP_COMP_0          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PZ09_FUNC_CTL function mux definitions */
#define IOC_PZ09_FUNC_CTL_GPIO_Z_09            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ09_FUNC_CTL_UART13_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ09_FUNC_CTL_I2S0_MCLK            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(8)
#define IOC_PZ09_FUNC_CTL_ACMP_COMP_1          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PZ10_FUNC_CTL function mux definitions */
#define IOC_PZ10_FUNC_CTL_GPIO_Z_10            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ10_FUNC_CTL_GPTMR7_CAPT_1        IOC_PAD_FUNC_CTL_ALT_SELECT_SET(1)
#define IOC_PZ10_FUNC_CTL_UART14_RXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ10_FUNC_CTL_I2C0_SDA             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PZ10_FUNC_CTL_CAN1_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PZ10_FUNC_CTL_ACMP_COMP_3          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

/* IOC_PZ11_FUNC_CTL function mux definitions */
#define IOC_PZ11_FUNC_CTL_GPIO_Z_11            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(0)
#define IOC_PZ11_FUNC_CTL_UART14_TXD           IOC_PAD_FUNC_CTL_ALT_SELECT_SET(2)
#define IOC_PZ11_FUNC_CTL_I2C0_SCL             IOC_PAD_FUNC_CTL_ALT_SELECT_SET(4)
#define IOC_PZ11_FUNC_CTL_CAN3_STBY            IOC_PAD_FUNC_CTL_ALT_SELECT_SET(7)
#define IOC_PZ11_FUNC_CTL_ACMP_COMP_2          IOC_PAD_FUNC_CTL_ALT_SELECT_SET(16)

#endif /* __ARCH_RISCV_SRC_HPM6750_HPM6750_IOMUX_H */
