/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.AliasInfo;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.DataServices;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.apache.olingo.odata2.core.ep.consumer.XmlMetadataConsumer;

public class EdmxProvider
extends EdmProvider {
    private DataServices dataServices;

    public EdmxProvider parse(InputStream in, boolean validate) throws EntityProviderException {
        XmlMetadataConsumer parser = new XmlMetadataConsumer();
        XMLStreamReader streamReader = XmlHelper.createStreamReader(in);
        this.dataServices = parser.readMetadata(streamReader, validate);
        return this;
    }

    public EntityContainerInfo getEntityContainerInfo(String name) throws ODataException {
        if (name != null) {
            for (Schema schema : this.dataServices.getSchemas()) {
                for (EntityContainer container : schema.getEntityContainers()) {
                    if (!container.getName().equals(name)) continue;
                    return container;
                }
            }
        } else {
            for (Schema schema : this.dataServices.getSchemas()) {
                for (EntityContainer container : schema.getEntityContainers()) {
                    if (!container.isDefaultEntityContainer()) continue;
                    return container;
                }
            }
        }
        return null;
    }

    public EntityType getEntityType(FullQualifiedName edmFQName) throws ODataException {
        for (Schema schema : this.dataServices.getSchemas()) {
            if (!schema.getNamespace().equals(edmFQName.getNamespace())) continue;
            for (EntityType entityType : schema.getEntityTypes()) {
                if (!entityType.getName().equals(edmFQName.getName())) continue;
                return entityType;
            }
        }
        return null;
    }

    public ComplexType getComplexType(FullQualifiedName edmFQName) throws ODataException {
        for (Schema schema : this.dataServices.getSchemas()) {
            if (!schema.getNamespace().equals(edmFQName.getNamespace())) continue;
            for (ComplexType complexType : schema.getComplexTypes()) {
                if (!complexType.getName().equals(edmFQName.getName())) continue;
                return complexType;
            }
        }
        return null;
    }

    public Association getAssociation(FullQualifiedName edmFQName) throws ODataException {
        for (Schema schema : this.dataServices.getSchemas()) {
            if (!schema.getNamespace().equals(edmFQName.getNamespace())) continue;
            for (Association association : schema.getAssociations()) {
                if (!association.getName().equals(edmFQName.getName())) continue;
                return association;
            }
        }
        return null;
    }

    public EntitySet getEntitySet(String entityContainer, String name) throws ODataException {
        for (Schema schema : this.dataServices.getSchemas()) {
            for (EntityContainer container : schema.getEntityContainers()) {
                if (!container.getName().equals(entityContainer)) continue;
                for (EntitySet entitySet : container.getEntitySets()) {
                    if (!entitySet.getName().equals(name)) continue;
                    return entitySet;
                }
            }
        }
        return null;
    }

    public AssociationSet getAssociationSet(String entityContainer, FullQualifiedName association, String sourceEntitySetName, String sourceEntitySetRole) throws ODataException {
        for (Schema schema : this.dataServices.getSchemas()) {
            for (EntityContainer container : schema.getEntityContainers()) {
                if (!container.getName().equals(entityContainer)) continue;
                for (AssociationSet associationSet : container.getAssociationSets()) {
                    if (!associationSet.getAssociation().equals((Object)association) || (!associationSet.getEnd1().getEntitySet().equals(sourceEntitySetName) || !associationSet.getEnd1().getRole().equals(sourceEntitySetRole)) && (!associationSet.getEnd2().getEntitySet().equals(sourceEntitySetName) || !associationSet.getEnd2().getRole().equals(sourceEntitySetRole))) continue;
                    return associationSet;
                }
            }
        }
        return null;
    }

    public FunctionImport getFunctionImport(String entityContainer, String name) throws ODataException {
        for (Schema schema : this.dataServices.getSchemas()) {
            for (EntityContainer container : schema.getEntityContainers()) {
                if (!container.getName().equals(entityContainer)) continue;
                for (FunctionImport function : container.getFunctionImports()) {
                    if (!function.getName().equals(name)) continue;
                    return function;
                }
            }
        }
        return null;
    }

    public List<Schema> getSchemas() throws ODataException {
        return this.dataServices.getSchemas();
    }

    public List<AliasInfo> getAliasInfos() {
        ArrayList<AliasInfo> aliasInfos = new ArrayList<AliasInfo>();
        for (Schema schema : this.dataServices.getSchemas()) {
            if (schema.getAlias() == null) continue;
            aliasInfos.add(new AliasInfo().setAlias(schema.getAlias()).setNamespace(schema.getNamespace()));
        }
        return aliasInfos;
    }
}

