/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.Bit;
import org.apache.olingo.odata2.core.edm.Uint7;

public class EdmByte
extends AbstractSimpleType {
    private static final EdmByte instance = new EdmByte();

    public static EdmByte getInstance() {
        return instance;
    }

    @Override
    public boolean isCompatible(EdmSimpleType simpleType) {
        return simpleType instanceof Bit || simpleType instanceof Uint7 || simpleType instanceof EdmByte;
    }

    public Class<?> getDefaultType() {
        return Short.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        Short valueShort;
        try {
            valueShort = Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}), (Throwable)e);
        }
        if (valueShort < 0 || valueShort > 255) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
        }
        if (returnType.isAssignableFrom(Short.class)) {
            return returnType.cast(valueShort);
        }
        if (returnType.isAssignableFrom(Byte.class)) {
            if (valueShort <= 127) {
                return returnType.cast(valueShort.byteValue());
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(new Object[]{value, returnType}));
        }
        if (returnType.isAssignableFrom(Integer.class)) {
            return returnType.cast(valueShort.intValue());
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(valueShort.longValue());
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            if (((Number)value).longValue() >= 0L && ((Number)value).longValue() <= 255L) {
                return value.toString();
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(new Object[]{value}));
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{value.getClass()}));
    }
}

