/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch.v2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.core.ODataPathSegmentImpl;
import org.apache.olingo.odata2.core.PathInfoImpl;
import org.apache.olingo.odata2.core.batch.v2.BatchParserCommon;
import org.apache.olingo.odata2.core.batch.v2.Header;
import org.apache.olingo.odata2.core.batch.v2.Line;

public class BatchTransformatorCommon {
    public static void validateContentType(Header headers) throws BatchException {
        List<String> contentTypes = headers.getHeaders("Content-Type");
        if (contentTypes.isEmpty()) {
            throw new BatchException(BatchException.MISSING_CONTENT_TYPE);
        }
        if (!headers.isHeaderMatching("Content-Type", BatchParserCommon.PATTERN_MULTIPART_MIXED) && !headers.isHeaderMatching("Content-Type", BatchParserCommon.PATTERN_CONTENT_TYPE_APPLICATION_HTTP)) {
            throw new BatchException(BatchException.INVALID_CONTENT_TYPE.addContent(new Object[]{"multipart/mixed or application/http"}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateContentTransferEncoding(Header headers, boolean isChangeRequest) throws BatchException {
        Header.HeaderField contentTransferField = headers.getHeaderField("Content-Transfer-Encoding");
        if (contentTransferField != null) {
            List<String> contentTransferValues = contentTransferField.getValues();
            if (contentTransferValues.size() != 1) throw new BatchException(BatchException.INVALID_HEADER.addContent(new Object[]{contentTransferField.getLineNumber()}));
            String encoding = contentTransferValues.get(0);
            if ("binary".equalsIgnoreCase(encoding)) return;
            throw new BatchException(BatchException.INVALID_CONTENT_TRANSFER_ENCODING.addContent(new Object[]{contentTransferField.getLineNumber()}));
        }
        if (!isChangeRequest) return;
        throw new BatchException(BatchException.INVALID_CONTENT_TRANSFER_ENCODING.addContent(new Object[]{headers.getLineNumber()}));
    }

    public static int getContentLength(Header headers) throws BatchException {
        Header.HeaderField contentLengthField = headers.getHeaderField("Content-Length");
        if (contentLengthField != null && contentLengthField.getValues().size() == 1) {
            List<String> contentLengthValues = contentLengthField.getValues();
            try {
                int contentLength = Integer.parseInt(contentLengthValues.get(0));
                if (contentLength < 0) {
                    throw new BatchException(BatchException.INVALID_HEADER.addContent(new Object[]{contentLengthField.getValue()}).addContent(new Object[]{contentLengthField.getLineNumber()}));
                }
                return contentLength;
            }
            catch (NumberFormatException e) {
                throw new BatchException(BatchException.INVALID_HEADER.addContent(new Object[]{contentLengthField.getValue()}).addContent(new Object[]{contentLengthField.getLineNumber()}), (Throwable)e);
            }
        }
        return -1;
    }

    public static void validateHost(Header headers, String baseUri) throws BatchException {
        Header.HeaderField hostField = headers.getHeaderField("Host");
        if (!(hostField == null || hostField.getValues().size() <= 1 && URI.create(baseUri).getAuthority().equalsIgnoreCase(hostField.getValues().get(0).trim()))) {
            throw new BatchException(BatchException.INVALID_HEADER.addContent(new Object[]{hostField.getValues().get(0)}).addContent(new Object[]{hostField.getLineNumber()}));
        }
    }

    public static class HttpRequestStatusLine {
        private static final Set<String> HTTP_BATCH_METHODS = new HashSet<String>(Arrays.asList("GET"));
        private static final Set<String> HTTP_CHANGE_SET_METHODS = new HashSet<String>(Arrays.asList("POST", "PUT", "DELETE", "MERGE", "PATCH"));
        private static final String HTTP_VERSION = "HTTP/1.1";
        private final Line statusLine;
        final String requestBaseUri;
        final PathInfo batchRequestPathInfo;
        private ODataHttpMethod method;
        private PathInfo pathInfo;
        private String httpVersion;

        public HttpRequestStatusLine(Line httpStatusLine, String baseUri, PathInfo pathInfo) throws BatchException {
            this.statusLine = httpStatusLine;
            this.requestBaseUri = baseUri;
            this.batchRequestPathInfo = pathInfo;
            this.parse();
        }

        private void parse() throws BatchException {
            String[] parts = this.statusLine.toString().split(" ");
            if (parts.length == 3) {
                try {
                    this.method = this.parseMethod(parts[0]);
                    this.pathInfo = this.parseUri(parts[1]);
                    this.httpVersion = this.parseHttpVersion(parts[2]);
                }
                catch (IllegalArgumentException e) {
                    throw new BatchException(BatchException.MISSING_METHOD.addContent(new Object[]{this.statusLine.getLineNumber()}), (Throwable)e);
                }
            } else {
                throw new BatchException(BatchException.INVALID_REQUEST_LINE.addContent(new Object[]{this.statusLine.toString()}).addContent(new Object[]{this.statusLine.getLineNumber()}));
            }
        }

        private ODataHttpMethod parseMethod(String method) throws BatchException {
            try {
                return ODataHttpMethod.valueOf((String)method.trim());
            }
            catch (IllegalArgumentException e) {
                throw new BatchException(BatchException.MISSING_METHOD.addContent(new Object[]{this.statusLine.getLineNumber()}), (Throwable)e);
            }
        }

        private PathInfo parseUri(String uri) throws BatchException {
            PathInfoImpl pInfo;
            block7: {
                pInfo = new PathInfoImpl();
                pInfo.setServiceRoot(this.batchRequestPathInfo.getServiceRoot());
                pInfo.setPrecedingPathSegment(this.batchRequestPathInfo.getPrecedingSegments());
                try {
                    Matcher uriParts;
                    URI uriObject = new URI(uri);
                    String relativeUri = "";
                    if (uriObject.isAbsolute()) {
                        if (uri.startsWith(this.requestBaseUri + "/")) {
                            relativeUri = uri.substring(this.requestBaseUri.length() + 1);
                        }
                    } else {
                        relativeUri = uri.startsWith(this.batchRequestPathInfo.getServiceRoot().getRawPath()) ? uri.substring(this.batchRequestPathInfo.getServiceRoot().getRawPath().length()) : uri;
                    }
                    if ((uriParts = BatchParserCommon.PATTERN_RELATIVE_URI.matcher(relativeUri)).lookingAt() && uriParts.groupCount() == 2) {
                        String odataPathSegmentsAsString = uriParts.group(1);
                        String queryParametersAsString = uriParts.group(2) != null ? uriParts.group(2) : "";
                        pInfo.setODataPathSegment(this.parseODataPathSegments(odataPathSegmentsAsString));
                        if (!odataPathSegmentsAsString.startsWith("$")) {
                            String requestUri = this.requestBaseUri + "/" + odataPathSegmentsAsString + queryParametersAsString;
                            pInfo.setRequestUri(new URI(requestUri));
                        }
                        break block7;
                    }
                    throw new BatchException(BatchException.INVALID_URI.addContent(new Object[]{this.statusLine.getLineNumber()}));
                }
                catch (URISyntaxException e) {
                    throw new BatchException(BatchException.INVALID_URI.addContent(new Object[]{this.statusLine.getLineNumber()}), (Throwable)e);
                }
            }
            return pInfo;
        }

        private List<PathSegment> parseODataPathSegments(String odataPathSegmentsAsString) {
            String[] pathParts;
            ArrayList<PathSegment> odataPathSegments = new ArrayList<PathSegment>();
            for (String pathSegment : pathParts = odataPathSegmentsAsString.split("/")) {
                odataPathSegments.add(new ODataPathSegmentImpl(pathSegment, null));
            }
            return odataPathSegments;
        }

        private String parseHttpVersion(String httpVersion) throws BatchException {
            if (!HTTP_VERSION.equals(httpVersion.trim())) {
                throw new BatchException(BatchException.INVALID_REQUEST_LINE.addContent(new Object[]{this.statusLine.toString()}).addContent(new Object[]{this.statusLine.getLineNumber()}));
            }
            return HTTP_VERSION;
        }

        public void validateHttpMethod(boolean isChangeSet) throws BatchException {
            Set<String> validMethods;
            Set<String> set = validMethods = isChangeSet ? HTTP_CHANGE_SET_METHODS : HTTP_BATCH_METHODS;
            if (!validMethods.contains(this.getMethod().toString())) {
                if (isChangeSet) {
                    throw new BatchException(BatchException.INVALID_CHANGESET_METHOD.addContent(new Object[]{this.statusLine.getLineNumber()}));
                }
                throw new BatchException(BatchException.INVALID_QUERY_OPERATION_METHOD.addContent(new Object[]{this.statusLine.getLineNumber()}));
            }
        }

        public ODataHttpMethod getMethod() {
            return this.method;
        }

        public PathInfo getPathInfo() {
            return this.pathInfo;
        }

        public String getHttpVersion() {
            return this.httpVersion;
        }

        public int getLineNumber() {
            return this.statusLine.getLineNumber();
        }
    }

    public static class HttpResponsetStatusLine {
        private static final String REG_EX_STATUS_LINE = "(?:HTTP/[0-9]\\.[0-9])\\s([0-9]{3})\\s([\\S ]+)\\s*";
        private Line httpStatusLine;
        private String statusCode;
        private String statusInfo;

        public HttpResponsetStatusLine(Line httpStatusLine) throws BatchException {
            this.httpStatusLine = httpStatusLine;
            this.parse();
        }

        private void parse() throws BatchException {
            Pattern regexPattern = Pattern.compile(REG_EX_STATUS_LINE);
            Matcher matcher = regexPattern.matcher(this.httpStatusLine.toString());
            if (!matcher.find()) {
                throw new BatchException(BatchException.INVALID_STATUS_LINE.addContent(new Object[]{this.httpStatusLine.toString()}).addContent(new Object[]{this.httpStatusLine.getLineNumber()}));
            }
            this.statusCode = matcher.group(1);
            this.statusInfo = matcher.group(2);
        }

        public String getStatusCode() {
            return this.statusCode;
        }

        public String getStatusInfo() {
            return this.statusInfo;
        }
    }
}

