/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.rest;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;
import org.apache.olingo.odata2.core.rest.ODataRedirectLocator;
import org.apache.olingo.odata2.core.rest.ODataSubLocator;
import org.apache.olingo.odata2.core.rest.SubLocatorParameter;
import org.apache.olingo.odata2.core.rest.app.AbstractODataApplication;

@Path(value="/")
public class ODataRootLocator {
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private UriInfo uriInfo;
    @Context
    private Request request;
    @Context
    private ServletConfig servletConfig;
    @Context
    private HttpServletRequest servletRequest;
    @Context
    private Application app;

    @Path(value="/{pathSegments: .*}")
    public Object handleRequest(@Encoded @PathParam(value="pathSegments") List<PathSegment> pathSegments, @HeaderParam(value="X-HTTP-Method") String xHttpMethod, @HeaderParam(value="X-HTTP-Method-Override") String xHttpMethodOverride) throws ODataException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (xHttpMethod != null && xHttpMethodOverride != null && !xHttpMethod.equalsIgnoreCase(xHttpMethodOverride)) {
            throw new ODataBadRequestException(ODataBadRequestException.AMBIGUOUS_XMETHOD);
        }
        if (this.servletRequest.getPathInfo() == null) {
            return this.handleRedirect();
        }
        ODataServiceFactory serviceFactory = this.getServiceFactory();
        int pathSplit = this.getPathSplit();
        SubLocatorParameter param = new SubLocatorParameter();
        param.setServiceFactory(serviceFactory);
        param.setPathSegments(pathSegments);
        param.setHttpHeaders(this.httpHeaders);
        param.setUriInfo(this.uriInfo);
        param.setRequest(this.request);
        param.setServletRequest(this.servletRequest);
        param.setPathSplit(pathSplit);
        return ODataSubLocator.create(param);
    }

    public ODataServiceFactory getServiceFactory() {
        return ODataRootLocator.createServiceFactoryFromContext(this.app, this.servletRequest, this.servletConfig);
    }

    public int getPathSplit() {
        int pathSplit = 0;
        String pathSplitAsString = this.servletConfig.getInitParameter("org.apache.olingo.odata2.path.split");
        if (pathSplitAsString != null) {
            pathSplit = Integer.parseInt(pathSplitAsString);
        }
        return pathSplit;
    }

    public static ODataServiceFactory createServiceFactoryFromContext(Application app, HttpServletRequest servletRequest, ServletConfig servletConfig) {
        try {
            Class<Object> factoryClass;
            if (app instanceof AbstractODataApplication) {
                factoryClass = ((AbstractODataApplication)app).getServiceFactoryClass();
            } else {
                String factoryClassName = servletConfig.getInitParameter("org.apache.olingo.odata2.service.factory");
                if (factoryClassName == null) {
                    throw new ODataRuntimeException("Servlet config missing: org.apache.olingo.odata2.service.factory");
                }
                ClassLoader cl = (ClassLoader)servletRequest.getAttribute("org.apache.olingo.odata2.service.factory.classloader");
                factoryClass = cl == null ? Class.forName(factoryClassName) : Class.forName(factoryClassName, true, cl);
            }
            return factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new ODataRuntimeException("Exception during ODataServiceFactory creation occured.", e);
        }
    }

    private Object handleRedirect() {
        return new ODataRedirectLocator();
    }
}

