/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.test.interceptors.factory.beans;

import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;

import org.apache.webbeans.test.decorators.common.Breeded;

/**
 * Abstract Decorator for subclassing proxy test
 */
@Decorator
public abstract class MyAbstractTestDecorator implements Breeded
{
    @Inject
    @Delegate
    private Breeded delegate;


    @Override
    public int getAge()
    {
        return delegate.getAge() + 42;
    }

    public void setDelegate(Breeded delegate)
    {
        this.delegate = delegate;
    }
}
