/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.DataInput;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ASCIIInputStream
extends FilterInputStream
implements DataInput {
    private boolean hadEOF = false;
    private char[] lineBuffer;

    public ASCIIInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public boolean bad() {
        return false;
    }

    public boolean eof() throws IOException {
        if (this.hadEOF) {
            return true;
        }
        int n = this.nextNonWhiteSpaceCharacter();
        if (n == -1) {
            this.hadEOF = true;
            return true;
        }
        this.pushback(n);
        return false;
    }

    public void flushLine() throws IOException {
        int n;
        while ((n = this.in.read()) >= 0) {
            if (n == 13) {
                n = this.in.read();
                if (n != 10) {
                    this.pushback(n);
                }
                return;
            }
            if (n != 10) continue;
            return;
        }
        if (n < 0) {
            this.hadEOF = true;
        }
    }

    public boolean hadEof() throws IOException {
        return this.hadEOF;
    }

    private int nextNonWhiteSpaceCharacter() throws IOException {
        int n;
        while ((n = this.in.read()) == 32 || n == 9 || n == 13 || n == 10) {
        }
        return n;
    }

    private void pushback(int n) throws IOException {
        if (!(this.in instanceof PushbackInputStream)) {
            this.in = new PushbackInputStream(this.in);
        }
        ((PushbackInputStream)this.in).unread(n);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 < 0) {
            this.hadEOF = true;
        }
        return n3;
    }

    public boolean readBoolean() throws IOException {
        String string = this.readWord();
        if (string == null) {
            throw new NumberFormatException("Error in reading boolean: no string input");
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        throw new NumberFormatException("Expected true or false, but got " + string);
    }

    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            this.hadEOF = true;
        }
        return (byte)(n & 0xFF);
    }

    public char readChar() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            this.hadEOF = true;
        }
        return (char)n;
    }

    /*
     * Unable to fully structure code
     */
    public double readDouble() throws IOException {
        block19: {
            var1_1 = 0.0;
            var3_2 = -1;
            var4_3 = 1;
            var5_4 = 0;
            var3_2 = this.nextNonWhiteSpaceCharacter();
            switch (var3_2) {
                case 45: {
                    var4_3 = -1;
                    var3_2 = this.in.read();
                    ** GOTO lbl19
                }
                case 43: {
                    var3_2 = this.in.read();
                    ** GOTO lbl19
                }
                default: {
                    if (var3_2 < 48) ** break;
                }
            }
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1 * 10.0 + (double)(var3_2 - 48);
                var3_2 = this.in.read();
                ++var5_4;
lbl19:
                // 3 sources

                if (var3_2 < 48) break;
                ** while (var3_2 <= 57)
            }
lbl21:
            // 3 sources

            if (var3_2 == 46) {
                var6_5 = 0.1;
                var3_2 = this.in.read();
                while (var3_2 >= 48 && var3_2 <= 57) {
                    var1_1 += (double)(var3_2 - 48) * var6_5;
                    var6_5 /= 10.0;
                    var3_2 = this.in.read();
                    ++var5_4;
                }
            }
            if (var5_4 == 0) {
                throw new NumberFormatException("Next token does not have valid decimal value. Token read so far: " + var1_1 * (double)var4_3);
            }
            if (var3_2 != 101 && var3_2 != 69) break block19;
            var6_5 = 0.0;
            var8_6 = 1;
            var5_4 = 0;
            var3_2 = this.in.read();
            switch (var3_2) {
                case 45: {
                    var8_6 = -1;
                    var3_2 = this.in.read();
                    ** GOTO lbl50
                }
                case 43: {
                    var3_2 = this.in.read();
                    ** GOTO lbl50
                }
                default: {
                    if (var3_2 < 48) ** break;
                }
            }
lbl-1000:
            // 1 sources

            {
                var6_5 = var6_5 * 10.0 + (double)(var3_2 - 48);
                var3_2 = this.in.read();
                ++var5_4;
lbl50:
                // 3 sources

                if (var3_2 < 48) break;
                ** while (var3_2 <= 57)
            }
lbl52:
            // 3 sources

            if (var6_5 != 0.0) {
                try {
                    var1_1 *= Math.pow(10.0, var6_5 * (double)var8_6);
                }
                catch (Exception v0) {
                    var1_1 = 0.0;
                    var4_3 = 1;
                }
            }
            if (var5_4 == 0) {
                throw new NumberFormatException("Invalid exponent format for: " + var1_1 * (double)var4_3);
            }
        }
        if (var3_2 < 0) {
            this.hadEOF = true;
        } else {
            this.pushback(var3_2);
        }
        return var1_1 * (double)var4_3;
    }

    public float readFloat() throws IOException {
        return (float)this.readDouble();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        InputStream inputStream = this.in;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                this.hadEOF = true;
            }
            n3 += n4;
        }
    }

    public int readInt() throws IOException {
        return (int)this.readLong();
    }

    public String readLine() throws IOException {
        int n;
        InputStream inputStream = this.in;
        char[] cArray = this.lineBuffer;
        if (this.hadEOF) {
            return null;
        }
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = inputStream.read();
            switch (n) {
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10) break block4;
                    this.pushback(n4);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                        System.arraycopy(this.lineBuffer, 0, cArray, 0, n3);
                        this.lineBuffer = cArray;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
                case -1: 
                case 10: 
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            this.hadEOF = true;
            return null;
        }
        if (n == -1) {
            this.hadEOF = true;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    /*
     * Unable to fully structure code
     */
    public long readLong() throws IOException {
        var1_1 = 0L;
        var3_2 = -1;
        var4_3 = 1L;
        var6_4 = 0;
        if (this.hadEOF) {
            return 0L;
        }
        var3_2 = this.nextNonWhiteSpaceCharacter();
        switch (var3_2) {
            case 45: {
                var4_3 = -1L;
                var3_2 = this.in.read();
                ** GOTO lbl24
            }
            case 43: {
                var3_2 = this.in.read();
                ** GOTO lbl24
            }
            case -1: {
                this.hadEOF = true;
                return 0L;
            }
            default: {
                if (var3_2 < 48) ** break;
            }
        }
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1 * 10L + (long)(var3_2 - 48);
            var3_2 = this.in.read();
            ++var6_4;
lbl24:
            // 3 sources

            if (var3_2 < 48) break;
            ** while (var3_2 <= 57)
        }
lbl26:
        // 3 sources

        if (var3_2 < 0) {
            this.hadEOF = true;
        } else {
            this.pushback(var3_2);
        }
        if (var6_4 == 0) {
            throw new NumberFormatException("The next token did not start with a digit");
        }
        return var1_1 * var4_3;
    }

    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    public String readUTF() throws IOException {
        return "";
    }

    public int readUnsignedByte() throws IOException {
        return this.readChar() & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readInt() & 0xFFFF;
    }

    public String readWord() throws IOException {
        InputStream inputStream = this.in;
        char[] cArray = this.lineBuffer;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        boolean bl = false;
        if (this.hadEOF) {
            return null;
        }
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        n = cArray.length;
        n3 = this.nextNonWhiteSpaceCharacter();
        while (n3 != 32 && n3 != 9 && n3 != 10 && n3 != 13 && n3 >= 0) {
            if (--n < 0) {
                cArray = new char[n2 + 128];
                n = cArray.length - n2 - 1;
                System.arraycopy(this.lineBuffer, 0, cArray, 0, n2);
                this.lineBuffer = cArray;
            }
            cArray[n2++] = (char)n3;
            n3 = inputStream.read();
        }
        if (n3 == -1 && n2 == 0) {
            this.hadEOF = true;
            return null;
        }
        if (n3 == -1) {
            this.hadEOF = true;
            return String.copyValueOf(cArray, 0, n2);
        }
        this.pushback(n3);
        return String.copyValueOf(cArray, 0, n2);
    }

    public int skipBytes(int n) throws IOException {
        InputStream inputStream = this.in;
        int n2 = 0;
        while (n2 < n) {
            n2 += (int)inputStream.skip(n - n2);
        }
        return n;
    }
}

