/*
 * Decompiled with CFR 0.152.
 */
package sdsu.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sdsu.util.LabeledTable;
import sdsu.util.Table;

public class DatabaseTable {
    Table dataElements;
    Hashtable columnIndex;
    int[] columnTypes;
    String tableName;

    public DatabaseTable(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.dataElements = new Table(1, n);
        int n2 = 0;
        while (n2 < n) {
            this.dataElements.setElementAt(resultSetMetaData.getColumnName(n2 + 1), 0, n2);
            ++n2;
        }
        this.setColumnLabels();
        this.columnTypes = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.columnTypes[n3] = resultSetMetaData.getColumnType(n3 + 1);
            ++n3;
        }
        while (resultSet.next()) {
            Vector<String> vector = new Vector<String>(n);
            int n4 = 1;
            while (n4 <= n) {
                vector.addElement(resultSet.getString(n4));
                ++n4;
            }
            this.dataElements.addRow(vector);
        }
        resultSet.close();
    }

    public DatabaseTable(Table table) {
        this.dataElements = (Table)table.clone();
        this.setColumnLabels();
        this.setTypesAsQuotable();
    }

    public Vector columnAt(String string) {
        Vector vector = this.dataElements.columnAt(this.columnIndex(string));
        vector.removeElementAt(0);
        return vector;
    }

    protected int columnIndex(String string) {
        return this.columnIndex.get(string.toLowerCase()).hashCode();
    }

    public int databaseDelete(String string, Connection connection) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        int n2 = 1;
        while (n2 <= this.numberOfRows()) {
            n += statement.executeUpdate(this.sqlDeleteRow(string, n2));
            ++n2;
        }
        statement.close();
        return n;
    }

    public int databaseInsert(String string, Connection connection) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        int n2 = 1;
        while (n2 <= this.numberOfRows()) {
            n += statement.executeUpdate(this.sqlInsertRow(string, n2));
            ++n2;
        }
        statement.close();
        return n;
    }

    public int databaseInsertTest(String string) throws SQLException {
        int n = 0;
        int n2 = 1;
        while (n2 <= this.numberOfRows()) {
            System.out.println(this.sqlInsertRow(string, n2));
            ++n2;
        }
        return n;
    }

    public int databaseUpdate(String string, String string2, Connection connection) throws SQLException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        return this.databaseUpdate(string, vector, connection);
    }

    public int databaseUpdate(String string, Vector vector, Connection connection) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        int n2 = 1;
        while (n2 <= this.numberOfRows()) {
            n += statement.executeUpdate(this.sqlUpdateRow(string, n2, vector));
            ++n2;
        }
        statement.close();
        return n;
    }

    public Object elementAt(int n, String string) {
        return this.dataElements.elementAt(n, this.columnIndex(string));
    }

    protected static final String escapeQuote(String string) {
        char c = '\'';
        int n = string.indexOf(c);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 3);
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(c);
            n2 = n;
            n = string.indexOf(c, n + 1);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static DatabaseTable fromSQL(String string, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        DatabaseTable databaseTable = new DatabaseTable(resultSet);
        statement.close();
        return databaseTable;
    }

    public Enumeration getColumnLabels() {
        return this.columnIndex.keys();
    }

    public int getColumnType(String string) {
        return this.columnTypes[this.columnIndex(string)];
    }

    public static DatabaseTable getRow(String string, String string2, String string3, Connection connection) throws SQLException {
        String string4 = "SELECT * FROM " + string + " WHERE " + string2 + " = " + string3;
        return DatabaseTable.fromSQL(string4, connection);
    }

    public static DatabaseTable getTable(String string, Connection connection) throws SQLException {
        String string2 = "SELECT * FROM " + string;
        return DatabaseTable.fromSQL(string2, connection);
    }

    protected static boolean isNumericType(int n) {
        return n == -7 || n == -6 || n == 5 || n == 4 || n == -5 || n == 6 || n == 7 || n == 8 || n == 2 || n == 3;
    }

    public int numberOfColumns() {
        return this.dataElements.numberOfColumns();
    }

    public int numberOfRows() {
        return this.dataElements.numberOfRows() - 1;
    }

    protected String quotedElementAt(int n, String string) {
        int n2 = this.columnTypes[this.columnIndex(string)];
        if (DatabaseTable.isNumericType(n2)) {
            return this.elementAt(n, string).toString();
        }
        String string2 = this.elementAt(n, string).toString();
        return "'" + DatabaseTable.escapeQuote(string2) + "'";
    }

    protected static void removeFromBuffer(StringBuffer stringBuffer, int n) {
        stringBuffer.setLength(stringBuffer.length() - n);
    }

    protected void setColumnLabels() {
        this.columnIndex = new Hashtable();
        int n = 0;
        while (n < this.dataElements.numberOfColumns()) {
            String string = this.dataElements.elementAt(0, n).toString();
            Integer n2 = new Integer(n);
            this.columnIndex.put(string.toLowerCase(), n2);
            ++n;
        }
    }

    public void setColumnType(int n, String string) {
        this.columnTypes[this.columnIndex((String)string)] = n;
    }

    public void setElementAt(Object object, int n, String string) {
        this.dataElements.setElementAt(object, n, this.columnIndex(string));
    }

    protected void setTypesAsQuotable() {
        this.columnTypes = new int[this.dataElements.numberOfColumns()];
        int n = 0;
        while (n < this.dataElements.numberOfColumns()) {
            this.columnTypes[n] = 1;
            ++n;
        }
    }

    protected String sqlDeleteRow(String string, int n) {
        String string2 = " AND ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(string);
        stringBuffer.append(" WHERE ");
        Enumeration enumeration = this.getColumnLabels();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            stringBuffer.append(string3);
            stringBuffer.append(" = ");
            stringBuffer.append(this.quotedElementAt(n, string3));
            stringBuffer.append(string2);
        }
        DatabaseTable.removeFromBuffer(stringBuffer, string2.length());
        return stringBuffer.toString();
    }

    protected String sqlInsertRow(String string, int n) {
        String string2 = ", ";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append(" ( ");
        stringBuffer2.append(" ( ");
        Enumeration enumeration = this.getColumnLabels();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            stringBuffer.append(string3);
            stringBuffer.append(string2);
            stringBuffer2.append(this.quotedElementAt(n, string3));
            stringBuffer2.append(string2);
        }
        DatabaseTable.removeFromBuffer(stringBuffer, string2.length());
        DatabaseTable.removeFromBuffer(stringBuffer2, string2.length());
        stringBuffer.append(" ) ");
        stringBuffer2.append(" ) ");
        return "INSERT INTO " + string + stringBuffer.toString() + " VALUES " + stringBuffer2.toString();
    }

    protected String sqlUpdateRow(String string, int n, Vector vector) {
        String string2 = " AND";
        String string3 = ", ";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Enumeration enumeration = this.getColumnLabels();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (vector.contains(string4)) {
                stringBuffer2.append(string4);
                stringBuffer2.append(" = ");
                stringBuffer2.append(this.quotedElementAt(n, string4));
                stringBuffer2.append(string2);
                continue;
            }
            stringBuffer.append(string4);
            stringBuffer.append(" = ");
            stringBuffer.append(this.quotedElementAt(n, string4));
            stringBuffer.append(string3);
        }
        DatabaseTable.removeFromBuffer(stringBuffer, string3.length());
        DatabaseTable.removeFromBuffer(stringBuffer2, string2.length());
        return "UPDATE \t" + string + " SET " + stringBuffer.toString() + " WHERE " + stringBuffer2.toString();
    }

    public LabeledTable toLabeledTable() {
        return new LabeledTable(this.dataElements);
    }

    public String toString() {
        return this.dataElements.toString();
    }

    public void trimAll() {
        int n = 1;
        while (n <= this.numberOfRows()) {
            int n2 = 0;
            while (n2 < this.numberOfColumns()) {
                String string = this.dataElements.elementAt(n, n2).toString().trim();
                this.dataElements.setElementAt(string, n, n2);
                ++n2;
            }
            ++n;
        }
    }
}

