/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.ProgressFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressHelper.class);
    private String processorName;
    protected final Map<String, LogicalInput> inputs;
    final ProcessorContext processorContext;
    volatile ScheduledExecutorService scheduledExecutorService;
    Runnable monitorProgress = new Runnable(){

        @Override
        public void run() {
            try {
                float progress;
                float progSum = 0.0f;
                if (ProgressHelper.this.inputs != null && ProgressHelper.this.inputs.size() != 0) {
                    for (LogicalInput input : ProgressHelper.this.inputs.values()) {
                        float inputProgress;
                        if (!(input instanceof AbstractLogicalInput) || !((inputProgress = ((AbstractLogicalInput)input).getProgress()) >= 0.0f) || !(inputProgress <= 1.0f)) continue;
                        progSum += inputProgress;
                    }
                    progress = 1.0f * progSum / (float)ProgressHelper.this.inputs.size();
                } else {
                    progress = 1.0f;
                }
                ProgressHelper.this.processorContext.setProgress(progress);
            }
            catch (ProgressFailedException pe) {
                LOG.warn("Encountered ProgressFailedException during Processor progress update" + pe);
            }
            catch (InterruptedException ie) {
                LOG.warn("Encountered InterruptedException during Processor progress update" + ie);
            }
        }
    };

    public ProgressHelper(Map<String, LogicalInput> _inputs, ProcessorContext context, String processorName) {
        this.inputs = _inputs;
        this.processorContext = context;
        this.processorName = processorName;
    }

    public void scheduleProgressTaskService(long delay, long period) {
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TaskProgressService{" + this.processorName + ":" + this.processorContext.getTaskVertexName() + "} #%d").build());
        this.scheduledExecutorService.scheduleWithFixedDelay(this.monitorProgress, delay, period, TimeUnit.MILLISECONDS);
    }

    public void shutDownProgressTaskService() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
        }
    }
}

