/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.OfflineIterator;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.hadoop.io.Text;

public class OfflineScanner
extends ScannerOptions
implements Scanner {
    private int batchSize;
    private int timeOut;
    private Range range;
    private Instance instance;
    private TCredentials credentials;
    private Authorizations authorizations;
    private Text tableId;

    public OfflineScanner(Instance instance, TCredentials credentials, String tableId, Authorizations authorizations) {
        ArgumentChecker.notNull(instance, credentials, tableId, authorizations);
        this.instance = instance;
        this.credentials = credentials;
        this.tableId = new Text(tableId);
        this.range = new Range((Key)null, (Key)null);
        this.authorizations = authorizations;
        this.batchSize = 1000;
        this.timeOut = Integer.MAX_VALUE;
    }

    @Override
    @Deprecated
    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    @Override
    @Deprecated
    public int getTimeOut() {
        return this.timeOut;
    }

    @Override
    public void setRange(Range range) {
        this.range = range;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void enableIsolation() {
    }

    @Override
    public void disableIsolation() {
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        return new OfflineIterator(this, this.instance, this.credentials, this.authorizations, this.tableId, this.range);
    }
}

