/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AccumuloInputFormat
extends InputFormatBase<Key, Value> {
    public RecordReader<Key, Value> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        log.setLevel(AccumuloInputFormat.getLogLevel((JobContext)context));
        return new InputFormatBase.RecordReaderBase<Key, Value>(){

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (this.scannerIterator.hasNext()) {
                    ++this.numKeysRead;
                    Map.Entry entry = (Map.Entry)this.scannerIterator.next();
                    this.currentKey = (Key)entry.getKey();
                    this.currentK = this.currentKey;
                    this.currentValue = (Value)entry.getValue();
                    this.currentV = this.currentValue;
                    if (InputFormatBase.log.isTraceEnabled()) {
                        InputFormatBase.log.trace((Object)("Processing key/value pair: " + DefaultFormatter.formatEntry(entry, true)));
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

