/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.mock.MockAccumulo;
import org.apache.accumulo.core.client.mock.MockConnector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.security.thrift.AuthInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

public class MockInstance
implements Instance {
    static final String genericAddress = "localhost:1234";
    static final Map<String, MockAccumulo> instances = new HashMap<String, MockAccumulo>();
    MockAccumulo acu;
    String instanceName;
    AccumuloConfiguration conf = null;

    public MockInstance() {
        this.acu = new MockAccumulo(MockInstance.getDefaultFileSystem());
        this.instanceName = "mock-instance";
    }

    static FileSystem getDefaultFileSystem() {
        try {
            Configuration conf = CachedConfiguration.getInstance();
            conf.set("fs.file.impl", "org.apache.hadoop.fs.LocalFileSystem");
            conf.set("fs.default.name", "file:///");
            return FileSystem.get((Configuration)CachedConfiguration.getInstance());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public MockInstance(String instanceName) {
        this(instanceName, MockInstance.getDefaultFileSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockInstance(String instanceName, FileSystem fs) {
        Map<String, MockAccumulo> map = instances;
        synchronized (map) {
            if (instances.containsKey(instanceName)) {
                this.acu = instances.get(instanceName);
            } else {
                this.acu = new MockAccumulo(fs);
                instances.put(instanceName, this.acu);
            }
        }
        this.instanceName = instanceName;
    }

    @Override
    public String getRootTabletLocation() {
        return genericAddress;
    }

    @Override
    public List<String> getMasterLocations() {
        return Collections.singletonList(genericAddress);
    }

    @Override
    public String getInstanceID() {
        return "mock-instance-id";
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public String getZooKeepers() {
        return "localhost";
    }

    @Override
    public int getZooKeepersSessionTimeOut() {
        return 30000;
    }

    @Override
    @Deprecated
    public Connector getConnector(String user, byte[] pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, new PasswordToken(pass));
    }

    @Override
    @Deprecated
    public Connector getConnector(String user, ByteBuffer pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, ByteBufferUtil.toBytes(pass));
    }

    @Override
    @Deprecated
    public Connector getConnector(String user, CharSequence pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, TextUtil.getBytes(new Text(((Object)pass).toString())));
    }

    @Override
    public AccumuloConfiguration getConfiguration() {
        if (this.conf == null) {
            this.conf = AccumuloConfiguration.getDefaultConfiguration();
        }
        return this.conf;
    }

    @Override
    public void setConfiguration(AccumuloConfiguration conf) {
        this.conf = conf;
    }

    @Override
    @Deprecated
    public Connector getConnector(AuthInfo auth) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(auth.user, auth.password);
    }

    @Override
    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        MockConnector conn = new MockConnector(principal, this.acu, this);
        if (!this.acu.users.containsKey(principal)) {
            ((Connector)conn).securityOperations().createLocalUser(principal, (PasswordToken)token);
        } else if (!this.acu.users.get((Object)principal).token.equals(token)) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.BAD_CREDENTIALS);
        }
        return conn;
    }
}

