/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.log4j.Logger;

public class DefaultConfiguration
extends AccumuloConfiguration {
    private static DefaultConfiguration instance = null;
    private static Logger log = Logger.getLogger(DefaultConfiguration.class);

    public static synchronized DefaultConfiguration getInstance() {
        if (instance == null) {
            instance = new DefaultConfiguration();
            ConfigSanityCheck.validate(instance);
        }
        return instance;
    }

    @Override
    public String get(Property property) {
        return property.getDefaultValue();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        TreeMap<String, String> entries = new TreeMap<String, String>();
        for (Property prop : Property.values()) {
            if (prop.isExperimental() || prop.getType().equals((Object)PropertyType.PREFIX)) continue;
            entries.put(prop.getKey(), prop.getDefaultValue());
        }
        return entries.entrySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateDocumentation(PrintStream doc) {
        InputStream data = DefaultConfiguration.class.getResourceAsStream("config.html");
        if (data != null) {
            byte[] buffer = new byte[1024];
            try {
                int n;
                while ((n = data.read(buffer)) > 0) {
                    doc.print(new String(buffer, 0, n));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    data.close();
                }
                catch (IOException ex) {
                    log.error((Object)ex, (Throwable)ex);
                }
            }
        }
        doc.println();
        ArrayList<Property> prefixes = new ArrayList<Property>();
        TreeMap<String, Property> sortedProps = new TreeMap<String, Property>();
        for (Property prop : Property.values()) {
            if (prop.isExperimental()) continue;
            if (prop.getType().equals((Object)PropertyType.PREFIX)) {
                prefixes.add(prop);
                continue;
            }
            sortedProps.put(prop.getKey(), prop);
        }
        int indentDepth = 2;
        doc.println(DefaultConfiguration.indent(indentDepth++) + "<p>Jump to: ");
        String delimiter = "";
        for (Property prefix : prefixes) {
            if (prefix.isExperimental()) continue;
            doc.print(delimiter + "<a href='#" + prefix.name() + "'>" + prefix.getKey() + "*</a>");
            delimiter = "&nbsp;|&nbsp;";
        }
        doc.println(DefaultConfiguration.indent(--indentDepth) + "</p>");
        doc.println(DefaultConfiguration.indent(indentDepth++) + "<table>");
        for (Property prefix : prefixes) {
            if (prefix.isExperimental()) continue;
            boolean isDeprecated = prefix.isDeprecated();
            doc.println(DefaultConfiguration.indent(indentDepth) + "<tr><td colspan='5'" + (isDeprecated ? " class='deprecated'" : "") + "><a id='" + prefix.name() + "' class='large'>" + prefix.getKey() + "*</a></td></tr>");
            doc.println(DefaultConfiguration.indent(indentDepth) + "<tr><td colspan='5'" + (isDeprecated ? " class='deprecated'" : "") + "><i>" + (isDeprecated ? "<b><i>Deprecated.</i></b> " : "") + prefix.getDescription() + "</i></td></tr>");
            if (!(prefix.equals((Object)Property.TABLE_CONSTRAINT_PREFIX) || prefix.equals((Object)Property.TABLE_ITERATOR_PREFIX) || prefix.equals((Object)Property.TABLE_LOCALITY_GROUP_PREFIX))) {
                doc.println(DefaultConfiguration.indent(indentDepth) + "<tr><th>Property</th><th>Type</th><th>Zookeeper Mutable</th><th>Default Value</th><th>Description</th></tr>");
            }
            boolean highlight = true;
            for (Property prop : sortedProps.values()) {
                if (prop.isExperimental()) continue;
                boolean bl = isDeprecated = prefix.isDeprecated() || prop.isDeprecated();
                if (!prop.getKey().startsWith(prefix.getKey())) continue;
                doc.println(DefaultConfiguration.indent(indentDepth++) + "<tr" + (highlight ? " class='highlight'" : "") + ">");
                highlight = !highlight;
                doc.println(DefaultConfiguration.indent(indentDepth) + "<td" + (isDeprecated ? " class='deprecated'" : "") + ">" + prop.getKey() + "</td>");
                doc.println(DefaultConfiguration.indent(indentDepth) + "<td" + (isDeprecated ? " class='deprecated'" : "") + "><b><a href='#" + prop.getType().name() + "'>" + prop.getType().toString().replaceAll(" ", "&nbsp;") + "</a></b></td>");
                String zoo = "no";
                if (Property.isValidZooPropertyKey(prop.getKey())) {
                    zoo = "yes";
                    if (Property.isFixedZooPropertyKey(prop)) {
                        zoo = "yes but requires restart of the " + prop.getKey().split("[.]")[0];
                    }
                }
                doc.println(DefaultConfiguration.indent(indentDepth) + "<td" + (isDeprecated ? " class='deprecated'" : "") + ">" + zoo + "</td>");
                doc.println(DefaultConfiguration.indent(indentDepth) + "<td" + (isDeprecated ? " class='deprecated'" : "") + "><pre>" + (prop.getRawDefaultValue().isEmpty() ? "&nbsp;" : prop.getRawDefaultValue().replaceAll(" ", "&nbsp;")) + "</pre></td>");
                doc.println(DefaultConfiguration.indent(indentDepth) + "<td" + (isDeprecated ? " class='deprecated'" : "") + ">" + (isDeprecated ? "<b><i>Deprecated.</i></b> " : "") + prop.getDescription() + "</td>");
                doc.println(DefaultConfiguration.indent(--indentDepth) + "</tr>");
            }
        }
        doc.println(DefaultConfiguration.indent(--indentDepth) + "</table>");
        doc.println(DefaultConfiguration.indent(indentDepth) + "<h1>Property Type Descriptions</h1>");
        doc.println(DefaultConfiguration.indent(indentDepth++) + "<table>");
        doc.println(DefaultConfiguration.indent(indentDepth) + "<tr><th>Property Type</th><th>Description</th></tr>");
        boolean highlight = true;
        for (PropertyType type : PropertyType.values()) {
            if (type.equals((Object)PropertyType.PREFIX)) continue;
            doc.println(DefaultConfiguration.indent(indentDepth++) + "<tr " + (highlight ? "class='highlight'" : "") + ">");
            highlight = !highlight;
            doc.println(DefaultConfiguration.indent(indentDepth) + "<td><h3><a id='" + type.name() + "'>" + (Object)((Object)type) + "</a></h3></td>");
            doc.println(DefaultConfiguration.indent(indentDepth) + "<td>" + type.getFormatDescription() + "</td>");
            doc.println(DefaultConfiguration.indent(--indentDepth) + "</tr>");
        }
        doc.println(DefaultConfiguration.indent(--indentDepth) + "</table>");
        doc.println(DefaultConfiguration.indent(--indentDepth) + "</body>");
        doc.println(DefaultConfiguration.indent(--indentDepth) + "</html>");
        doc.close();
    }

    private static String indent(int depth) {
        StringBuilder sb = new StringBuilder();
        for (int d = 0; d < depth; ++d) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (args.length != 2 || !args[0].equals("--generate-doc")) {
            throw new IllegalArgumentException("Usage: " + DefaultConfiguration.class.getName() + " --generate-doc <filename>");
        }
        DefaultConfiguration.generateDocumentation(new PrintStream(args[1]));
    }
}

