/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.log4j.Logger;

public class Value
implements WritableComparable<Object> {
    protected byte[] value;
    private static final Logger log = Logger.getLogger(Value.class);

    public Value() {
    }

    public Value(byte[] bytes) {
        this(bytes, false);
    }

    public Value(ByteBuffer bytes) {
        this(ByteBufferUtil.toBytes(bytes), false);
    }

    public Value(ByteBuffer bytes, boolean copy) {
        this(ByteBufferUtil.toBytes(bytes), copy);
    }

    public Value(byte[] bytes, boolean copy) {
        if (!copy) {
            this.value = bytes;
        } else {
            this.value = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.value, 0, bytes.length);
        }
    }

    public Value(Value ibw) {
        this(ibw.get(), 0, ibw.getSize());
    }

    public Value(byte[] newData, int offset, int length) {
        this.value = new byte[length];
        System.arraycopy(newData, offset, this.value, 0, length);
    }

    public byte[] get() {
        if (this.value == null) {
            throw new IllegalStateException("Uninitialized. Null constructor called w/o accompanying readFields invocation");
        }
        return this.value;
    }

    public void set(byte[] b) {
        this.value = b;
    }

    public void copy(byte[] b) {
        this.value = new byte[b.length];
        System.arraycopy(b, 0, this.value, 0, b.length);
    }

    public int getSize() {
        if (this.value == null) {
            throw new IllegalStateException("Uninitialized. Null constructor called w/o accompanying readFields invocation");
        }
        return this.value.length;
    }

    public void readFields(DataInput in) throws IOException {
        this.value = new byte[in.readInt()];
        in.readFully(this.value, 0, this.value.length);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.value.length);
        out.write(this.value, 0, this.value.length);
    }

    public int hashCode() {
        return WritableComparator.hashBytes((byte[])this.value, (int)this.value.length);
    }

    public int compareTo(Object right_obj) {
        return this.compareTo(((Value)right_obj).get());
    }

    public int compareTo(byte[] that) {
        int diff = this.value.length - that.length;
        return diff != 0 ? diff : WritableComparator.compareBytes((byte[])this.value, (int)0, (int)this.value.length, (byte[])that, (int)0, (int)that.length);
    }

    public boolean equals(Object right_obj) {
        if (right_obj instanceof byte[]) {
            return this.compareTo((byte[])right_obj) == 0;
        }
        if (right_obj instanceof Value) {
            return this.compareTo(right_obj) == 0;
        }
        return false;
    }

    public String toString() {
        String retValue = "";
        try {
            retValue = new String(this.get(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.toString());
        }
        return retValue;
    }

    public static byte[][] toArray(List<byte[]> array) {
        byte[][] results = new byte[array.size()][];
        for (int i = 0; i < array.size(); ++i) {
            results[i] = array.get(i);
        }
        return results;
    }

    static {
        WritableComparator.define(Value.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        private BytesWritable.Comparator comparator = new BytesWritable.Comparator();

        public Comparator() {
            super(Value.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return this.comparator.compare(b1, s1, l1, b2, s2, l2);
        }
    }
}

