/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.DispatchingFileFactory;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public abstract class FileOperations {
    private static final HashSet<String> validExtensions = new HashSet<String>(Arrays.asList("map", "rf"));

    public static Set<String> getValidExtensions() {
        return validExtensions;
    }

    public static String getNewFileExtension(AccumuloConfiguration acuconf) {
        return acuconf.get(Property.TABLE_FILE_TYPE);
    }

    public static FileOperations getInstance() {
        return new DispatchingFileFactory();
    }

    public abstract FileSKVIterator openReader(String var1, Range var2, Set<ByteSequence> var3, boolean var4, FileSystem var5, Configuration var6, AccumuloConfiguration var7) throws IOException;

    public abstract FileSKVIterator openReader(String var1, Range var2, Set<ByteSequence> var3, boolean var4, FileSystem var5, Configuration var6, AccumuloConfiguration var7, BlockCache var8, BlockCache var9) throws IOException;

    public abstract FileSKVIterator openReader(String var1, boolean var2, FileSystem var3, Configuration var4, AccumuloConfiguration var5) throws IOException;

    public abstract FileSKVIterator openReader(String var1, boolean var2, FileSystem var3, Configuration var4, AccumuloConfiguration var5, BlockCache var6, BlockCache var7) throws IOException;

    public abstract FileSKVWriter openWriter(String var1, FileSystem var2, Configuration var3, AccumuloConfiguration var4) throws IOException;

    public abstract FileSKVIterator openIndex(String var1, FileSystem var2, Configuration var3, AccumuloConfiguration var4) throws IOException;

    public abstract FileSKVIterator openIndex(String var1, FileSystem var2, Configuration var3, AccumuloConfiguration var4, BlockCache var5, BlockCache var6) throws IOException;

    public abstract long getFileSize(String var1, FileSystem var2, Configuration var3, AccumuloConfiguration var4) throws IOException;
}

