/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.log4j.Logger;

public class DebugIterator
extends WrappingIterator
implements OptionDescriber {
    private String prefix;
    private static final Logger log = Logger.getLogger(DebugIterator.class);

    public DebugIterator() {
    }

    public DebugIterator deepCopy(IteratorEnvironment env) {
        return new DebugIterator(this, env);
    }

    private DebugIterator(DebugIterator other, IteratorEnvironment env) {
        this.setSource(other.getSource().deepCopy(env));
        this.prefix = other.prefix;
    }

    public DebugIterator(String prefix, SortedKeyValueIterator<Key, Value> source) {
        this.prefix = prefix;
        this.setSource(source);
    }

    @Override
    public Key getTopKey() {
        Key wc = super.getTopKey();
        log.debug((Object)(this.prefix + " getTopKey() --> " + wc));
        return wc;
    }

    @Override
    public Value getTopValue() {
        Value w = super.getTopValue();
        log.debug((Object)(this.prefix + " getTopValue() --> " + w));
        return w;
    }

    @Override
    public boolean hasTop() {
        boolean b = super.hasTop();
        log.debug((Object)(this.prefix + " hasTop() --> " + b));
        return b;
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        log.debug((Object)(this.prefix + " seek(" + range + ", " + columnFamilies + ", " + inclusive + ")"));
        super.seek(range, columnFamilies, inclusive);
    }

    @Override
    public void next() throws IOException {
        log.debug((Object)(this.prefix + " next()"));
        super.next();
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        log.debug((Object)("init(" + source + ", " + options + ", " + env + ")"));
        if (null == this.prefix) {
            this.prefix = String.format("0x%08X", this.hashCode());
        }
        super.init(source, options, env);
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        return new OptionDescriber.IteratorOptions("debug", DebugIterator.class.getSimpleName() + " prints debug information on each SortedKeyValueIterator method invocation", null, null);
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        return true;
    }
}

