/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.aggregation;

import java.io.IOException;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.aggregation.Aggregator;
import org.apache.log4j.Logger;

@Deprecated
public class LongSummation
implements Aggregator {
    private static final Logger log = Logger.getLogger(LongSummation.class);
    long sum = 0L;

    @Override
    public Value aggregate() {
        return new Value(LongSummation.longToBytes(this.sum));
    }

    @Override
    public void collect(Value value) {
        try {
            this.sum += LongSummation.bytesToLong(value.get());
        }
        catch (IOException e) {
            log.error((Object)(LongSummation.class.getSimpleName() + " trying to convert bytes to long, but byte array isn't length 8"));
        }
    }

    @Override
    public void reset() {
        this.sum = 0L;
    }

    public static long bytesToLong(byte[] b) throws IOException {
        return LongSummation.bytesToLong(b, 0);
    }

    public static long bytesToLong(byte[] b, int offset) throws IOException {
        if (b.length < offset + 8) {
            throw new IOException("trying to convert to long, but byte array isn't long enough, wanted " + (offset + 8) + " found " + b.length);
        }
        return ((long)b[offset + 0] << 56) + ((long)(b[offset + 1] & 0xFF) << 48) + ((long)(b[offset + 2] & 0xFF) << 40) + ((long)(b[offset + 3] & 0xFF) << 32) + ((long)(b[offset + 4] & 0xFF) << 24) + (long)((b[offset + 5] & 0xFF) << 16) + (long)((b[offset + 6] & 0xFF) << 8) + (long)((b[offset + 7] & 0xFF) << 0);
    }

    public static byte[] longToBytes(long l) {
        byte[] b = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)(l >>> 0)};
        return b;
    }
}

