/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class GetAuthsCommand
extends Shell.Command {
    private Option userOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        String user = cl.getOptionValue(this.userOpt.getOpt(), shellState.getConnector().whoami());
        shellState.getReader().printString(shellState.getConnector().securityOperations().getUserAuthorizations(user) + "\n");
        return 0;
    }

    @Override
    public String description() {
        return "displays the maximum scan authorizations for a user";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("user");
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

