/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListIterCommand
extends Shell.Command {
    private Option nameOpt;
    private Map<IteratorUtil.IteratorScope, Option> scopeOpts;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        Map<String, EnumSet<IteratorUtil.IteratorScope>> iterators = shellState.getConnector().tableOperations().listIterators(tableName);
        if (cl.hasOption(this.nameOpt.getOpt())) {
            String name = cl.getOptionValue(this.nameOpt.getOpt());
            if (!iterators.containsKey(name)) {
                Shell.log.warn((Object)"no iterators found that match your criteria");
                return 0;
            }
            EnumSet<IteratorUtil.IteratorScope> scopes = iterators.get(name);
            iterators.clear();
            iterators.put(name, scopes);
        }
        boolean hasScope = false;
        for (IteratorUtil.IteratorScope scope : IteratorUtil.IteratorScope.values()) {
            if (!cl.hasOption(this.scopeOpts.get((Object)scope).getOpt())) continue;
            hasScope = true;
        }
        if (!hasScope) {
            throw new IllegalArgumentException("You must select at least one scope to configure");
        }
        StringBuilder sb = new StringBuilder("-\n");
        for (String name : iterators.keySet()) {
            for (IteratorUtil.IteratorScope scope : iterators.get(name)) {
                if (!cl.hasOption(this.scopeOpts.get((Object)scope).getOpt())) continue;
                IteratorSetting setting = shellState.getConnector().tableOperations().getIteratorSetting(tableName, name, scope);
                sb.append("-    Iterator ").append(setting.getName()).append(", ").append((Object)scope).append(" scope options:\n");
                sb.append("-        ").append("iteratorPriority").append(" = ").append(setting.getPriority()).append("\n");
                sb.append("-        ").append("iteratorClassName").append(" = ").append(setting.getIteratorClass()).append("\n");
                for (Map.Entry<String, String> optEntry : setting.getOptions().entrySet()) {
                    sb.append("-        ").append(optEntry.getKey()).append(" = ").append(optEntry.getValue()).append("\n");
                }
            }
        }
        sb.append("-\n");
        shellState.getReader().printString(sb.toString());
        return 0;
    }

    @Override
    public String description() {
        return "lists table-specific iterators configured in this shell session";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.nameOpt = new Option("n", "name", true, "iterator to list");
        this.nameOpt.setArgName("itername");
        this.scopeOpts = new EnumMap<IteratorUtil.IteratorScope, Option>(IteratorUtil.IteratorScope.class);
        this.scopeOpts.put(IteratorUtil.IteratorScope.minc, new Option(IteratorUtil.IteratorScope.minc.name(), "minor-compaction", false, "list iterator for minor compaction scope"));
        this.scopeOpts.put(IteratorUtil.IteratorScope.majc, new Option(IteratorUtil.IteratorScope.majc.name(), "major-compaction", false, "list iterator for major compaction scope"));
        this.scopeOpts.put(IteratorUtil.IteratorScope.scan, new Option(IteratorUtil.IteratorScope.scan.name(), "scan-time", false, "list iterator for scan scope"));
        o.addOption(OptUtil.tableOpt("table to list the configured iterators on"));
        o.addOption(this.nameOpt);
        for (Option opt : this.scopeOpts.values()) {
            o.addOption(opt);
        }
        return o;
    }
}

