/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.AVG;
import org.apache.pig.builtin.BigDecimalAvg;
import org.apache.pig.builtin.BigDecimalMax;
import org.apache.pig.builtin.BigDecimalMin;
import org.apache.pig.builtin.BigDecimalSum;
import org.apache.pig.builtin.COUNT;
import org.apache.pig.builtin.DoubleAvg;
import org.apache.pig.builtin.DoubleMax;
import org.apache.pig.builtin.DoubleMin;
import org.apache.pig.builtin.DoubleSum;
import org.apache.pig.builtin.FloatAvg;
import org.apache.pig.builtin.FloatMax;
import org.apache.pig.builtin.FloatMin;
import org.apache.pig.builtin.IntAvg;
import org.apache.pig.builtin.IntMax;
import org.apache.pig.builtin.IntMin;
import org.apache.pig.builtin.LongAvg;
import org.apache.pig.builtin.LongMax;
import org.apache.pig.builtin.LongMin;
import org.apache.pig.builtin.LongSum;
import org.apache.pig.builtin.MAX;
import org.apache.pig.builtin.MIN;
import org.apache.pig.builtin.SUM;
import org.apache.pig.builtin.StringMax;
import org.apache.pig.builtin.StringMin;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Over
extends EvalFunc<DataBag> {
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private int rowsBefore;
    private int rowsAfter;
    private String agg;
    private boolean initialized = false;
    private EvalFunc<? extends Object> func = null;
    private Object[] udfArgs = null;
    private byte returnType = 0;
    private String returnName;
    private boolean searchInnerType = false;

    public Over() {
    }

    public Over(String typespec) {
        this();
        if (typespec.contains(":")) {
            String[] fn_tn = typespec.split(":", 2);
            this.returnName = fn_tn[0];
            this.returnType = DataType.findTypeByName((String)fn_tn[1]);
        } else if (Boolean.parseBoolean(typespec)) {
            this.searchInnerType = Boolean.parseBoolean(typespec);
        } else {
            this.returnName = "result";
            this.returnType = DataType.findTypeByName((String)typespec);
        }
    }

    public DataBag exec(Tuple input) throws IOException {
        if (input == null || input.size() < 2) {
            int errCode = 2107;
            String msg = "Over expected 2 or more inputs but received " + input.size();
            throw new ExecException(msg, errCode, 2);
        }
        DataBag inbag = null;
        try {
            inbag = (DataBag)input.get(0);
        }
        catch (ClassCastException cce) {
            int errCode = 2107;
            String msg = "Over expected a bag for arg 1 but received " + DataType.findTypeName((Object)input.get(0));
            throw new ExecException(msg, errCode, 2);
        }
        if (!this.initialized) {
            this.init(input);
        } else if (this.func instanceof ResetableEvalFunc) {
            ((ResetableEvalFunc)this.func).reset();
        }
        OverBag tmpbag = new OverBag(inbag, this.rowsBefore, this.rowsAfter);
        Tuple tmptuple = mTupleFactory.newTuple(1);
        tmptuple.set(0, (Object)tmpbag);
        DataBag outbag = BagFactory.getInstance().newDefaultBag();
        int i = 0;
        while ((long)i < inbag.size()) {
            tmpbag.setCurrentRow(i);
            Tuple t = mTupleFactory.newTuple(1);
            t.set(0, this.func.exec(tmptuple));
            outbag.add(t);
            ++i;
        }
        return outbag;
    }

    public Schema outputSchema(Schema inputSch) {
        try {
            Schema.FieldSchema field;
            if (this.searchInnerType) {
                field = new Schema.FieldSchema(inputSch.getField(0));
                while (this.searchInnerType) {
                    if (field.schema != null && field.schema.getFields().size() > 1) {
                        this.searchInnerType = false;
                        continue;
                    }
                    if (field.type == 110 || field.type == 120) {
                        field = new Schema.FieldSchema(field.schema.getField(0));
                        continue;
                    }
                    field.alias = field.alias + "_over";
                    this.searchInnerType = false;
                }
                this.searchInnerType = true;
            } else {
                if (this.returnType == 0) {
                    return Schema.generateNestedSchema((byte)120, (byte[])new byte[]{1});
                }
                field = new Schema.FieldSchema(this.returnName, this.returnType);
            }
            Schema outputTupleSchema = new Schema(field);
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), inputSch), outputTupleSchema, 120));
        }
        catch (FrontendException fe) {
            throw new RuntimeException("Unable to create nested schema", fe);
        }
    }

    private void init(Tuple input) throws IOException {
        this.initialized = true;
        try {
            this.agg = (String)input.get(1);
        }
        catch (ClassCastException cce) {
            int errCode = 2107;
            String msg = "Over expected a string for arg 2 but received " + DataType.findTypeName((Object)input.get(1));
            throw new ExecException(msg, errCode, 2);
        }
        this.rowsBefore = -1;
        if (input.size() > 2) {
            try {
                this.rowsBefore = (Integer)input.get(2);
            }
            catch (ClassCastException cce) {
                int errCode = 2107;
                String msg = "Over expected an integer for arg 3 but received " + DataType.findTypeName((Object)input.get(2));
                throw new ExecException(msg, errCode, 2);
            }
        }
        this.rowsAfter = 0;
        if (input.size() > 3) {
            try {
                this.rowsAfter = (Integer)input.get(3);
            }
            catch (ClassCastException cce) {
                int errCode = 2107;
                String msg = "Over expected an integer for arg 4 but received " + DataType.findTypeName((Object)input.get(3));
                throw new ExecException(msg, errCode, 2);
            }
        }
        if (input.size() > 4) {
            this.udfArgs = new Object[input.size() - 4];
            for (int i = 0; i < input.size() - 4; ++i) {
                this.udfArgs[i] = input.get(i + 4);
            }
        }
        if ("count".equalsIgnoreCase(this.agg)) {
            this.func = new COUNT();
        } else if ("sum(double)".equalsIgnoreCase(this.agg) || "sum(float)".equalsIgnoreCase(this.agg)) {
            this.func = new DoubleSum();
        } else if ("sum(int)".equalsIgnoreCase(this.agg) || "sum(long)".equalsIgnoreCase(this.agg)) {
            this.func = new LongSum();
        } else if ("sum(bytearray)".equalsIgnoreCase(this.agg)) {
            this.func = new SUM();
        } else if ("sum(bigdecimal)".equalsIgnoreCase(this.agg)) {
            this.func = new BigDecimalSum();
        } else if ("avg(double)".equalsIgnoreCase(this.agg)) {
            this.func = new DoubleAvg();
        } else if ("avg(float)".equalsIgnoreCase(this.agg)) {
            this.func = new FloatAvg();
        } else if ("avg(long)".equalsIgnoreCase(this.agg)) {
            this.func = new LongAvg();
        } else if ("avg(int)".equalsIgnoreCase(this.agg)) {
            this.func = new IntAvg();
        } else if ("avg(bytearray)".equalsIgnoreCase(this.agg)) {
            this.func = new AVG();
        } else if ("avg(bigdecimal)".equalsIgnoreCase(this.agg)) {
            this.func = new BigDecimalAvg();
        } else if ("min(double)".equalsIgnoreCase(this.agg)) {
            this.func = new DoubleMin();
        } else if ("min(float)".equalsIgnoreCase(this.agg)) {
            this.func = new FloatMin();
        } else if ("min(long)".equalsIgnoreCase(this.agg)) {
            this.func = new LongMin();
        } else if ("min(int)".equalsIgnoreCase(this.agg)) {
            this.func = new IntMin();
        } else if ("min(chararray)".equalsIgnoreCase(this.agg)) {
            this.func = new StringMin();
        } else if ("min(bytearray)".equalsIgnoreCase(this.agg)) {
            this.func = new MIN();
        } else if ("min(bigdecimal)".equalsIgnoreCase(this.agg)) {
            this.func = new BigDecimalMin();
        } else if ("max(double)".equalsIgnoreCase(this.agg)) {
            this.func = new DoubleMax();
        } else if ("max(float)".equalsIgnoreCase(this.agg)) {
            this.func = new FloatMax();
        } else if ("max(long)".equalsIgnoreCase(this.agg)) {
            this.func = new LongMax();
        } else if ("max(int)".equalsIgnoreCase(this.agg)) {
            this.func = new IntMax();
        } else if ("max(chararray)".equalsIgnoreCase(this.agg)) {
            this.func = new StringMax();
        } else if ("max(bytearray)".equalsIgnoreCase(this.agg)) {
            this.func = new MAX();
        } else if ("max(bigdecimal)".equalsIgnoreCase(this.agg)) {
            this.func = new BigDecimalMax();
        } else if ("row_number".equalsIgnoreCase(this.agg)) {
            this.func = new RowNumber();
        } else if ("first_value".equalsIgnoreCase(this.agg)) {
            this.func = new FirstValue();
        } else if ("last_value".equalsIgnoreCase(this.agg)) {
            this.func = new LastValue();
        } else if ("lead".equalsIgnoreCase(this.agg)) {
            this.func = new Lead(this.udfArgs);
        } else if ("lag".equalsIgnoreCase(this.agg)) {
            this.func = new Lag(this.udfArgs);
        } else if ("rank".equalsIgnoreCase(this.agg)) {
            this.func = new Rank(this.udfArgs);
        } else if ("dense_rank".equalsIgnoreCase(this.agg)) {
            this.func = new DenseRank(this.udfArgs);
        } else if ("ntile".equalsIgnoreCase(this.agg)) {
            this.func = new Ntile(this.udfArgs);
        } else if ("percent_rank".equalsIgnoreCase(this.agg)) {
            this.func = new PercentRank(this.udfArgs);
        } else if ("cume_dist".equalsIgnoreCase(this.agg)) {
            this.func = new CumeDist();
        } else if ("debug".equalsIgnoreCase(this.agg)) {
            this.func = new Debug();
        } else {
            throw new ExecException("Unknown aggregate " + this.agg);
        }
    }

    private static class Debug
    extends EvalFunc<String> {
        private Debug() {
        }

        public String exec(Tuple input) throws IOException {
            DataBag inbag = (DataBag)input.get(0);
            OverBag.OverBagIterator iter = (OverBag.OverBagIterator)inbag.iterator();
            System.out.println("Current row " + iter.currentRow + " begin " + iter.begin + " end " + iter.end + " nextRow " + iter.nextRow + " size " + iter.tuples.size());
            System.out.print("{");
            while (iter.hasNext()) {
                Tuple t = iter.next();
                if (t == null) {
                    System.out.print("null,");
                    continue;
                }
                System.out.print(t.toString() + ",");
            }
            System.out.println("}");
            return "bla";
        }
    }

    private static class Ntile
    extends ResetableEvalFunc<Integer> {
        int numBuckets;

        protected Ntile(Object[] args) throws IOException {
            if (args == null || args.length != 1) {
                throw new ExecException("Ntile args must contain arg describing how to split data, e.g. ntile(4)", 2107, 2);
            }
            try {
                this.numBuckets = (Integer)args[0];
            }
            catch (ClassCastException cce) {
                throw new ExecException("Ntile expected integer argument but received " + DataType.findTypeName((Object)args[0]), 2107, 2);
            }
            this.reset();
        }

        public Integer exec(Tuple input) throws IOException {
            DataBag inbag = (DataBag)input.get(0);
            OverBag.OverBagIterator iter = (OverBag.OverBagIterator)inbag.iterator();
            int val = 0;
            val = this.numBuckets >= iter.tuples.size() ? this.currentRow + 1 : this.currentRow * this.numBuckets / iter.tuples.size() + 1;
            ++this.currentRow;
            return val;
        }
    }

    private static class CumeDist
    extends ResetableEvalFunc<Double> {
        private CumeDist() {
        }

        public Double exec(Tuple input) throws IOException {
            DataBag inbag = (DataBag)input.get(0);
            OverBag.OverBagIterator iter = (OverBag.OverBagIterator)inbag.iterator();
            return (double)(++this.currentRow) / (double)iter.tuples.size();
        }
    }

    private static class PercentRank
    extends BaseRank<Double> {
        PercentRank(Object[] args) throws IOException {
            super(args);
        }

        @Override
        protected void incrementRank() {
            this.lastRankUsed += this.timesThisRankUsed;
        }

        @Override
        protected Double calculateRank(OverBag.OverBagIterator iter) {
            return ((double)this.lastRankUsed - 1.0) / ((double)iter.tuples.size() - 1.0);
        }
    }

    private static class DenseRank
    extends BaseRank<Integer> {
        DenseRank(Object[] args) throws IOException {
            super(args);
        }

        @Override
        protected void incrementRank() {
            ++this.lastRankUsed;
        }

        @Override
        protected Integer calculateRank(OverBag.OverBagIterator iter) {
            return this.lastRankUsed;
        }
    }

    private static class Rank
    extends BaseRank<Integer> {
        Rank(Object[] args) throws IOException {
            super(args);
        }

        @Override
        protected void incrementRank() {
            this.lastRankUsed += this.timesThisRankUsed;
        }

        @Override
        protected Integer calculateRank(OverBag.OverBagIterator iter) {
            return this.lastRankUsed;
        }
    }

    private static abstract class BaseRank<T>
    extends ResetableEvalFunc<T> {
        Object[] lastKey;
        int[] orderFields;
        int lastRankUsed;
        int timesThisRankUsed;

        protected BaseRank(Object[] args) throws IOException {
            if (args == null || args.length < 1) {
                throw new ExecException("Rank args must contain ordering column numbers, e.g. rank(1, 2)", 2107, 2);
            }
            this.lastKey = new Object[args.length];
            this.orderFields = new int[args.length];
            for (int i = 0; i < args.length; ++i) {
                try {
                    this.orderFields[i] = (Integer)args[i];
                    continue;
                }
                catch (ClassCastException cce) {
                    throw new ExecException("Rank expected column number in arg " + i + " but received " + DataType.findTypeName((Object)args[i]), 2107, 2);
                }
            }
            this.reset();
        }

        public T exec(Tuple input) throws IOException {
            DataBag inbag = (DataBag)input.get(0);
            OverBag.OverBagIterator iter = (OverBag.OverBagIterator)inbag.iterator();
            if (this.lastRankUsed == 0) {
                for (int i = 0; i < this.lastKey.length; ++i) {
                    this.lastKey[i] = iter.tuples.get(0).get(this.orderFields[i]);
                }
                this.lastRankUsed = 1;
            } else {
                int i;
                boolean keyChange = false;
                for (i = 0; i < this.lastKey.length && !keyChange; ++i) {
                    Object currentKey = iter.tuples.get(this.currentRow).get(this.orderFields[i]);
                    if (this.lastKey[i] == null) {
                        keyChange |= currentKey != null;
                        continue;
                    }
                    keyChange |= !this.lastKey[i].equals(currentKey);
                }
                if (keyChange) {
                    this.incrementRank();
                    this.timesThisRankUsed = 1;
                    for (i = 0; i < this.lastKey.length; ++i) {
                        this.lastKey[i] = iter.tuples.get(this.currentRow).get(this.orderFields[i]);
                    }
                } else {
                    ++this.timesThisRankUsed;
                }
            }
            ++this.currentRow;
            return this.calculateRank(iter);
        }

        @Override
        void reset() {
            super.reset();
            this.lastRankUsed = 0;
            this.timesThisRankUsed = 1;
        }

        protected abstract void incrementRank();

        protected abstract T calculateRank(OverBag.OverBagIterator var1);
    }

    private static class Lag
    extends ResetableEvalFunc<Object> {
        int rowsBehind = 1;
        Object deflt = null;

        Lag(Object[] args) throws IOException {
            if (args != null) {
                if (args.length >= 1) {
                    try {
                        this.rowsBehind = (Integer)args[0];
                    }
                    catch (ClassCastException cce) {
                        int errCode = 2107;
                        String msg = "Lag expected an integer for arg 2  but received " + DataType.findTypeName((Object)args[0]);
                        throw new ExecException(msg, errCode, 2);
                    }
                }
                if (args.length >= 2) {
                    this.deflt = args[1];
                }
            }
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object exec(Tuple input) throws IOException {
            DataBag inbag = (DataBag)input.get(0);
            OverBag.OverBagIterator iter = (OverBag.OverBagIterator)inbag.iterator();
            try {
                if (this.currentRow >= 0) {
                    Object object = iter.tuples.get(this.currentRow).get(0);
                    return object;
                }
                if (this.deflt != null) {
                    Object object = this.deflt;
                    return object;
                }
                Object var4_6 = null;
                return var4_6;
            }
            finally {
                ++this.currentRow;
            }
        }

        @Override
        void reset() {
            this.currentRow = -1 * this.rowsBehind;
        }
    }

    private static class Lead
    extends ResetableEvalFunc<Object> {
        int rowsAhead = 1;
        Object deflt = null;

        Lead(Object[] args) throws IOException {
            if (args != null) {
                if (args.length >= 1) {
                    try {
                        this.rowsAhead = (Integer)args[0];
                    }
                    catch (ClassCastException cce) {
                        int errCode = 2107;
                        String msg = "Lead expected an integer for arg 2  but received " + DataType.findTypeName((Object)args[0]);
                        throw new ExecException(msg, errCode, 2);
                    }
                }
                if (args.length >= 2) {
                    this.deflt = args[1];
                }
            }
            this.reset();
        }

        public Object exec(Tuple input) throws IOException {
            DataBag inbag = (DataBag)input.get(0);
            OverBag.OverBagIterator iter = (OverBag.OverBagIterator)inbag.iterator();
            if (this.currentRow < iter.tuples.size()) {
                return iter.tuples.get(this.currentRow++).get(0);
            }
            if (this.deflt != null) {
                return this.deflt;
            }
            return null;
        }

        @Override
        void reset() {
            this.currentRow = this.rowsAhead;
        }
    }

    private static class LastValue
    extends EvalFunc<Object> {
        private LastValue() {
        }

        public Object exec(Tuple input) throws IOException {
            DataBag inbag = (DataBag)input.get(0);
            OverBag.OverBagIterator iter = (OverBag.OverBagIterator)inbag.iterator();
            return iter.tuples.get(iter.end - 1).get(0);
        }
    }

    private static class FirstValue
    extends EvalFunc<Object> {
        private FirstValue() {
        }

        public Object exec(Tuple input) throws IOException {
            DataBag inbag = (DataBag)input.get(0);
            if (inbag.size() == 0L) {
                return null;
            }
            return ((Tuple)inbag.iterator().next()).get(0);
        }
    }

    private static class RowNumber
    extends ResetableEvalFunc<Integer> {
        private RowNumber() {
        }

        public Integer exec(Tuple input) throws IOException {
            return ++this.currentRow;
        }
    }

    private static abstract class ResetableEvalFunc<K>
    extends EvalFunc<K> {
        protected int currentRow;

        ResetableEvalFunc() {
            this.reset();
        }

        void reset() {
            this.currentRow = 0;
        }
    }

    static class OverBag
    implements DataBag {
        private List<Tuple> tuples;
        private int before;
        private int after;
        private int currentRow;

        OverBag(DataBag bag, int before, int after) {
            this.addAll(bag);
            this.before = before;
            this.after = after;
            this.currentRow = 0;
        }

        public long size() {
            return this.endPosition() - this.startPosition();
        }

        public boolean isSorted() {
            return false;
        }

        public boolean isDistinct() {
            return false;
        }

        public Iterator<Tuple> iterator() {
            return new OverBagIterator(this.tuples, this.currentRow, this.startPosition(), this.endPosition());
        }

        public void add(Tuple t) {
            throw new RuntimeException("OverBag.add not implemented");
        }

        public void addAll(DataBag b) {
            this.tuples = new ArrayList<Tuple>((int)b.size());
            for (Tuple t : b) {
                this.tuples.add(t);
            }
        }

        public void clear() {
            throw new RuntimeException("OverBag.clear not implemented");
        }

        public void markStale(boolean stale) {
            throw new RuntimeException("OverBag.markStale not implemented");
        }

        public void readFields(DataInput in) {
            throw new RuntimeException("OverBag.readFields not implemented");
        }

        public void write(DataOutput out) {
            throw new RuntimeException("OverBag.write not implemented");
        }

        public int compareTo(Object o) {
            throw new RuntimeException("OverBag.compareTo not implemented");
        }

        void setCurrentRow(int cr) {
            this.currentRow = cr;
        }

        private int startPosition() {
            return this.before == -1 ? 0 : this.currentRow - this.before;
        }

        private int endPosition() {
            return this.after == -1 ? this.tuples.size() : this.currentRow + this.after + 1;
        }

        public long spill() {
            return 0L;
        }

        public long getMemorySize() {
            return 0L;
        }

        static class OverBagIterator
        implements Iterator<Tuple> {
            List<Tuple> tuples;
            int currentRow;
            int begin;
            int end;
            int nextRow;

            OverBagIterator(List<Tuple> tuples, int currentRow, int begin, int end) {
                this.tuples = tuples;
                this.currentRow = currentRow;
                this.begin = begin;
                this.end = end;
                this.nextRow = begin;
            }

            @Override
            public boolean hasNext() {
                return this.nextRow < this.end;
            }

            @Override
            public Tuple next() {
                try {
                    if (this.nextRow < 0) {
                        Tuple tuple = mTupleFactory.newTuple(1);
                        return tuple;
                    }
                    if (this.nextRow >= this.tuples.size()) {
                        Tuple tuple = mTupleFactory.newTuple(1);
                        return tuple;
                    }
                    Tuple tuple = this.tuples.get(this.nextRow);
                    return tuple;
                }
                finally {
                    ++this.nextRow;
                }
            }

            @Override
            public void remove() {
                throw new RuntimeException("OverBagIterator.remove not implemented");
            }
        }
    }
}

