/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODemux;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.plan.DotPlanDumper;
import org.apache.pig.impl.plan.Operator;

public class DotPOPrinter
extends DotPlanDumper<PhysicalOperator, PhysicalPlan, PhysicalOperator, PhysicalPlan> {
    public DotPOPrinter(PhysicalPlan plan, PrintStream ps) {
        this(plan, ps, false, (Set<Operator>)new HashSet<Operator>(), (Set<Operator>)new HashSet<Operator>(), (Set<Operator>)new HashSet<Operator>());
    }

    public DotPOPrinter(PhysicalPlan plan, PrintStream ps, boolean isSubGraph, Set<Operator> subgraphs, Set<Operator> multiInputSubgraphs, Set<Operator> multiOutputSubgraphs) {
        super(plan, ps, isSubGraph, subgraphs, multiInputSubgraphs, multiOutputSubgraphs);
    }

    protected DotPlanDumper makeDumper(PhysicalPlan plan, PrintStream ps) {
        DotPOPrinter dumper = new DotPOPrinter(plan, ps, true, (Set<Operator>)this.mSubgraphs, (Set<Operator>)this.mMultiInputSubgraphs, (Set<Operator>)this.mMultiOutputSubgraphs);
        dumper.setVerbose(this.isVerbose());
        return dumper;
    }

    @Override
    protected String getName(PhysicalOperator op) {
        return op.name().split(" - ")[0];
    }

    @Override
    protected String[] getAttributes(PhysicalOperator op) {
        if (op instanceof POStore || op instanceof POLoad) {
            String[] attributes = new String[3];
            String name = this.getName(op);
            int idx = name.lastIndexOf(":");
            if (idx != -1) {
                String part1 = name.substring(0, idx);
                String part2 = name.substring(idx + 1, name.length());
                name = part1 + ",\\n" + part2;
            }
            attributes[0] = "label=\"" + name + "\"";
            attributes[1] = "style=\"filled\"";
            attributes[2] = "fillcolor=\"gray\"";
            return attributes;
        }
        return super.getAttributes(op);
    }

    @Override
    protected Collection<PhysicalPlan> getMultiOutputNestedPlans(PhysicalOperator op) {
        LinkedList<PhysicalPlan> plans = new LinkedList<PhysicalPlan>();
        if (op instanceof POSplit) {
            plans.addAll(((POSplit)op).getPlans());
        } else if (op instanceof PODemux) {
            HashSet<PhysicalPlan> pl = new HashSet<PhysicalPlan>();
            pl.addAll(((PODemux)op).getPlans());
            plans.addAll(pl);
        }
        return plans;
    }

    @Override
    protected Collection<PhysicalPlan> getNestedPlans(PhysicalOperator op) {
        POSkewedJoin skewed;
        Collection<PhysicalPlan> joinPlans;
        LinkedList<PhysicalPlan> plans = new LinkedList<PhysicalPlan>();
        if (op instanceof POFilter) {
            plans.add(((POFilter)op).getPlan());
        } else if (op instanceof POForEach) {
            plans.addAll(((POForEach)op).getInputPlans());
        } else if (op instanceof POSort) {
            plans.addAll(((POSort)op).getSortPlans());
        } else if (op instanceof PORank) {
            plans.addAll(((PORank)op).getRankPlans());
        } else if (op instanceof POCounter) {
            plans.addAll(((POCounter)op).getCounterPlans());
        } else if (op instanceof POLocalRearrange) {
            plans.addAll(((POLocalRearrange)op).getPlans());
        } else if (op instanceof POFRJoin) {
            POFRJoin frj = (POFRJoin)op;
            List<List<PhysicalPlan>> joinPlans2 = frj.getJoinPlans();
            if (joinPlans2 != null) {
                for (List<PhysicalPlan> list : joinPlans2) {
                    plans.addAll(list);
                }
            }
        } else if (op instanceof POSkewedJoin && (joinPlans = (skewed = (POSkewedJoin)op).getJoinPlans().values()) != null) {
            plans.addAll(joinPlans);
        }
        return plans;
    }
}

