/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.runtime.AbstractFunction1;

public class PackageConverter
implements RDDConverter<Tuple, Tuple, POPackage> {
    private static final Log LOG = LogFactory.getLog(PackageConverter.class);

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POPackage physicalOperator) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, physicalOperator, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        return rdd.map((Function1)new PackageFunction(physicalOperator), SparkUtil.getManifest(Tuple.class));
    }

    private static class PackageFunction
    extends AbstractFunction1<Tuple, Tuple>
    implements Serializable {
        private final POPackage physicalOperator;

        public PackageFunction(POPackage physicalOperator) {
            this.physicalOperator = physicalOperator;
        }

        public Tuple apply(final Tuple t) {
            Tuple out;
            Result result;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PackageFunction in " + t));
            }
            try {
                PigNullableWritable key = new PigNullableWritable(){

                    @Override
                    public Object getValueAsPigType() {
                        try {
                            Object keyTuple = t.get(0);
                            return keyTuple;
                        }
                        catch (ExecException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                final Iterator bagIterator = (Iterator)t.get(1);
                Iterator<NullableTuple> iterator = new Iterator<NullableTuple>(){

                    @Override
                    public boolean hasNext() {
                        return bagIterator.hasNext();
                    }

                    @Override
                    public NullableTuple next() {
                        try {
                            Tuple next = (Tuple)bagIterator.next();
                            NullableTuple nullableTuple = new NullableTuple((Tuple)next.get(1));
                            nullableTuple.setIndex(((Number)next.get(0)).byteValue());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Setting index to " + next.get(0) + " for tuple " + (Tuple)next.get(1)));
                            }
                            return nullableTuple;
                        }
                        catch (ExecException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                this.physicalOperator.setInputs(null);
                this.physicalOperator.attachInput(key, iterator);
                result = this.physicalOperator.getNextTuple();
            }
            catch (ExecException e) {
                throw new RuntimeException("Couldn't do Package on tuple: " + t, e);
            }
            if (result == null) {
                throw new RuntimeException("Null response found for Package on tuple: " + t);
            }
            switch (result.returnStatus) {
                case 0: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("PackageFunction out " + result.result));
                    }
                    out = (Tuple)result.result;
                    break;
                }
                case 1: {
                    out = null;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected response code from operator " + this.physicalOperator + " : " + result + " " + result.returnStatus);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PackageFunction out " + out));
            }
            return out;
        }
    }
}

