/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.pig.PigWarning;

public class CompilationMessageCollector
implements Iterable<Message> {
    private List<Message> messageList = new ArrayList<Message>();

    public void collect(String message, MessageType messageType) {
        this.messageList.add(new Message(message, messageType, Unknown.UNKNOWN_MESSAGE_KIND));
    }

    public void collect(String message, MessageType messageType, Enum kind) {
        this.messageList.add(new Message(message, messageType, kind));
    }

    protected boolean hasMessageType(MessageType messageType) {
        Iterator<Message> iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next().getMessageType() != messageType) continue;
            return true;
        }
        return false;
    }

    public boolean hasError() {
        return this.hasMessageType(MessageType.Error);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messageList.iterator();
    }

    public boolean hasMessage() {
        return this.messageList.size() > 0;
    }

    public int size() {
        return this.messageList.size();
    }

    public Message get(int i) {
        return this.messageList.get(i);
    }

    public Map<Enum, Long> getKindAggregate(MessageType messageType) {
        HashMap<Enum, Long> aggMap = new HashMap<Enum, Long>();
        for (Message message : this) {
            long l;
            Enum kind;
            if (message.getMessageType() != messageType || (kind = message.getKind()) == null) continue;
            Long count = (Long)aggMap.get(kind);
            if (count == null) {
                l = 1L;
            } else {
                count = count + 1L;
                l = count;
            }
            count = l;
            aggMap.put(kind, count);
        }
        return aggMap;
    }

    public static void logAggregate(Map<Enum, Long> aggMap, MessageType messageType, Log log) {
        long nullCounterCount;
        long l = nullCounterCount = aggMap.get((Object)PigWarning.NULL_COUNTER_COUNT) == null ? 0L : aggMap.get((Object)PigWarning.NULL_COUNTER_COUNT);
        if (nullCounterCount != 0L && aggMap.size() > 1) {
            CompilationMessageCollector.logMessage("Unable to retrieve hadoop counter for " + nullCounterCount + " jobs, the number following warnings may not be correct", messageType, log);
        }
        for (Map.Entry<Enum, Long> e : aggMap.entrySet()) {
            Long count;
            if (e.getKey() == PigWarning.NULL_COUNTER_COUNT || (count = e.getValue()) == null || count <= 0L) continue;
            String message = "Encountered " + (Object)((Object)messageType) + " " + e.getKey().toString() + " " + count + " time(s).";
            CompilationMessageCollector.logMessage(message, messageType, log);
        }
    }

    public static void logMessages(CompilationMessageCollector messageCollector, MessageType messageType, boolean aggregate, Log log) {
        if (aggregate) {
            Map<Enum, Long> aggMap = messageCollector.getKindAggregate(messageType);
            CompilationMessageCollector.logAggregate(aggMap, messageType, log);
        } else {
            for (Message message : messageCollector) {
                if (message.getMessageType() != messageType) continue;
                CompilationMessageCollector.logMessage(message.getMessage(), messageType, log);
            }
        }
    }

    public void logMessages(MessageType messageType, boolean aggregate, Log log) {
        CompilationMessageCollector.logMessages(this, messageType, aggregate, log);
    }

    public static void logAllMessages(CompilationMessageCollector messageCollector, Log log) {
        for (Message message : messageCollector) {
            CompilationMessageCollector.logMessage(message.getMessage(), message.getMessageType(), log);
        }
    }

    public void logAllMessages(Log log) {
        CompilationMessageCollector.logAllMessages(this, log);
    }

    private static void logMessage(String messageString, MessageType messageType, Log log) {
        switch (messageType) {
            case Info: {
                log.info((Object)messageString);
                break;
            }
            case Warning: {
                log.warn((Object)messageString);
                break;
            }
            case Error: {
                log.error((Object)messageString);
            }
        }
    }

    public static class Message {
        private String msg = null;
        private MessageType msgType = MessageType.Unknown;
        private Enum kind = null;

        public Message(String message, MessageType messageType) {
            this.msg = message;
            this.msgType = messageType;
        }

        public Message(String message, MessageType messageType, Enum kind) {
            this(message, messageType);
            this.kind = kind;
        }

        public String getMessage() {
            return this.msg;
        }

        public MessageType getMessageType() {
            return this.msgType;
        }

        public Enum getKind() {
            return this.kind;
        }
    }

    public static enum Unknown {
        UNKNOWN_MESSAGE_KIND;


        public String toString() {
            return "Aggregated unknown kind messages.  Please set -Daggregate.warning=false to retrieve these messages";
        }
    }

    public static enum MessageType {
        Unknown,
        Error,
        Warning,
        Info;

    }
}

