/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage.memory;

import java.util.LinkedHashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfoManager;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.memory.BlockEvictionHandler;
import org.apache.spark.storage.memory.DeserializedMemoryEntry;
import org.apache.spark.storage.memory.DeserializedValuesHolder;
import org.apache.spark.storage.memory.MemoryEntry;
import org.apache.spark.storage.memory.MemoryEntryBuilder;
import org.apache.spark.storage.memory.PartiallySerializedBlock;
import org.apache.spark.storage.memory.PartiallyUnrolledIterator;
import org.apache.spark.storage.memory.SerializedMemoryEntry;
import org.apache.spark.storage.memory.SerializedValuesHolder;
import org.apache.spark.storage.memory.ValuesHolder;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t]e!B\u0001\u0003\u0001\u0019a!aC'f[>\u0014\u0018p\u0015;pe\u0016T!a\u0001\u0003\u0002\r5,Wn\u001c:z\u0015\t)a!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011AcF\u0007\u0002+)\u0011aCB\u0001\tS:$XM\u001d8bY&\u0011\u0001$\u0006\u0002\b\u0019><w-\u001b8h\u0011!Q\u0002A!A!\u0002\u0013a\u0012\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002\u001e=5\ta!\u0003\u0002 \r\tI1\u000b]1sW\u000e{gN\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005\u0001\"\r\\8dW&sgm\\'b]\u0006<WM\u001d\t\u0003G\u0011j\u0011\u0001B\u0005\u0003K\u0011\u0011\u0001C\u00117pG.LeNZ8NC:\fw-\u001a:\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\n\u0011c]3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s!\tIC&D\u0001+\u0015\tYc!\u0001\u0006tKJL\u0017\r\\5{KJL!!\f\u0016\u0003#M+'/[1mSj,'/T1oC\u001e,'\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00035iW-\\8ss6\u000bg.Y4feB\u0011\u0011gM\u0007\u0002e)\u00111AB\u0005\u0003iI\u0012Q\"T3n_JLX*\u00198bO\u0016\u0014\b\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002)\tdwnY6Fm&\u001cG/[8o\u0011\u0006tG\r\\3s!\tA\u0014(D\u0001\u0003\u0013\tQ$A\u0001\u000bCY>\u001c7.\u0012<jGRLwN\u001c%b]\u0012dWM\u001d\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\ryz\u0004)\u0011\"D!\tA\u0004\u0001C\u0003\u001bw\u0001\u0007A\u0004C\u0003\"w\u0001\u0007!\u0005C\u0003(w\u0001\u0007\u0001\u0006C\u00030w\u0001\u0007\u0001\u0007C\u00037w\u0001\u0007q\u0007C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u000f\u0015tGO]5fgV\tq\t\u0005\u0003I\u001b>\u0013V\"A%\u000b\u0005)[\u0015\u0001B;uS2T\u0011\u0001T\u0001\u0005U\u00064\u0018-\u0003\u0002O\u0013\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\"a\t)\n\u0005E#!a\u0002\"m_\u000e\\\u0017\n\u001a\u0019\u0003'b\u00032\u0001\u000f+W\u0013\t)&AA\u0006NK6|'/_#oiJL\bCA,Y\u0019\u0001!\u0011\"\u0017.\u0002\u0002\u0003\u0005)\u0011\u0001/\u0003\u0007}#\u0013\u0007\u0003\u0004\\\u0001\u0001\u0006IaR\u0001\tK:$(/[3tAE\u0011Q\f\u0019\t\u0003\u001dyK!aX\b\u0003\u000f9{G\u000f[5oOB\u0011a\"Y\u0005\u0003E>\u00111!\u00118z\u0011\u001d!\u0007A1A\u0005\n\u0015\fQc\u001c8IK\u0006\u0004XK\u001c:pY2lU-\\8ss6\u000b\u0007/F\u0001g!\u00119GN\u001c8\u000e\u0003!T!!\u001b6\u0002\u000f5,H/\u00192mK*\u00111nD\u0001\u000bG>dG.Z2uS>t\u0017BA7i\u0005\u001dA\u0015m\u001d5NCB\u0004\"AD8\n\u0005A|!\u0001\u0002'p]\u001eDaA\u001d\u0001!\u0002\u00131\u0017AF8o\u0011\u0016\f\u0007/\u00168s_2dW*Z7pefl\u0015\r\u001d\u0011\t\u000fQ\u0004!\u0019!C\u0005K\u00061rN\u001a4IK\u0006\u0004XK\u001c:pY2lU-\\8ss6\u000b\u0007\u000f\u0003\u0004w\u0001\u0001\u0006IAZ\u0001\u0018_\u001a4\u0007*Z1q+:\u0014x\u000e\u001c7NK6|'/_'ba\u0002Bq\u0001\u001f\u0001C\u0002\u0013%\u00110A\u000bv]J|G\u000e\\'f[>\u0014\u0018\u0010\u00165sKNDw\u000e\u001c3\u0016\u00039Daa\u001f\u0001!\u0002\u0013q\u0017AF;oe>dG.T3n_JLH\u000b\u001b:fg\"|G\u000e\u001a\u0011\t\u000bu\u0004A\u0011B=\u0002\u00135\f\u00070T3n_JL\b\"B@\u0001\t\u0013I\u0018AC7f[>\u0014\u00180V:fI\"1\u00111\u0001\u0001\u0005\ne\f\u0001C\u00197pG.\u001cX*Z7pef,6/\u001a3\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u00059q-\u001a;TSj,Gc\u00018\u0002\f!9\u0011QBA\u0003\u0001\u0004y\u0015a\u00022m_\u000e\\\u0017\n\u001a\u0005\b\u0003#\u0001A\u0011AA\n\u0003!\u0001X\u000f\u001e\"zi\u0016\u001cX\u0003BA\u000b\u0003c!\"\"a\u0006\u00026\u0005]\u00121HA#)\u0011\tI\"a\b\u0011\u00079\tY\"C\u0002\u0002\u001e=\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002\"\u0005=\u0011\u0011!a\u0002\u0003G\t!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\t)#a\u000b\u000205\u0011\u0011q\u0005\u0006\u0004\u0003Sy\u0011a\u0002:fM2,7\r^\u0005\u0005\u0003[\t9C\u0001\u0005DY\u0006\u001c8\u000fV1h!\r9\u0016\u0011\u0007\u0003\b\u0003g\tyA1\u0001]\u0005\u0005!\u0006bBA\u0007\u0003\u001f\u0001\ra\u0014\u0005\b\u0003s\ty\u00011\u0001o\u0003\u0011\u0019\u0018N_3\t\u0011\u0005u\u0012q\u0002a\u0001\u0003\u007f\t!\"\\3n_JLXj\u001c3f!\r\t\u0014\u0011I\u0005\u0004\u0003\u0007\u0012$AC'f[>\u0014\u00180T8eK\"A\u0011qIA\b\u0001\u0004\tI%\u0001\u0004`Ef$Xm\u001d\t\u0006\u001d\u0005-\u0013qJ\u0005\u0004\u0003\u001bz!!\u0003$v]\u000e$\u0018n\u001c81!\u0011\t\t&!\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\n!![8\u000b\u0005)3\u0011\u0002BA.\u0003'\u0012\u0011c\u00115v].,GMQ=uK\n+hMZ3s\u0011\u001d\ty\u0006\u0001C\u0005\u0003C\n1\u0002];u\u0013R,'/\u0019;peV!\u00111MAF)1\t)'! \u0002\u0000\u00055\u00151SAK!\u0019\t9'a\u001eo]:!\u0011\u0011NA:\u001d\u0011\tY'!\u001d\u000e\u0005\u00055$bAA87\u00051AH]8pizJ\u0011\u0001E\u0005\u0004\u0003kz\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003s\nYH\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003kz\u0001bBA\u0007\u0003;\u0002\ra\u0014\u0005\t\u0003\u0003\u000bi\u00061\u0001\u0002\u0004\u00061a/\u00197vKN\u0004b!a\u001a\u0002\u0006\u0006%\u0015\u0002BAD\u0003w\u0012\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004/\u0006-EaBA\u001a\u0003;\u0012\r\u0001\u0018\u0005\t\u0003\u001f\u000bi\u00061\u0001\u0002\u0012\u0006A1\r\\1tgR\u000bw\r\u0005\u0004\u0002&\u0005-\u0012\u0011\u0012\u0005\t\u0003{\ti\u00061\u0001\u0002@!A\u0011qSA/\u0001\u0004\tI*\u0001\u0007wC2,Xm\u001d%pY\u0012,'\u000fE\u00039\u00037\u000bI)C\u0002\u0002\u001e\n\u0011ABV1mk\u0016\u001c\bj\u001c7eKJD\u0001\"!)\u0001\t\u0003!\u00111U\u0001\u0014aV$\u0018\n^3sCR|'/Q:WC2,Xm]\u000b\u0005\u0003K\u000b\t\f\u0006\u0005\u0002(\u0006M\u0016QWA]!\u001d\t9'a\u001e\u0002*:\u0004R\u0001OAV\u0003_K1!!,\u0003\u0005e\u0001\u0016M\u001d;jC2d\u00170\u00168s_2dW\rZ%uKJ\fGo\u001c:\u0011\u0007]\u000b\t\fB\u0004\u00024\u0005}%\u0019\u0001/\t\u000f\u00055\u0011q\u0014a\u0001\u001f\"A\u0011\u0011QAP\u0001\u0004\t9\f\u0005\u0004\u0002h\u0005\u0015\u0015q\u0016\u0005\t\u0003\u001f\u000by\n1\u0001\u0002<B1\u0011QEA\u0016\u0003_C\u0001\"a0\u0001\t\u0003!\u0011\u0011Y\u0001\u0013aV$\u0018\n^3sCR|'/Q:CsR,7/\u0006\u0003\u0002D\u0006=GCCAc\u0003#\f\u0019.a6\u0002\\B9\u0011qMA<\u0003\u000ft\u0007#\u0002\u001d\u0002J\u00065\u0017bAAf\u0005\tA\u0002+\u0019:uS\u0006dG._*fe&\fG.\u001b>fI\ncwnY6\u0011\u0007]\u000by\rB\u0004\u00024\u0005u&\u0019\u0001/\t\u000f\u00055\u0011Q\u0018a\u0001\u001f\"A\u0011\u0011QA_\u0001\u0004\t)\u000e\u0005\u0004\u0002h\u0005\u0015\u0015Q\u001a\u0005\t\u0003\u001f\u000bi\f1\u0001\u0002ZB1\u0011QEA\u0016\u0003\u001bD\u0001\"!\u0010\u0002>\u0002\u0007\u0011q\b\u0005\b\u0003?\u0004A\u0011AAq\u0003!9W\r\u001e\"zi\u0016\u001cH\u0003BAr\u0003S\u0004RADAs\u0003\u001fJ1!a:\u0010\u0005\u0019y\u0005\u000f^5p]\"9\u0011QBAo\u0001\u0004y\u0005bBAw\u0001\u0011\u0005\u0011q^\u0001\nO\u0016$h+\u00197vKN$B!!=\u0002~B)a\"!:\u0002tB\"\u0011Q_A}!\u0019\t9'!\"\u0002xB\u0019q+!?\u0005\u0017\u0005m\u00181^A\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0004?\u0012\u0012\u0004bBA\u0007\u0003W\u0004\ra\u0014\u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0003\u0019\u0011X-\\8wKR!\u0011\u0011\u0004B\u0003\u0011\u001d\ti!a@A\u0002=CqA!\u0003\u0001\t\u0003\u0011Y!A\u0003dY\u0016\f'\u000f\u0006\u0002\u0003\u000eA\u0019aBa\u0004\n\u0007\tEqB\u0001\u0003V]&$\bb\u0002B\u000b\u0001\u0011%!qC\u0001\tO\u0016$(\u000b\u001a3JIR!!\u0011\u0004B\u0011!\u0015q\u0011Q\u001dB\u000e!\rq!QD\u0005\u0004\u0005?y!aA%oi\"9\u0011Q\u0002B\n\u0001\u0004y\u0005\u0002\u0003B\u0013\u0001\u0011\u0005aAa\n\u0002-\u00154\u0018n\u0019;CY>\u001c7n\u001d+p\rJ,Wm\u00159bG\u0016$rA\u001cB\u0015\u0005[\u0011\t\u0004\u0003\u0005\u0002\u000e\t\r\u0002\u0019\u0001B\u0016!\u0011q\u0011Q](\t\u000f\t=\"1\u0005a\u0001]\u0006)1\u000f]1dK\"A\u0011Q\bB\u0012\u0001\u0004\ty\u0004C\u0004\u00036\u0001!\tBa\u000e\u0002\u001f\u00054G/\u001a:Ee>\u0004\u0018i\u0019;j_:$BA!\u0004\u0003:!9\u0011Q\u0002B\u001a\u0001\u0004y\u0005b\u0002B\u001f\u0001\u0011\u0005!qH\u0001\tG>tG/Y5ogR!\u0011\u0011\u0004B!\u0011\u001d\tiAa\u000fA\u0002=CqA!\u0012\u0001\t\u0013\u00119%\u0001\u000bdkJ\u0014XM\u001c;UCN\\\u0017\t\u001e;f[B$\u0018\n\u001a\u000b\u0002]\"9!1\n\u0001\u0005\u0002\t5\u0013A\b:fg\u0016\u0014h/Z+oe>dG.T3n_JLhi\u001c:UQ&\u001cH+Y:l)!\tIBa\u0014\u0003R\tM\u0003bBA\u0007\u0005\u0013\u0002\ra\u0014\u0005\u0007\u0007\t%\u0003\u0019\u00018\t\u0011\u0005u\"\u0011\na\u0001\u0003\u007fAqAa\u0016\u0001\t\u0003\u0011I&\u0001\u0010sK2,\u0017m]3V]J|G\u000e\\'f[>\u0014\u0018PR8s)\"L7\u000fV1tWR1!Q\u0002B.\u0005;B\u0001\"!\u0010\u0003V\u0001\u0007\u0011q\b\u0005\t\u0007\tU\u0003\u0013!a\u0001]\"1!\u0011\r\u0001\u0005\u0002e\f1cY;se\u0016tG/\u00168s_2dW*Z7pefDaA!\u001a\u0001\t\u0003I\u0018AH2veJ,g\u000e^+oe>dG.T3n_JLhi\u001c:UQ&\u001cH+Y:l\u0011\u001d\u0011I\u0007\u0001C\u0005\u0005W\n\u0011C\\;n)\u0006\u001c8n]+oe>dG.\u001b8h+\t\u0011Y\u0002C\u0004\u0003p\u0001!IAa\u0003\u0002\u001d1|w-T3n_JLXk]1hK\"9!1\u000f\u0001\u0005\n\tU\u0014a\u00067pOVs'o\u001c7m\r\u0006LG.\u001e:f\u001b\u0016\u001c8/Y4f)\u0019\u0011iAa\u001e\u0003z!9\u0011Q\u0002B9\u0001\u0004y\u0005b\u0002B>\u0005c\u0002\rA\\\u0001\u0010M&t\u0017\r\u001c,fGR|'oU5{K\"I!q\u0010\u0001\u0012\u0002\u0013\u0005!\u0011Q\u0001)e\u0016dW-Y:f+:\u0014x\u000e\u001c7NK6|'/\u001f$peRC\u0017n\u001d+bg.$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0007S3A\u001cBCW\t\u00119\t\u0005\u0003\u0003\n\nMUB\u0001BF\u0015\u0011\u0011iIa$\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BI\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU%1\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class MemoryStore
implements Logging {
    private final SparkConf conf;
    public final BlockInfoManager org$apache$spark$storage$memory$MemoryStore$$blockInfoManager;
    private final SerializerManager serializerManager;
    private final MemoryManager memoryManager;
    private final BlockEvictionHandler blockEvictionHandler;
    private final LinkedHashMap<BlockId, MemoryEntry<?>> org$apache$spark$storage$memory$MemoryStore$$entries;
    private final HashMap<Object, Object> onHeapUnrollMemoryMap;
    private final HashMap<Object, Object> offHeapUnrollMemoryMap;
    private final long org$apache$spark$storage$memory$MemoryStore$$unrollMemoryThreshold;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public LinkedHashMap<BlockId, MemoryEntry<?>> org$apache$spark$storage$memory$MemoryStore$$entries() {
        return this.org$apache$spark$storage$memory$MemoryStore$$entries;
    }

    private HashMap<Object, Object> onHeapUnrollMemoryMap() {
        return this.onHeapUnrollMemoryMap;
    }

    private HashMap<Object, Object> offHeapUnrollMemoryMap() {
        return this.offHeapUnrollMemoryMap;
    }

    public long org$apache$spark$storage$memory$MemoryStore$$unrollMemoryThreshold() {
        return this.org$apache$spark$storage$memory$MemoryStore$$unrollMemoryThreshold;
    }

    public long org$apache$spark$storage$memory$MemoryStore$$maxMemory() {
        return this.memoryManager.maxOnHeapStorageMemory() + this.memoryManager.maxOffHeapStorageMemory();
    }

    public long org$apache$spark$storage$memory$MemoryStore$$memoryUsed() {
        return this.memoryManager.storageMemoryUsed();
    }

    public long org$apache$spark$storage$memory$MemoryStore$$blocksMemoryUsed() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Long l = BoxesRunTime.boxToLong((long)(this.org$apache$spark$storage$memory$MemoryStore$$memoryUsed() - this.currentUnrollMemory()));
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    public long getSize(BlockId blockId) {
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.org$apache$spark$storage$memory$MemoryStore$$entries();
        synchronized (linkedHashMap) {
            Long l = BoxesRunTime.boxToLong((long)this.org$apache$spark$storage$memory$MemoryStore$$entries().get(blockId).size());
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> boolean putBytes(BlockId blockId, long size, MemoryMode memoryMode, Function0<ChunkedByteBuffer> _bytes, ClassTag<T> evidence$2) {
        Predef$.MODULE$.require(!this.contains(blockId), (Function0)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block ", " is already present in the MemoryStore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
        if (!this.memoryManager.acquireStorageMemory(blockId, size, memoryMode)) return false;
        ChunkedByteBuffer bytes = (ChunkedByteBuffer)_bytes.apply();
        Predef$.MODULE$.assert(bytes.size() == size);
        SerializedMemoryEntry entry = new SerializedMemoryEntry(bytes, memoryMode, (ClassTag)Predef$.MODULE$.implicitly(evidence$2));
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.org$apache$spark$storage$memory$MemoryStore$$entries();
        synchronized (linkedHashMap) {
            this.org$apache$spark$storage$memory$MemoryStore$$entries().put(blockId, entry);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : linkedHashMap
            this.logInfo((Function0<String>)new Serializable(this, blockId, size){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemoryStore $outer;
                private final BlockId blockId$1;
                private final long size$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Block %s stored as bytes in memory (estimated size %s, free %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, Utils$.MODULE$.bytesToString(this.size$1), Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$memory$MemoryStore$$maxMemory() - this.$outer.org$apache$spark$storage$memory$MemoryStore$$blocksMemoryUsed())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.blockId$1 = blockId$1;
                    this.size$1 = size$1;
                }
            });
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private <T> Either<Object, Object> putIterator(BlockId blockId, Iterator<T> values2, ClassTag<T> classTag, MemoryMode memoryMode, ValuesHolder<T> valuesHolder) {
        long amountToRequest;
        Left left;
        Predef$.MODULE$.require(!this.contains(blockId), (Function0)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block ", " is already present in the MemoryStore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4}));
            }
            {
                this.blockId$4 = blockId$4;
            }
        });
        int elementsUnrolled = 0;
        boolean keepUnrolling = true;
        long initialMemoryThreshold = this.org$apache$spark$storage$memory$MemoryStore$$unrollMemoryThreshold();
        long memoryCheckPeriod = BoxesRunTime.unboxToLong((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.UNROLL_MEMORY_CHECK_PERIOD()));
        long memoryThreshold = initialMemoryThreshold;
        double memoryGrowthFactor = BoxesRunTime.unboxToDouble((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.UNROLL_MEMORY_GROWTH_FACTOR()));
        long unrollMemoryUsedByThisBlock = 0L;
        keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, initialMemoryThreshold, memoryMode);
        if (keepUnrolling) {
            unrollMemoryUsedByThisBlock += initialMemoryThreshold;
        } else {
            this.logWarning((Function0<String>)new Serializable(this, blockId, initialMemoryThreshold){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$4;
                private final long initialMemoryThreshold$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to reserve initial memory threshold of "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for computing block ", " in memory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.initialMemoryThreshold$1), this.blockId$4}))).toString();
                }
                {
                    this.blockId$4 = blockId$4;
                    this.initialMemoryThreshold$1 = initialMemoryThreshold$1;
                }
            });
        }
        while (values2.hasNext() && keepUnrolling) {
            long currentSize;
            valuesHolder.storeValue(values2.next());
            if ((long)elementsUnrolled % memoryCheckPeriod == 0L && (currentSize = valuesHolder.estimatedSize()) >= memoryThreshold) {
                long amountToRequest2 = (long)((double)currentSize * memoryGrowthFactor - (double)memoryThreshold);
                keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, amountToRequest2, memoryMode);
                if (keepUnrolling) {
                    unrollMemoryUsedByThisBlock += amountToRequest2;
                }
                memoryThreshold += amountToRequest2;
            }
            ++elementsUnrolled;
        }
        if (!keepUnrolling) {
            this.logUnrollFailureMessage(blockId, valuesHolder.estimatedSize());
            left = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToLong((long)unrollMemoryUsedByThisBlock));
            return left;
        }
        MemoryEntryBuilder<Object> entryBuilder = valuesHolder.getBuilder();
        long size = entryBuilder.preciseSize();
        if (size > unrollMemoryUsedByThisBlock && (keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, amountToRequest = size - unrollMemoryUsedByThisBlock, memoryMode))) {
            unrollMemoryUsedByThisBlock += amountToRequest;
        }
        if (!keepUnrolling) {
            this.logUnrollFailureMessage(blockId, entryBuilder.preciseSize());
            left = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToLong((long)unrollMemoryUsedByThisBlock));
            return left;
        }
        MemoryEntry<Object> entry = entryBuilder.build();
        MemoryManager memoryManager = this.memoryManager;
        // MONITORENTER : memoryManager
        this.releaseUnrollMemoryForThisTask(memoryMode, unrollMemoryUsedByThisBlock);
        boolean success = this.memoryManager.acquireStorageMemory(blockId, entry.size(), memoryMode);
        Predef$.MODULE$.assert(success, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "transferring unroll memory to storage memory failed";
            }
        });
        // MONITOREXIT : memoryManager
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.org$apache$spark$storage$memory$MemoryStore$$entries();
        this.org$apache$spark$storage$memory$MemoryStore$$entries().put(blockId, entry);
        // MONITOREXIT : linkedHashMap
        this.logInfo((Function0<String>)new Serializable(this, blockId, entry){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryStore $outer;
            private final BlockId blockId$4;
            private final MemoryEntry entry$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Block %s stored as values in memory (estimated size %s, free %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, Utils$.MODULE$.bytesToString(this.entry$1.size()), Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$memory$MemoryStore$$maxMemory() - this.$outer.org$apache$spark$storage$memory$MemoryStore$$blocksMemoryUsed())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$4 = blockId$4;
                this.entry$1 = entry$1;
            }
        });
        left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)entry.size()));
        return left;
    }

    public <T> Either<PartiallyUnrolledIterator<T>, Object> putIteratorAsValues(BlockId blockId, Iterator<T> values2, ClassTag<T> classTag) {
        Either<Object, Object> either;
        block4: {
            Right right;
            block3: {
                DeserializedValuesHolder<T> valuesHolder;
                block2: {
                    valuesHolder = new DeserializedValuesHolder<T>(classTag);
                    either = this.putIterator(blockId, values2, classTag, MemoryMode.ON_HEAP, valuesHolder);
                    if (!(either instanceof Right)) break block2;
                    Right right2 = (Right)either;
                    long storedSize = BoxesRunTime.unboxToLong((Object)right2.b());
                    right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)storedSize));
                    break block3;
                }
                if (!(either instanceof Left)) break block4;
                Left left = (Left)either;
                long unrollMemoryUsedByThisBlock = BoxesRunTime.unboxToLong((Object)left.a());
                Iterator unrolledIterator = valuesHolder.vector() == null ? Predef$.MODULE$.genericArrayOps(valuesHolder.arrayValues()).toIterator() : valuesHolder.vector().iterator();
                right = package$.MODULE$.Left().apply(new PartiallyUnrolledIterator<T>(this, MemoryMode.ON_HEAP, unrollMemoryUsedByThisBlock, unrolledIterator, values2));
            }
            return right;
        }
        throw new MatchError(either);
    }

    public <T> Either<PartiallySerializedBlock<T>, Object> putIteratorAsBytes(BlockId blockId, Iterator<T> values2, ClassTag<T> classTag, MemoryMode memoryMode) {
        Either<Object, Object> either;
        block7: {
            Right right;
            block6: {
                SerializedValuesHolder<T> valuesHolder;
                block5: {
                    int n;
                    Predef$.MODULE$.require(!this.contains(blockId), (Function0)new Serializable(this, blockId){
                        public static final long serialVersionUID = 0L;
                        private final BlockId blockId$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block ", " is already present in the MemoryStore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$2}));
                        }
                        {
                            this.blockId$2 = blockId$2;
                        }
                    });
                    long initialMemoryThreshold = this.org$apache$spark$storage$memory$MemoryStore$$unrollMemoryThreshold();
                    if (initialMemoryThreshold > (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
                        this.logWarning((Function0<String>)new Serializable(this, initialMemoryThreshold){
                            public static final long serialVersionUID = 0L;
                            private final long initialMemoryThreshold$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial memory threshold of ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.initialMemoryThreshold$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is too large to be set as chunk size. Chunk size has been capped to "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH)}))).toString();
                            }
                            {
                                this.initialMemoryThreshold$2 = initialMemoryThreshold$2;
                            }
                        });
                        n = ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH;
                    } else {
                        n = (int)initialMemoryThreshold;
                    }
                    int chunkSize = n;
                    valuesHolder = new SerializedValuesHolder<T>(blockId, chunkSize, classTag, memoryMode, this.serializerManager);
                    either = this.putIterator(blockId, values2, classTag, memoryMode, valuesHolder);
                    if (!(either instanceof Right)) break block5;
                    Right right2 = (Right)either;
                    long storedSize = BoxesRunTime.unboxToLong((Object)right2.b());
                    right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)storedSize));
                    break block6;
                }
                if (!(either instanceof Left)) break block7;
                Left left = (Left)either;
                long unrollMemoryUsedByThisBlock = BoxesRunTime.unboxToLong((Object)left.a());
                right = package$.MODULE$.Left().apply(new PartiallySerializedBlock<T>(this, this.serializerManager, blockId, valuesHolder.serializationStream(), valuesHolder.redirectableStream(), unrollMemoryUsedByThisBlock, memoryMode, valuesHolder.bbos(), values2, classTag));
            }
            return right;
        }
        throw new MatchError(either);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<ChunkedByteBuffer> getBytes(BlockId blockId) {
        MemoryEntry<?> memoryEntry;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.org$apache$spark$storage$memory$MemoryStore$$entries();
        synchronized (linkedHashMap) {
            MemoryEntry<?> entry;
            MemoryEntry<?> memoryEntry2 = this.org$apache$spark$storage$memory$MemoryStore$$entries().get(blockId);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : linkedHashMap
            memoryEntry = entry = memoryEntry2;
            if (memoryEntry == null) {
                return None$.MODULE$;
            }
        }
        if (memoryEntry instanceof DeserializedMemoryEntry) {
            throw new IllegalArgumentException("should only call getBytes on serialized blocks");
        }
        if (!(memoryEntry instanceof SerializedMemoryEntry)) throw new MatchError(memoryEntry);
        SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry;
        ChunkedByteBuffer bytes = serializedMemoryEntry.buffer();
        return new Some((Object)bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<Iterator<?>> getValues(BlockId blockId) {
        MemoryEntry<?> memoryEntry;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.org$apache$spark$storage$memory$MemoryStore$$entries();
        synchronized (linkedHashMap) {
            MemoryEntry<?> entry;
            MemoryEntry<?> memoryEntry2 = this.org$apache$spark$storage$memory$MemoryStore$$entries().get(blockId);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : linkedHashMap
            memoryEntry = entry = memoryEntry2;
            if (memoryEntry == null) {
                return None$.MODULE$;
            }
        }
        if (memoryEntry instanceof SerializedMemoryEntry) {
            throw new IllegalArgumentException("should only call getValues on deserialized blocks");
        }
        if (!(memoryEntry instanceof DeserializedMemoryEntry)) throw new MatchError(memoryEntry);
        DeserializedMemoryEntry deserializedMemoryEntry = (DeserializedMemoryEntry)memoryEntry;
        Object values2 = deserializedMemoryEntry.value();
        Some x = new Some(values2);
        return x.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterator<Object> apply(Object x$1) {
                return Predef$.MODULE$.genericArrayOps(x$1).iterator();
            }
        });
    }

    /*
     * Exception decompiling
     */
    public boolean remove(BlockId blockId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public void clear() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.org$apache$spark$storage$memory$MemoryStore$$entries();
            synchronized (linkedHashMap) {
                this.org$apache$spark$storage$memory$MemoryStore$$entries().clear();
            }
            this.onHeapUnrollMemoryMap().clear();
            this.offHeapUnrollMemoryMap().clear();
            this.memoryManager.releaseAllStorageMemory();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "MemoryStore cleared";
                }
            });
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public Option<Object> org$apache$spark$storage$memory$MemoryStore$$getRddId(BlockId blockId) {
        return blockId.asRDDId().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(RDDBlockId x$2) {
                return x$2.rddId();
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long evictBlocksToFreeSpace(Option<BlockId> blockId, long space, MemoryMode memoryMode) {
        Predef$.MODULE$.assert(space > 0L);
        var5_4 = this.memoryManager;
        synchronized (var5_4) {
            freedMemory = LongRef.create((long)0L);
            rddToAdd = blockId.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemoryStore $outer;

                public final Option<Object> apply(BlockId blockId) {
                    return this.$outer.org$apache$spark$storage$memory$MemoryStore$$getRddId(blockId);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            selectedBlocks = new ArrayBuffer();
            var10_8 = this.org$apache$spark$storage$memory$MemoryStore$$entries();
            synchronized (var10_8) {
                iterator = this.org$apache$spark$storage$memory$MemoryStore$$entries().entrySet().iterator();
                while (freedMemory.elem < space && iterator.hasNext()) {
                    pair = iterator.next();
                    blockId = pair.getKey();
                    if (!this.blockIsEvictable$1(blockId, entry = pair.getValue(), memoryMode, rddToAdd) || !this.org$apache$spark$storage$memory$MemoryStore$$blockInfoManager.lockForWriting(blockId, false).isDefined()) continue;
                    selectedBlocks.$plus$eq((Object)blockId);
                    freedMemory.elem += pair.getValue().size();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 5] lbl20 : MonitorExitStatement: MONITOREXIT : var10_8
                if (freedMemory.elem < space) ** GOTO lbl39
                ** GOTO lbl25
            }
            {
                catch (Throwable v0) {
                    throw v0;
                }
lbl25:
                // 1 sources

                lastSuccessfulBlock = IntRef.create((int)-1);
                this.logInfo((Function0<String>)new Serializable(this, freedMemory, selectedBlocks){
                    public static final long serialVersionUID = 0L;
                    private final LongRef freedMemory$1;
                    private final ArrayBuffer selectedBlocks$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " blocks selected for dropping "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.selectedBlocks$1.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " bytes)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.freedMemory$1.elem)}))).toString();
                    }
                    {
                        this.freedMemory$1 = freedMemory$1;
                        this.selectedBlocks$1 = selectedBlocks$1;
                    }
                });
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), selectedBlocks.size()).foreach$mVc$sp((Function1)new Serializable(this, selectedBlocks, lastSuccessfulBlock){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MemoryStore $outer;
                    private final ArrayBuffer selectedBlocks$1;
                    private final IntRef lastSuccessfulBlock$1;

                    public final void apply(int idx) {
                        this.apply$mcVI$sp(idx);
                    }

                    public void apply$mcVI$sp(int idx) {
                        BlockId blockId = (BlockId)this.selectedBlocks$1.apply(idx);
                        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.$outer.org$apache$spark$storage$memory$MemoryStore$$entries();
                        synchronized (linkedHashMap) {
                            MemoryEntry<?> memoryEntry = this.$outer.org$apache$spark$storage$memory$MemoryStore$$entries().get(blockId);
                            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var4_3
                            MemoryEntry<?> entry = memoryEntry;
                            if (entry != null) {
                                this.$outer.org$apache$spark$storage$memory$MemoryStore$$dropBlock$1(blockId, entry);
                                this.$outer.afterDropAction(blockId);
                            }
                            this.lastSuccessfulBlock$1.elem = idx;
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.selectedBlocks$1 = selectedBlocks$1;
                        this.lastSuccessfulBlock$1 = lastSuccessfulBlock$1;
                    }
                });
                this.logInfo((Function0<String>)new Serializable(this, selectedBlocks){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MemoryStore $outer;
                    private final ArrayBuffer selectedBlocks$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"After dropping ", " blocks, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.selectedBlocks$1.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"free memory is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$memory$MemoryStore$$maxMemory() - this.$outer.org$apache$spark$storage$memory$MemoryStore$$blocksMemoryUsed())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.selectedBlocks$1 = selectedBlocks$1;
                    }
                });
                v1 = BoxesRunTime.boxToLong((long)freedMemory.elem);
                {
                    block12: {
                        catch (Throwable var16_15) {
                            if (lastSuccessfulBlock.elem != selectedBlocks.size() - 1) {
                                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(lastSuccessfulBlock.elem + 1), selectedBlocks.size()).foreach$mVc$sp((Function1)new Serializable(this, selectedBlocks){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MemoryStore $outer;
                                    private final ArrayBuffer selectedBlocks$1;

                                    public final void apply(int idx) {
                                        this.apply$mcVI$sp(idx);
                                    }

                                    public void apply$mcVI$sp(int idx) {
                                        BlockId blockId = (BlockId)this.selectedBlocks$1.apply(idx);
                                        this.$outer.org$apache$spark$storage$memory$MemoryStore$$blockInfoManager.unlock(blockId, this.$outer.org$apache$spark$storage$memory$MemoryStore$$blockInfoManager.unlock$default$2());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.selectedBlocks$1 = selectedBlocks$1;
                                    }
                                });
                            }
                            throw var16_15;
                        }
                        if (lastSuccessfulBlock.elem != selectedBlocks.size() - 1) {
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(lastSuccessfulBlock.elem + 1), selectedBlocks.size()).foreach$mVc$sp((Function1)new /* invalid duplicate definition of identical inner class */);
                        }
                        break block12;
lbl39:
                        // 1 sources

                        blockId.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MemoryStore $outer;

                            public final void apply(BlockId id) {
                                this.$outer.logInfo((Function0<String>)new Serializable(this, id){
                                    public static final long serialVersionUID = 0L;
                                    private final BlockId id$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1}));
                                    }
                                    {
                                        this.id$1 = id$1;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        selectedBlocks.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MemoryStore $outer;

                            public final void apply(BlockId id) {
                                this.$outer.org$apache$spark$storage$memory$MemoryStore$$blockInfoManager.unlock(id, this.$outer.org$apache$spark$storage$memory$MemoryStore$$blockInfoManager.unlock$default$2());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        v1 = BoxesRunTime.boxToLong((long)0L);
                    }
                    var6_14 = v1;
                    return BoxesRunTime.unboxToLong((Object)var6_14);
                    {
                        catch (Throwable v2) {}
                        throw v2;
                    }
                }
            }
        }
    }

    public void afterDropAction(BlockId blockId) {
    }

    public boolean contains(BlockId blockId) {
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.org$apache$spark$storage$memory$MemoryStore$$entries();
        synchronized (linkedHashMap) {
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$storage$memory$MemoryStore$$entries().containsKey(blockId));
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskContext x$3) {
                return x$3.taskAttemptId();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
    }

    public boolean reserveUnrollMemoryForThisTask(BlockId blockId, long memory, MemoryMode memoryMode) {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            boolean success = this.memoryManager.acquireUnrollMemory(blockId, memory, memoryMode);
            if (success) {
                HashMap<Object, Object> hashMap;
                long taskAttemptId = this.currentTaskAttemptId();
                MemoryMode memoryMode2 = memoryMode;
                if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
                    hashMap = this.onHeapUnrollMemoryMap();
                } else {
                    if (!((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
                        throw new MatchError((Object)memoryMode2);
                    }
                    hashMap = this.offHeapUnrollMemoryMap();
                }
                HashMap<Object, Object> unrollMemoryMap = hashMap;
                unrollMemoryMap.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)unrollMemoryMap.getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) + memory)));
            }
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)success);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void releaseUnrollMemoryForThisTask(MemoryMode memoryMode, long memory) {
        long taskAttemptId = this.currentTaskAttemptId();
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            MemoryMode memoryMode2;
            block11: {
                Object object;
                HashMap<Object, Object> hashMap;
                block10: {
                    block9: {
                        memoryMode2 = memoryMode;
                        if (!((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) break block9;
                        hashMap = this.onHeapUnrollMemoryMap();
                        break block10;
                    }
                    if (!((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) break block11;
                    hashMap = this.offHeapUnrollMemoryMap();
                }
                HashMap<Object, Object> unrollMemoryMap = hashMap;
                if (unrollMemoryMap.contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                    long memoryToRelease = scala.math.package$.MODULE$.min(memory, BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))));
                    if (memoryToRelease > 0L) {
                        unrollMemoryMap.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) - memoryToRelease)));
                        this.memoryManager.releaseUnrollMemory(memoryToRelease, memoryMode);
                    }
                    object = BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) == 0L ? unrollMemoryMap.remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)) : BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)memoryMode2);
        }
    }

    public long releaseUnrollMemoryForThisTask$default$2() {
        return Long.MAX_VALUE;
    }

    public long currentUnrollMemory() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Long l = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.onHeapUnrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + BoxesRunTime.unboxToLong((Object)this.offHeapUnrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    public long currentUnrollMemoryForThisTask() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Long l = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.onHeapUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            })) + BoxesRunTime.unboxToLong((Object)this.offHeapUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }))));
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    public int org$apache$spark$storage$memory$MemoryStore$$numTasksUnrolling() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Integer n = BoxesRunTime.boxToInteger((int)((TraversableOnce)this.onHeapUnrollMemoryMap().keys().$plus$plus((GenTraversableOnce)this.offHeapUnrollMemoryMap().keys(), Iterable$.MODULE$.canBuildFrom())).toSet().size());
            return BoxesRunTime.unboxToInt((Object)n);
        }
    }

    private void logMemoryUsage() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryStore $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Memory use = ", " (blocks) + "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$memory$MemoryStore$$blocksMemoryUsed())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (scratch space shared across "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.currentUnrollMemory())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " tasks(s)) = ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$storage$memory$MemoryStore$$numTasksUnrolling()), Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$memory$MemoryStore$$memoryUsed())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Storage limit = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$memory$MemoryStore$$maxMemory())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void logUnrollFailureMessage(BlockId blockId, long finalVectorSize) {
        this.logWarning((Function0<String>)new Serializable(this, blockId, finalVectorSize){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$5;
            private final long finalVectorSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not enough space to cache ", " in memory! "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$5}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(computed ", " so far)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.finalVectorSize$1)}))).toString();
            }
            {
                this.blockId$5 = blockId$5;
                this.finalVectorSize$1 = finalVectorSize$1;
            }
        });
        this.logMemoryUsage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean blockIsEvictable$1(BlockId blockId, MemoryEntry entry, MemoryMode memoryMode$1, Option rddToAdd$1) {
        MemoryMode memoryMode = entry.memoryMode();
        MemoryMode memoryMode2 = memoryMode$1;
        if (memoryMode == null) {
            if (memoryMode2 != null) {
                return false;
            }
        } else if (!((Object)((Object)memoryMode)).equals((Object)memoryMode2)) return false;
        if (rddToAdd$1.isEmpty()) return true;
        Option option = rddToAdd$1;
        Option<Object> option2 = this.org$apache$spark$storage$memory$MemoryStore$$getRddId(blockId);
        if (option == null) {
            if (option2 == null) return false;
            return true;
        } else if (option.equals(option2)) return false;
        return true;
    }

    public final void org$apache$spark$storage$memory$MemoryStore$$dropBlock$1(BlockId blockId, MemoryEntry entry) {
        MemoryEntry memoryEntry;
        block7: {
            Left left;
            block6: {
                block5: {
                    memoryEntry = entry;
                    if (!(memoryEntry instanceof DeserializedMemoryEntry)) break block5;
                    DeserializedMemoryEntry deserializedMemoryEntry = (DeserializedMemoryEntry)memoryEntry;
                    Object values2 = deserializedMemoryEntry.value();
                    left = package$.MODULE$.Left().apply(values2);
                    break block6;
                }
                if (!(memoryEntry instanceof SerializedMemoryEntry)) break block7;
                SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry;
                ChunkedByteBuffer buffer = serializedMemoryEntry.buffer();
                left = package$.MODULE$.Right().apply((Object)buffer);
            }
            Left data = left;
            StorageLevel newEffectiveStorageLevel = this.blockEvictionHandler.dropFromMemory(blockId, (Function0<Either<Object, ChunkedByteBuffer>>)new Serializable(this, (Either)data){
                public static final long serialVersionUID = 0L;
                private final Either data$1;

                public final Product apply() {
                    return this.data$1;
                }
                {
                    this.data$1 = data$1;
                }
            }, entry.classTag());
            if (newEffectiveStorageLevel.isValid()) {
                this.org$apache$spark$storage$memory$MemoryStore$$blockInfoManager.unlock(blockId, this.org$apache$spark$storage$memory$MemoryStore$$blockInfoManager.unlock$default$2());
            } else {
                this.org$apache$spark$storage$memory$MemoryStore$$blockInfoManager.removeBlock(blockId);
            }
            return;
        }
        throw new MatchError((Object)memoryEntry);
    }

    public MemoryStore(SparkConf conf, BlockInfoManager blockInfoManager, SerializerManager serializerManager, MemoryManager memoryManager, BlockEvictionHandler blockEvictionHandler) {
        this.conf = conf;
        this.org$apache$spark$storage$memory$MemoryStore$$blockInfoManager = blockInfoManager;
        this.serializerManager = serializerManager;
        this.memoryManager = memoryManager;
        this.blockEvictionHandler = blockEvictionHandler;
        Logging$class.$init$(this);
        this.org$apache$spark$storage$memory$MemoryStore$$entries = new LinkedHashMap(32, 0.75f, true);
        this.onHeapUnrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.offHeapUnrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.org$apache$spark$storage$memory$MemoryStore$$unrollMemoryThreshold = conf.getLong("spark.storage.unrollMemoryThreshold", 0x100000L);
        if (this.org$apache$spark$storage$memory$MemoryStore$$maxMemory() < this.org$apache$spark$storage$memory$MemoryStore$$unrollMemoryThreshold()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemoryStore $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max memory ", " is less than the initial memory "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$memory$MemoryStore$$maxMemory())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"threshold ", " needed to store a block in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$memory$MemoryStore$$unrollMemoryThreshold())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory. Please configure Spark with more memory."})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryStore $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("MemoryStore started with capacity %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$memory$MemoryStore$$maxMemory())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

