/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.plan;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.DotPOPrinter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.DotPlanDumper;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanVisitor;

public class DotSparkPrinter
extends DotPlanDumper<SparkOperator, SparkOperPlan, InnerOperator, InnerPlan> {
    private static int counter = 0;
    private boolean isVerboseNesting = true;

    public DotSparkPrinter(SparkOperPlan plan, PrintStream ps) {
        this(plan, ps, false, (Set<Operator>)new HashSet<Operator>(), (Set<Operator>)new HashSet<Operator>(), (Set<Operator>)new HashSet<Operator>());
    }

    private DotSparkPrinter(SparkOperPlan plan, PrintStream ps, boolean isSubGraph, Set<Operator> subgraphs, Set<Operator> multiInputSubgraphs, Set<Operator> multiOutputSubgraphs) {
        super(plan, ps, isSubGraph, subgraphs, multiInputSubgraphs, multiOutputSubgraphs);
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.isVerboseNesting = verbose;
    }

    protected DotPlanDumper makeDumper(InnerPlan plan, PrintStream ps) {
        return new InnerPrinter(plan, ps, (Set<Operator>)this.mSubgraphs, (Set<Operator>)this.mMultiInputSubgraphs, (Set<Operator>)this.mMultiOutputSubgraphs);
    }

    @Override
    protected String getName(SparkOperator op) {
        String name = op.name();
        String delimiter = " - ";
        String[] temp = name.split(delimiter);
        return temp[0];
    }

    @Override
    protected Collection<InnerPlan> getNestedPlans(SparkOperator op) {
        LinkedList<InnerPlan> plans = new LinkedList<InnerPlan>();
        plans.add(new InnerPlan(op.physicalPlan));
        return plans;
    }

    @Override
    protected String[] getAttributes(SparkOperator op) {
        String[] attributes = new String[]{"label=\"" + this.getName(op) + "\"", "style=\"filled\"", "fillcolor=\"#EEEEEE\""};
        return attributes;
    }

    private class InnerPrinter
    extends DotPlanDumper<InnerOperator, InnerPlan, PhysicalOperator, PhysicalPlan> {
        public InnerPrinter(InnerPlan plan, PrintStream ps, Set<Operator> subgraphs, Set<Operator> multiInputSubgraphs, Set<Operator> multiOutputSubgraphs) {
            super(plan, ps, true, subgraphs, multiInputSubgraphs, multiOutputSubgraphs);
        }

        @Override
        protected String[] getAttributes(InnerOperator op) {
            String[] attributes = new String[]{"label=\"" + super.getName(op) + "\"", "style=\"filled\"", "fillcolor=\"white\""};
            return attributes;
        }

        @Override
        protected Collection<PhysicalPlan> getNestedPlans(InnerOperator op) {
            LinkedList<PhysicalPlan> l = new LinkedList<PhysicalPlan>();
            l.add(op.getPlan());
            return l;
        }

        protected DotPOPrinter makeDumper(PhysicalPlan plan, PrintStream ps) {
            DotPOPrinter printer = new DotPOPrinter(plan, ps, true, (Set<Operator>)this.mSubgraphs, (Set<Operator>)this.mMultiInputSubgraphs, (Set<Operator>)this.mMultiOutputSubgraphs);
            printer.setVerbose(DotSparkPrinter.this.isVerboseNesting);
            return printer;
        }
    }

    public static class InnerPlan
    extends OperatorPlan<InnerOperator> {
        private static final long serialVersionUID = 1L;

        public InnerPlan(PhysicalPlan plan) {
            InnerOperator sparkInnerOp = new InnerOperator(plan, "spark");
            this.add(sparkInnerOp);
        }
    }

    public static class InnerOperator
    extends Operator<PlanVisitor> {
        private static final long serialVersionUID = 1L;
        String name;
        PhysicalPlan plan;
        int code;

        public InnerOperator(PhysicalPlan plan, String name) {
            super(new OperatorKey());
            this.name = name;
            this.plan = plan;
            this.code = counter++;
        }

        @Override
        public void visit(PlanVisitor v) {
        }

        @Override
        public boolean supportsMultipleInputs() {
            return false;
        }

        @Override
        public boolean supportsMultipleOutputs() {
            return false;
        }

        @Override
        public String name() {
            return this.name;
        }

        public PhysicalPlan getPlan() {
            return this.plan;
        }

        @Override
        public int hashCode() {
            return this.code;
        }
    }
}

