/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class SUBSTRING
extends EvalFunc<String> {
    @Override
    public String exec(Tuple input) throws IOException {
        if (input == null || input.size() < 3) {
            this.warn("invalid number of arguments to SUBSTRING", PigWarning.UDF_WARNING_1);
            return null;
        }
        try {
            String source = (String)input.get(0);
            Integer beginindex = (Integer)input.get(1);
            Integer endindex = (Integer)input.get(2);
            return source.substring(beginindex, Math.min(source.length(), endindex));
        }
        catch (NullPointerException npe) {
            this.warn(npe.toString(), PigWarning.UDF_WARNING_2);
            return null;
        }
        catch (StringIndexOutOfBoundsException npe) {
            this.warn(npe.toString(), PigWarning.UDF_WARNING_3);
            return null;
        }
        catch (ClassCastException e) {
            this.warn(e.toString(), PigWarning.UDF_WARNING_4);
            return null;
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 55));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 10));
        s.add(new Schema.FieldSchema(null, 10));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        return funcList;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

