/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.data.DefaultTuple;

public class TimestampedTuple
extends DefaultTuple {
    private static final long serialVersionUID = 2L;
    private static final Log log = LogFactory.getLog(TimestampedTuple.class);
    static String defaultDelimiter = "[,\t]";
    protected double timestamp = 0.0;
    protected boolean heartbeat = false;

    public double getTimeStamp() {
        return this.timestamp;
    }

    public void setTimeStamp(double t) {
        this.timestamp = t;
    }

    public boolean isHeartBeat() {
        return this.heartbeat;
    }

    public void setHeartBeat(boolean h) {
        this.heartbeat = h;
    }

    public TimestampedTuple(int numFields) {
        super(numFields);
    }

    public TimestampedTuple(String textLine, String delimiter, int timestampColumn, SimpleDateFormat dateFormat) {
        if (delimiter == null) {
            delimiter = defaultDelimiter;
        }
        String[] splitString = textLine.split(delimiter, -1);
        this.mFields = new ArrayList(splitString.length - 1);
        for (int i = 0; i < splitString.length; ++i) {
            if (i == timestampColumn) {
                try {
                    this.timestamp = (double)dateFormat.parse(splitString[i]).getTime() / 1000.0;
                }
                catch (ParseException e) {
                    log.error((Object)("Could not parse timestamp " + splitString[i]));
                }
                continue;
            }
            this.mFields.add(splitString[i]);
        }
    }
}

