/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import org.apache.hadoop.hive.thrift.DelegationTokenSecretManager;
import org.apache.hadoop.hive.thrift.client.TUGIAssumingTransport;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class HadoopThriftAuthBridge {
    private static final Log LOG = LogFactory.getLog(HadoopThriftAuthBridge.class);

    public Client createClient() {
        return new Client();
    }

    public Client createClientWithConf(String authMethod) {
        UserGroupInformation ugi;
        try {
            ugi = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get current login user: " + e, e);
        }
        if (this.loginUserHasCurrentAuthMethod(ugi, authMethod)) {
            LOG.debug((Object)("Not setting UGI conf as passed-in authMethod of " + authMethod + " = current."));
            return new Client();
        }
        LOG.debug((Object)("Setting UGI conf as passed-in authMethod of " + authMethod + " != current."));
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authMethod);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return new Client();
    }

    public Server createServer(String keytabFile, String principalConf, String clientConf) throws TTransportException {
        return new Server(keytabFile, principalConf, clientConf);
    }

    public String getServerPrincipal(String principalConfig, String host) throws IOException {
        String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
        String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
        if (names.length != 3) {
            throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
        }
        return serverPrincipal;
    }

    public String getCanonicalHostName(String hostName) {
        try {
            return InetAddress.getByName(hostName).getCanonicalHostName();
        }
        catch (UnknownHostException exception) {
            LOG.warn((Object)("Could not retrieve canonical hostname for " + hostName), (Throwable)exception);
            return hostName;
        }
    }

    public UserGroupInformation getCurrentUGIWithConf(String authMethod) throws IOException {
        UserGroupInformation ugi;
        try {
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get current user: " + e, e);
        }
        if (this.loginUserHasCurrentAuthMethod(ugi, authMethod)) {
            LOG.debug((Object)("Not setting UGI conf as passed-in authMethod of " + authMethod + " = current."));
            return ugi;
        }
        LOG.debug((Object)("Setting UGI conf as passed-in authMethod of " + authMethod + " != current."));
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authMethod);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return UserGroupInformation.getCurrentUser();
    }

    protected boolean loginUserHasCurrentAuthMethod(UserGroupInformation ugi, String sAuthMethod) {
        UserGroupInformation.AuthenticationMethod authMethod;
        try {
            authMethod = Enum.valueOf(UserGroupInformation.AuthenticationMethod.class, sAuthMethod.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.security.authentication of " + sAuthMethod, iae);
        }
        LOG.debug((Object)("Current authMethod = " + ugi.getAuthenticationMethod()));
        return ugi.getAuthenticationMethod().equals((Object)authMethod);
    }

    public Map<String, String> getHadoopSaslProperties(Configuration conf) {
        SaslRpcServer.init((Configuration)conf);
        return SaslRpcServer.SASL_PROPS;
    }

    public static class Server {
        protected final UserGroupInformation realUgi;
        protected final UserGroupInformation clientValidationUGI;
        protected DelegationTokenSecretManager secretManager;
        static final ThreadLocal<InetAddress> remoteAddress = new ThreadLocal<InetAddress>(){

            @Override
            protected synchronized InetAddress initialValue() {
                return null;
            }
        };
        static final ThreadLocal<UserGroupInformation.AuthenticationMethod> authenticationMethod = new ThreadLocal<UserGroupInformation.AuthenticationMethod>(){

            @Override
            protected synchronized UserGroupInformation.AuthenticationMethod initialValue() {
                return UserGroupInformation.AuthenticationMethod.TOKEN;
            }
        };
        private static ThreadLocal<String> remoteUser = new ThreadLocal<String>(){

            @Override
            protected synchronized String initialValue() {
                return null;
            }
        };

        public Server() throws TTransportException {
            try {
                this.realUgi = UserGroupInformation.getCurrentUser();
                this.clientValidationUGI = UserGroupInformation.getCurrentUser();
            }
            catch (IOException ioe) {
                throw new TTransportException((Throwable)ioe);
            }
        }

        protected Server(String keytabFile, String principalConf, String clientConf) throws TTransportException {
            if (keytabFile == null || keytabFile.isEmpty()) {
                throw new TTransportException("No keytab specified");
            }
            if (principalConf == null || principalConf.isEmpty()) {
                throw new TTransportException("No principal specified");
            }
            try {
                LOG.info((Object)"Logging in via CLIENT based principal ");
                String kerberosName = SecurityUtil.getServerPrincipal((String)clientConf, (String)"0.0.0.0");
                UserGroupInformation.loginUserFromKeytab((String)kerberosName, (String)keytabFile);
                this.clientValidationUGI = UserGroupInformation.getLoginUser();
                assert (this.clientValidationUGI.isFromKeytab());
                LOG.info((Object)"Logging in via SERVER based principal ");
                kerberosName = SecurityUtil.getServerPrincipal((String)principalConf, (String)"0.0.0.0");
                UserGroupInformation.loginUserFromKeytab((String)kerberosName, (String)keytabFile);
                this.realUgi = UserGroupInformation.getLoginUser();
                assert (this.realUgi.isFromKeytab());
            }
            catch (IOException ioe) {
                throw new TTransportException((Throwable)ioe);
            }
        }

        public void setSecretManager(DelegationTokenSecretManager secretManager) {
            this.secretManager = secretManager;
        }

        public TTransportFactory createTransportFactory(Map<String, String> saslProps, Configuration conf) throws TTransportException {
            String kerberosName = this.clientValidationUGI.getUserName();
            String[] names = SaslRpcServer.splitKerberosName((String)kerberosName);
            if (names.length != 3) {
                throw new TTransportException("Kerberos principal should have 3 parts: " + kerberosName);
            }
            TSaslServerTransport.Factory transFactory = new TSaslServerTransport.Factory();
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), names[0], names[1], saslProps, (CallbackHandler)new SaslGssCallbackHandler(conf));
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.DIGEST.getMechanismName(), null, "default", saslProps, (CallbackHandler)new SaslDigestCallbackHandler(this.secretManager));
            return new TUGIAssumingTransportFactory((TTransportFactory)transFactory, this.clientValidationUGI);
        }

        public TProcessor wrapProcessor(TProcessor processor) {
            return new TUGIAssumingProcessor(processor, this.secretManager, true);
        }

        public TProcessor wrapNonAssumingProcessor(TProcessor processor) {
            return new TUGIAssumingProcessor(processor, this.secretManager, false);
        }

        public InetAddress getRemoteAddress() {
            return remoteAddress.get();
        }

        public String getRemoteUser() {
            return remoteUser.get();
        }

        static class TUGIAssumingTransportFactory
        extends TTransportFactory {
            private final UserGroupInformation ugi;
            private final TTransportFactory wrapped;

            public TUGIAssumingTransportFactory(TTransportFactory wrapped, UserGroupInformation ugi) {
                assert (wrapped != null);
                assert (ugi != null);
                this.wrapped = wrapped;
                this.ugi = ugi;
            }

            public TTransport getTransport(final TTransport trans) {
                return (TTransport)this.ugi.doAs((PrivilegedAction)new PrivilegedAction<TTransport>(){

                    @Override
                    public TTransport run() {
                        return wrapped.getTransport(trans);
                    }
                });
            }
        }

        protected class TUGIAssumingProcessor
        implements TProcessor {
            final TProcessor wrapped;
            DelegationTokenSecretManager secretManager;
            boolean useProxy;
            private final ThreadLocal<UserGroupInformation> clientUgi = new ThreadLocal<UserGroupInformation>(){

                @Override
                protected UserGroupInformation initialValue() {
                    return null;
                }
            };

            TUGIAssumingProcessor(TProcessor wrapped, DelegationTokenSecretManager secretManager, boolean useProxy) {
                this.wrapped = wrapped;
                this.secretManager = secretManager;
                this.useProxy = useProxy;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(final TProtocol inProt, final TProtocol outProt) throws TException {
                boolean rc;
                RuntimeException runtimeException;
                TException exception;
                block22: {
                    TTransport trans = inProt.getTransport();
                    exception = null;
                    runtimeException = null;
                    rc = false;
                    if (trans instanceof TSaslServerTransport) {
                        TSaslServerTransport saslTrans = (TSaslServerTransport)trans;
                        SaslServer saslServer = saslTrans.getSaslServer();
                        String authId = saslServer.getAuthorizationID();
                        authenticationMethod.set(UserGroupInformation.AuthenticationMethod.KERBEROS);
                        LOG.debug((Object)("AUTH ID ======> " + authId));
                        String endUser = authId;
                        if (saslServer.getMechanismName().equals("DIGEST-MD5")) {
                            try {
                                TokenIdentifier tokenId = SaslRpcServer.getIdentifier((String)authId, (SecretManager)this.secretManager);
                                endUser = tokenId.getUser().getUserName();
                                authenticationMethod.set(UserGroupInformation.AuthenticationMethod.TOKEN);
                            }
                            catch (SecretManager.InvalidToken e) {
                                exception = new TException(e.getMessage());
                            }
                        }
                        if (exception == null) {
                            Socket socket = ((TSocket)saslTrans.getUnderlyingTransport()).getSocket();
                            remoteAddress.set(socket.getInetAddress());
                            try {
                                if (this.useProxy) {
                                    remoteUser.set(this.getClientUgi(endUser).getShortUserName());
                                    LOG.debug((Object)("Set remoteUser :" + (String)remoteUser.get()));
                                    rc = (Boolean)this.getClientUgi(endUser).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                                        @Override
                                        public Boolean run() {
                                            try {
                                                return TUGIAssumingProcessor.this.wrapped.process(inProt, outProt);
                                            }
                                            catch (TException te) {
                                                throw new RuntimeException(te);
                                            }
                                        }
                                    });
                                    break block22;
                                }
                                UserGroupInformation endUserUgi = UserGroupInformation.createRemoteUser((String)endUser);
                                remoteUser.set(endUserUgi.getShortUserName());
                                LOG.debug((Object)("Set remoteUser :" + (String)remoteUser.get() + ", from endUser :" + endUser));
                                rc = this.wrapped.process(inProt, outProt);
                            }
                            catch (RuntimeException e) {
                                if (e.getCause() instanceof TException) {
                                    exception = (TException)e.getCause();
                                    break block22;
                                }
                                runtimeException = e;
                            }
                            catch (InterruptedException e) {
                                runtimeException = new RuntimeException(e);
                            }
                            catch (IOException e) {
                                runtimeException = new RuntimeException(e);
                            }
                            catch (TException e) {
                                exception = e;
                            }
                            catch (Throwable e) {
                                LOG.error((Object)"Unexpected exception", e);
                                runtimeException = new RuntimeException(e);
                            }
                        }
                    } else {
                        exception = new TException("Unexpected non-SASL transport " + trans.getClass());
                    }
                }
                if (!rc && this.clientUgi.get() != null) {
                    LOG.debug((Object)("Closing FileSystem for UGI: " + this.clientUgi.get()));
                    try {
                        FileSystem.closeAllForUGI((UserGroupInformation)this.clientUgi.get());
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Could not clean up file-system handles for UGI: " + this.clientUgi.get()), (Throwable)e);
                    }
                    finally {
                        this.clientUgi.set(null);
                    }
                }
                if (exception != null) {
                    throw exception;
                }
                if (runtimeException != null) {
                    throw runtimeException;
                }
                return rc;
            }

            private synchronized UserGroupInformation getClientUgi(String endUser) throws IOException {
                if (this.clientUgi.get() == null) {
                    this.clientUgi.set(UserGroupInformation.createProxyUser((String)endUser, (UserGroupInformation)UserGroupInformation.getLoginUser()));
                }
                return this.clientUgi.get();
            }
        }

        static class SaslDigestCallbackHandler
        implements CallbackHandler {
            private final DelegationTokenSecretManager secretManager;

            public SaslDigestCallbackHandler(DelegationTokenSecretManager secretManager) {
                this.secretManager = secretManager;
            }

            private char[] getPassword(DelegationTokenIdentifier tokenid) throws SecretManager.InvalidToken {
                return this.encodePassword(this.secretManager.retrievePassword(tokenid));
            }

            private char[] encodePassword(byte[] password) {
                return new String(Base64.encodeBase64((byte[])password)).toCharArray();
            }

            @Override
            public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                AuthorizeCallback ac = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof AuthorizeCallback) {
                        ac = (AuthorizeCallback)callback;
                        continue;
                    }
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        continue;
                    }
                    if (callback instanceof RealmCallback) continue;
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
                }
                if (pc != null) {
                    DelegationTokenIdentifier tokenIdentifier = (DelegationTokenIdentifier)SaslRpcServer.getIdentifier((String)nc.getDefaultName(), (SecretManager)this.secretManager);
                    char[] password = this.getPassword(tokenIdentifier);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL server DIGEST-MD5 callback: setting password for client: " + tokenIdentifier.getUser()));
                    }
                    pc.setPassword(password);
                }
                if (ac != null) {
                    String authzid;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (ac.isAuthorized()) {
                        if (LOG.isDebugEnabled()) {
                            String username = ((DelegationTokenIdentifier)SaslRpcServer.getIdentifier((String)authzid, (SecretManager)this.secretManager)).getUser().getUserName();
                            LOG.debug((Object)("SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username));
                        }
                        ac.setAuthorizedID(authzid);
                    }
                }
            }
        }

        static class SaslGssCallbackHandler
        extends SaslRpcServer.SaslGssCallbackHandler
        implements CallbackHandler {
            private final Set<String> whitelistGroups = new HashSet<String>();
            public static final String WHITELIST_GROUP_KEYNAME = "hive.server2.thrift.access.whitelist.groups";

            public SaslGssCallbackHandler(Configuration conf) {
                if (conf != null) {
                    String groups = conf.get(WHITELIST_GROUP_KEYNAME);
                    if (groups != null && !groups.isEmpty()) {
                        for (String group : groups.split(",")) {
                            this.whitelistGroups.add(group);
                        }
                        LOG.info((Object)("Whitelist groups for hive server 2 are " + this.whitelistGroups));
                    } else {
                        LOG.info((Object)"No whilelist group hive.server2.thrift.access.whitelist.groups configured for HiveServer2");
                    }
                }
            }

            @Override
            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                super.handle(callbacks);
                AuthorizeCallback ac = null;
                for (Callback callback : callbacks) {
                    if (!(callback instanceof AuthorizeCallback)) {
                        throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                    }
                    ac = (AuthorizeCallback)callback;
                }
                if (ac != null && ac.isAuthorized()) {
                    boolean authorized = false;
                    String authid = ac.getAuthenticationID();
                    if (this.whitelistGroups.size() > 0) {
                        UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)authid);
                        for (String group : remoteUser.getGroupNames()) {
                            if (group == null || !this.whitelistGroups.contains(group)) continue;
                            authorized = true;
                            LOG.debug((Object)"User is part of whitelist group Will grant access");
                            break;
                        }
                        if (!authorized) {
                            ac.setAuthorized(false);
                            LOG.info((Object)("User not part of whitelist group: " + this.whitelistGroups + ". Will deny access"));
                        }
                    }
                }
            }
        }

        public static enum ServerMode {
            HIVESERVER2,
            METASTORE;

        }
    }

    public static class Client {
        public TTransport createClientTransport(String principalConfig, String host, String methodStr, String tokenStrForm, TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
            SaslRpcServer.AuthMethod method = (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.valueOf(SaslRpcServer.AuthMethod.class, (String)methodStr);
            TSaslClientTransport saslTransport = null;
            switch (method) {
                case DIGEST: {
                    Token t = new Token();
                    t.decodeFromUrlString(tokenStrForm);
                    saslTransport = new TSaslClientTransport(method.getMechanismName(), null, null, "default", saslProps, (CallbackHandler)new SaslClientCallbackHandler((Token<? extends TokenIdentifier>)t), underlyingTransport);
                    return new TUGIAssumingTransport((TTransport)saslTransport, UserGroupInformation.getCurrentUser());
                }
                case KERBEROS: {
                    String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
                    String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
                    if (names.length != 3) {
                        throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
                    }
                    try {
                        saslTransport = new TSaslClientTransport(method.getMechanismName(), null, names[0], names[1], saslProps, null, underlyingTransport);
                        return new TUGIAssumingTransport((TTransport)saslTransport, UserGroupInformation.getCurrentUser());
                    }
                    catch (SaslException se) {
                        throw new IOException("Could not instantiate SASL transport", se);
                    }
                }
            }
            throw new IOException("Unsupported authentication method: " + method);
        }

        private static class SaslClientCallbackHandler
        implements CallbackHandler {
            private final String userName;
            private final char[] userPassword;

            public SaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
                this.userName = SaslClientCallbackHandler.encodeIdentifier(token.getIdentifier());
                this.userPassword = SaslClientCallbackHandler.encodePassword(token.getPassword());
            }

            @Override
            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                TextInputCallback rc = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof RealmChoiceCallback) continue;
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        rc = (RealmCallback)callback;
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
                }
                if (nc != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL client callback: setting username: " + this.userName));
                    }
                    nc.setName(this.userName);
                }
                if (pc != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SASL client callback: setting userPassword");
                    }
                    pc.setPassword(this.userPassword);
                }
                if (rc != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL client callback: setting realm: " + rc.getDefaultText()));
                    }
                    rc.setText(rc.getDefaultText());
                }
            }

            static String encodeIdentifier(byte[] identifier) {
                return new String(Base64.encodeBase64((byte[])identifier));
            }

            static char[] encodePassword(byte[] password) {
                return new String(Base64.encodeBase64((byte[])password)).toCharArray();
            }
        }
    }
}

