/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@VisibleForTesting
public class WorkflowPriorityMappingsManager {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowPriorityMappingsManager.class);
    private static final String WORKFLOW_PART_SEPARATOR = ":";
    private static final String WORKFLOW_SEPARATOR = ",";
    private CapacityScheduler scheduler;
    private CapacitySchedulerConfiguration conf;
    private boolean overrideWithPriorityMappings = false;
    private Map<String, Map<String, WorkflowPriorityMapping>> priorityMappings = new HashMap<String, Map<String, WorkflowPriorityMapping>>();

    @VisibleForTesting
    public void initialize(CapacityScheduler scheduler) throws IOException {
        this.scheduler = scheduler;
        this.conf = scheduler.getConfiguration();
        boolean overrideWithWorkflowPriorityMappings = this.conf.getOverrideWithWorkflowPriorityMappings();
        LOG.info("Initialized workflow priority mappings, override: " + overrideWithWorkflowPriorityMappings);
        this.overrideWithPriorityMappings = overrideWithWorkflowPriorityMappings;
        this.priorityMappings = this.getWorkflowPriorityMappings();
    }

    public Map<String, Map<String, WorkflowPriorityMapping>> getWorkflowPriorityMappings() {
        HashMap<String, Map<String, WorkflowPriorityMapping>> mappings = new HashMap<String, Map<String, WorkflowPriorityMapping>>();
        Collection<String> workflowMappings = this.conf.getWorkflowPriorityMappings();
        for (String workflowMapping : workflowMappings) {
            WorkflowPriorityMapping mapping = this.getWorkflowMappingFromString(workflowMapping);
            if (mapping == null) continue;
            if (!mappings.containsKey(mapping.queue)) {
                mappings.put(mapping.queue, new HashMap());
            }
            ((Map)mappings.get(mapping.queue)).put(mapping.workflowID, mapping);
        }
        return mappings;
    }

    private WorkflowPriorityMapping getWorkflowMappingFromString(String mappingString) {
        WorkflowPriorityMapping mapping;
        if (mappingString == null) {
            return null;
        }
        String[] mappingArray = StringUtils.getTrimmedStringCollection((String)mappingString, (String)WORKFLOW_PART_SEPARATOR).toArray(new String[0]);
        if (mappingArray.length != 3 || mappingArray[0].length() == 0 || mappingArray[1].length() == 0 || mappingArray[2].length() == 0) {
            throw new IllegalArgumentException("Illegal workflow priority mapping " + mappingString);
        }
        try {
            mapping = new WorkflowPriorityMapping(mappingArray[0], mappingArray[1], Priority.newInstance((int)Integer.parseInt(mappingArray[2])));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal workflow priority for mapping " + mappingString);
        }
        return mapping;
    }

    public Priority getMappedPriority(String workflowID, CSQueue queue) {
        if (queue.equals(this.scheduler.getRootQueue())) {
            return null;
        }
        String queuePath = queue.getQueuePath();
        if (this.priorityMappings.containsKey(queuePath) && this.priorityMappings.get(queuePath).containsKey(workflowID)) {
            return this.priorityMappings.get((Object)queuePath).get((Object)workflowID).priority;
        }
        queue = queue.getParent();
        return this.getMappedPriority(workflowID, queue);
    }

    public Priority mapWorkflowPriorityForApp(ApplicationId applicationId, CSQueue queue, String user, Priority priority) throws YarnException {
        RMApp rmApp;
        if (this.overrideWithPriorityMappings && (rmApp = (RMApp)this.scheduler.getRMContext().getRMApps().get(applicationId)) != null && rmApp.getApplicationTags() != null && rmApp.getApplicationSubmissionContext() != null) {
            Priority mappedPriority;
            String workflowTagPrefix = this.scheduler.getConf().get("yarn.workflow-id.tag-prefix", "workflowid:");
            String workflowID = null;
            for (String tag : rmApp.getApplicationTags()) {
                if (!tag.trim().startsWith(workflowTagPrefix)) continue;
                workflowID = tag.trim().substring(workflowTagPrefix.length());
            }
            if (workflowID != null && !workflowID.isEmpty() && this.priorityMappings != null && this.priorityMappings.size() > 0 && (mappedPriority = this.getMappedPriority(workflowID, queue)) != null) {
                LOG.info("Application " + applicationId + " user " + user + " workflow " + workflowID + " queue " + queue.getQueueName() + " mapping [" + priority + "] to [" + mappedPriority + "] override " + this.overrideWithPriorityMappings);
                priority = mappedPriority;
                priority = this.scheduler.checkAndGetApplicationPriority(priority, UserGroupInformation.createRemoteUser((String)user), queue.getQueueName(), applicationId);
                rmApp.getApplicationSubmissionContext().setPriority(priority);
                ((RMAppImpl)rmApp).setApplicationPriority(priority);
            }
        }
        return priority;
    }

    public static String getWorkflowPriorityMappingStr(List<WorkflowPriorityMapping> workflowPriorityMappings) {
        if (workflowPriorityMappings == null) {
            return "";
        }
        ArrayList<String> workflowPriorityMappingStrs = new ArrayList<String>();
        for (WorkflowPriorityMapping mapping : workflowPriorityMappings) {
            workflowPriorityMappingStrs.add(mapping.toString());
        }
        return StringUtils.join((CharSequence)WORKFLOW_SEPARATOR, workflowPriorityMappingStrs);
    }

    public static class WorkflowPriorityMapping {
        String workflowID;
        String queue;
        Priority priority;

        public WorkflowPriorityMapping(String workflowID, String queue, Priority priority) {
            this.workflowID = workflowID;
            this.queue = queue;
            this.priority = priority;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof WorkflowPriorityMapping) {
                WorkflowPriorityMapping other = (WorkflowPriorityMapping)obj;
                return other.workflowID.equals(this.workflowID) && other.queue.equals(this.queue) && other.priority.equals((Object)this.priority);
            }
            return false;
        }

        public String toString() {
            return this.workflowID + WorkflowPriorityMappingsManager.WORKFLOW_PART_SEPARATOR + this.queue + WorkflowPriorityMappingsManager.WORKFLOW_PART_SEPARATOR + this.priority.getPriority();
        }
    }
}

