/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop.mapreduce;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.mapreduce.common.Utils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptContextImpl
extends org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl {
    private final TezCounters tezCounters;
    private final Reporter reporter;

    public static org.apache.hadoop.mapred.TaskAttemptID createMockTaskAttemptID(long clusterId, int vertexIndex, int appId, int taskIndex, int taskAttemptNumber, boolean isMap) {
        return new org.apache.hadoop.mapred.TaskAttemptID(new TaskID(String.valueOf(clusterId) + String.valueOf(vertexIndex), appId, isMap ? TaskType.MAP : TaskType.REDUCE, taskIndex), taskAttemptNumber);
    }

    public static org.apache.hadoop.mapred.TaskAttemptID createMockTaskAttemptIDFromTezTaskAttemptId(TezTaskAttemptID tezTaId, boolean isMap) {
        TezVertexID vId = tezTaId.getTaskID().getVertexID();
        ApplicationId appId = vId.getDAGId().getApplicationId();
        return new org.apache.hadoop.mapred.TaskAttemptID(new TaskID(String.valueOf(appId.getClusterTimestamp()) + String.valueOf(vId.getId()), appId.getId(), isMap ? TaskType.MAP : TaskType.REDUCE, tezTaId.getTaskID().getId()), tezTaId.getId());
    }

    public static TaskID createMockTaskAttemptIDFromTezTaskId(TezTaskID tezTaId, boolean isMap) {
        TezVertexID vId = tezTaId.getVertexID();
        ApplicationId appId = vId.getDAGId().getApplicationId();
        return new TaskID(String.valueOf(appId.getClusterTimestamp()) + String.valueOf(vId.getId()), appId.getId(), isMap ? TaskType.MAP : TaskType.REDUCE, tezTaId.getId());
    }

    public TaskAttemptContextImpl(Configuration conf, TezCounters tezCounters, long clusterId, int vertexIndex, int appId, int taskIndex, int taskAttemptNumber, boolean isMap, Reporter reporter) {
        this(conf, (TaskAttemptID)TaskAttemptContextImpl.createMockTaskAttemptID(clusterId, vertexIndex, appId, taskIndex, taskAttemptNumber, isMap), tezCounters, reporter);
    }

    public TaskAttemptContextImpl(Configuration conf, TaskAttemptID attemptId, TezCounters tezCounters, boolean isMap, Reporter reporter) {
        this(conf, attemptId, tezCounters, reporter);
    }

    public TaskAttemptContextImpl(Configuration conf, TaskAttemptID taId, TezCounters tezCounters, Reporter reporter) {
        super(conf, taId);
        this.tezCounters = tezCounters;
        this.reporter = reporter;
    }

    public float getProgress() {
        return this.reporter == null ? 0.0f : this.reporter.getProgress();
    }

    public Counter getCounter(Enum<?> counterName) {
        return Utils.getMRCounter(this.tezCounters.findCounter(counterName));
    }

    public Counter getCounter(String groupName, String counterName) {
        return Utils.getMRCounter(this.tezCounters.findCounter(groupName, counterName));
    }

    public void progress() {
    }

    public void setStatus(String status) {
        this.setStatusString(status);
    }
}

