/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.collect.Lists;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.common.TezConverterUtils;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.utils.TezEventUtils;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.internals.api.events.SystemEventProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAttemptFinishedEvent
implements HistoryEvent {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAttemptFinishedEvent.class);
    private TezTaskAttemptID taskAttemptId;
    private String vertexName;
    private long creationTime;
    private long allocationTime;
    private long startTime;
    private long finishTime;
    private TezTaskAttemptID creationCausalTA;
    private TaskAttemptState state;
    private TaskFailureType taskFailureType;
    private String diagnostics;
    private TezCounters tezCounters;
    private TaskAttemptTerminationCause error;
    private List<TaskAttemptImpl.DataEventDependencyInfo> dataEvents;
    private List<TezEvent> taGeneratedEvents;
    private ContainerId containerId;
    private NodeId nodeId;
    private String inProgressLogsUrl;
    private String completedLogsUrl;
    private String nodeHttpAddress;

    public TaskAttemptFinishedEvent(TezTaskAttemptID taId, String vertexName, long startTime, long finishTime, TaskAttemptState state, @Nullable TaskFailureType taskFailureType, TaskAttemptTerminationCause error, String diagnostics, TezCounters counters, List<TaskAttemptImpl.DataEventDependencyInfo> dataEvents, List<TezEvent> taGeneratedEvents, long creationTime, TezTaskAttemptID creationCausalTA, long allocationTime, ContainerId containerId, NodeId nodeId, String inProgressLogsUrl, String completedLogsUrl, String nodeHttpAddress) {
        this.taskAttemptId = taId;
        this.vertexName = vertexName;
        this.creationCausalTA = creationCausalTA;
        this.creationTime = creationTime;
        this.allocationTime = allocationTime;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.taskFailureType = taskFailureType;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
        this.error = error;
        this.dataEvents = dataEvents;
        this.taGeneratedEvents = taGeneratedEvents;
        this.containerId = containerId;
        this.nodeId = nodeId;
        this.inProgressLogsUrl = inProgressLogsUrl;
        this.completedLogsUrl = completedLogsUrl;
        this.nodeHttpAddress = nodeHttpAddress;
    }

    public TaskAttemptFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_ATTEMPT_FINISHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public List<TaskAttemptImpl.DataEventDependencyInfo> getDataEvents() {
        return this.dataEvents;
    }

    public RecoveryProtos.TaskAttemptFinishedProto toProto() throws IOException {
        RecoveryProtos.TaskAttemptFinishedProto.Builder builder = RecoveryProtos.TaskAttemptFinishedProto.newBuilder();
        builder.setTaskAttemptId(this.taskAttemptId.toString()).setState(this.state.ordinal()).setCreationTime(this.creationTime).setAllocationTime(this.allocationTime).setStartTime(this.startTime).setFinishTime(this.finishTime);
        if (this.taskFailureType != null) {
            builder.setTaskFailureType(TezConverterUtils.failureTypeToProto((TaskFailureType)this.taskFailureType));
        }
        if (this.creationCausalTA != null) {
            builder.setCreationCausalTA(this.creationCausalTA.toString());
        }
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        if (this.error != null) {
            builder.setErrorEnum(this.error.name());
        }
        if (this.tezCounters != null) {
            builder.setCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)this.tezCounters));
        }
        if (this.dataEvents != null && !this.dataEvents.isEmpty()) {
            for (TaskAttemptImpl.DataEventDependencyInfo info : this.dataEvents) {
                builder.addDataEvents(TaskAttemptImpl.DataEventDependencyInfo.toProto(info));
            }
        }
        if (this.taGeneratedEvents != null && !this.taGeneratedEvents.isEmpty()) {
            for (TezEvent event : this.taGeneratedEvents) {
                builder.addTaGeneratedEvents(TezEventUtils.toProto(event));
            }
        }
        if (this.containerId != null) {
            builder.setContainerId(this.containerId.toString());
        }
        if (this.nodeId != null) {
            builder.setNodeId(this.nodeId.toString());
        }
        if (this.nodeHttpAddress != null) {
            builder.setNodeHttpAddress(this.nodeHttpAddress);
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.TaskAttemptFinishedProto proto) throws IOException {
        this.taskAttemptId = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
        this.state = TaskAttemptState.values()[proto.getState()];
        this.creationTime = proto.getCreationTime();
        this.allocationTime = proto.getAllocationTime();
        this.startTime = proto.getStartTime();
        this.finishTime = proto.getFinishTime();
        if (proto.hasTaskFailureType()) {
            this.taskFailureType = TezConverterUtils.failureTypeFromProto((SystemEventProtos.TaskFailureTypeProto)proto.getTaskFailureType());
        }
        if (proto.hasCreationCausalTA()) {
            this.creationCausalTA = TezTaskAttemptID.fromString((String)proto.getCreationCausalTA());
        }
        if (proto.hasDiagnostics()) {
            this.diagnostics = proto.getDiagnostics();
        }
        if (proto.hasErrorEnum()) {
            this.error = TaskAttemptTerminationCause.valueOf((String)proto.getErrorEnum());
        }
        if (proto.hasCounters()) {
            this.tezCounters = DagTypeConverters.convertTezCountersFromProto((DAGProtos.TezCountersProto)proto.getCounters());
        }
        if (proto.getDataEventsCount() > 0) {
            this.dataEvents = Lists.newArrayListWithCapacity((int)proto.getDataEventsCount());
            for (RecoveryProtos.DataEventDependencyInfoProto protoEvent : proto.getDataEventsList()) {
                this.dataEvents.add(TaskAttemptImpl.DataEventDependencyInfo.fromProto(protoEvent));
            }
        }
        if (proto.getTaGeneratedEventsCount() > 0) {
            this.taGeneratedEvents = Lists.newArrayListWithCapacity((int)proto.getTaGeneratedEventsCount());
            for (RecoveryProtos.TezEventProto eventProto : proto.getTaGeneratedEventsList()) {
                this.taGeneratedEvents.add(TezEventUtils.fromProto(eventProto));
            }
        }
        if (proto.hasContainerId()) {
            this.containerId = ConverterUtils.toContainerId((String)proto.getContainerId());
        }
        if (proto.hasNodeId()) {
            this.nodeId = ConverterUtils.toNodeId((String)proto.getNodeId());
        }
        if (proto.hasNodeHttpAddress()) {
            this.nodeHttpAddress = proto.getNodeHttpAddress();
        }
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.TaskAttemptFinishedProto proto = (RecoveryProtos.TaskAttemptFinishedProto)inputStream.readMessage(RecoveryProtos.TaskAttemptFinishedProto.PARSER, null);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("vertexName=");
        sb.append(this.vertexName);
        sb.append(", taskAttemptId=");
        sb.append(this.taskAttemptId);
        sb.append(", creationTime=");
        sb.append(this.creationTime);
        sb.append(", allocationTime=");
        sb.append(this.allocationTime);
        sb.append(", startTime=");
        sb.append(this.startTime);
        sb.append(", finishTime=");
        sb.append(this.finishTime);
        sb.append(", timeTaken=");
        sb.append(this.finishTime - this.startTime);
        sb.append(", status=");
        sb.append(this.state.name());
        if (this.taskFailureType != null) {
            sb.append(", taskFailureType=");
            sb.append(this.taskFailureType);
        }
        if (this.error != null) {
            sb.append(", errorEnum=");
            sb.append(this.error);
        }
        if (this.diagnostics != null) {
            sb.append(", diagnostics=");
            sb.append(this.diagnostics);
        }
        if (this.containerId != null) {
            sb.append(", containerId=");
            sb.append(this.containerId);
        }
        if (this.nodeId != null) {
            sb.append(", nodeId=");
            sb.append(this.nodeId);
        }
        if (this.nodeHttpAddress != null) {
            sb.append(", nodeHttpAddress=");
            sb.append(this.nodeHttpAddress);
        }
        if (this.state != TaskAttemptState.SUCCEEDED) {
            sb.append(", counters=");
            if (this.tezCounters == null) {
                sb.append("null");
            } else {
                sb.append("Counters: ");
                sb.append(this.tezCounters.countCounters());
                for (CounterGroup group : this.tezCounters) {
                    sb.append(", ");
                    sb.append(group.getDisplayName());
                    for (TezCounter counter : group) {
                        sb.append(", ");
                        sb.append(counter.getDisplayName()).append("=").append(counter.getValue());
                    }
                }
            }
        }
        return sb.toString();
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptId;
    }

    public TezCounters getCounters() {
        return this.tezCounters;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public TaskAttemptTerminationCause getTaskAttemptError() {
        return this.error;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public TaskAttemptState getState() {
        return this.state;
    }

    public TaskFailureType getTaskFailureType() {
        return this.taskFailureType;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getAllocationTime() {
        return this.allocationTime;
    }

    public TezTaskAttemptID getCreationCausalTA() {
        return this.creationCausalTA;
    }

    public List<TezEvent> getTAGeneratedEvents() {
        return this.taGeneratedEvents;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String getInProgressLogsUrl() {
        return this.inProgressLogsUrl;
    }

    public String getCompletedLogsUrl() {
        return this.completedLogsUrl;
    }

    public String getNodeHttpAddress() {
        return this.nodeHttpAddress;
    }
}

