/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.avro.InstanceCache;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Writable;

class AvroSerializer {
    private static final Log LOG = LogFactory.getLog(AvroSerializer.class);
    private static final Schema STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
    AvroGenericRecordWritable cache = new AvroGenericRecordWritable();
    final InstanceCache<Schema, InstanceCache<Object, GenericEnumSymbol>> enums = new InstanceCache<Schema, InstanceCache<Object, GenericEnumSymbol>>(){

        @Override
        protected InstanceCache<Object, GenericEnumSymbol> makeInstance(final Schema schema, Set<Schema> seenSchemas) {
            return new InstanceCache<Object, GenericEnumSymbol>(){

                @Override
                protected GenericEnumSymbol makeInstance(Object seed, Set<Object> seenSchemas) {
                    return new GenericData.EnumSymbol(schema, seed.toString());
                }
            };
        }
    };

    AvroSerializer() {
    }

    public Writable serialize(Object o, ObjectInspector objectInspector, List<String> columnNames, List<TypeInfo> columnTypes, Schema schema) throws AvroSerdeException {
        StructObjectInspector soi = (StructObjectInspector)objectInspector;
        GenericData.Record record = new GenericData.Record(schema);
        List<? extends StructField> outputFieldRefs = soi.getAllStructFieldRefs();
        if (outputFieldRefs.size() != columnNames.size()) {
            throw new AvroSerdeException("Number of input columns was different than output columns (in = " + columnNames.size() + " vs out = " + outputFieldRefs.size());
        }
        int size = schema.getFields().size();
        if (outputFieldRefs.size() != size) {
            throw new AvroSerdeException("Hive passed in a different number of fields than the schema expected: (Hive wanted " + outputFieldRefs.size() + ", Avro expected " + schema.getFields().size());
        }
        List<? extends StructField> allStructFieldRefs = soi.getAllStructFieldRefs();
        List<Object> structFieldsDataAsList = soi.getStructFieldsDataAsList(o);
        for (int i = 0; i < size; ++i) {
            Schema.Field field = (Schema.Field)schema.getFields().get(i);
            TypeInfo typeInfo = columnTypes.get(i);
            StructField structFieldRef = allStructFieldRefs.get(i);
            Object structFieldData = structFieldsDataAsList.get(i);
            ObjectInspector fieldOI = structFieldRef.getFieldObjectInspector();
            Object val = this.serialize(typeInfo, fieldOI, structFieldData, field.schema());
            record.put(field.name(), val);
        }
        if (!GenericData.get().validate(schema, (Object)record)) {
            throw new SerializeToAvroException(schema, record);
        }
        this.cache.setRecord((GenericRecord)record);
        return this.cache;
    }

    private Object serialize(TypeInfo typeInfo, ObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        if (null == structFieldData) {
            return null;
        }
        if (AvroSerdeUtils.isNullableType(schema)) {
            schema = AvroSerdeUtils.getOtherTypeFromNullableType(schema);
        }
        if (Schema.Type.ENUM.equals((Object)schema.getType())) {
            assert (fieldOI instanceof PrimitiveObjectInspector);
            return this.serializeEnum(typeInfo, (PrimitiveObjectInspector)fieldOI, structFieldData, schema);
        }
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                assert (fieldOI instanceof PrimitiveObjectInspector);
                return this.serializePrimitive(typeInfo, (PrimitiveObjectInspector)fieldOI, structFieldData, schema);
            }
            case MAP: {
                assert (fieldOI instanceof MapObjectInspector);
                assert (typeInfo instanceof MapTypeInfo);
                return this.serializeMap((MapTypeInfo)typeInfo, (MapObjectInspector)fieldOI, structFieldData, schema);
            }
            case LIST: {
                assert (fieldOI instanceof ListObjectInspector);
                assert (typeInfo instanceof ListTypeInfo);
                return this.serializeList((ListTypeInfo)typeInfo, (ListObjectInspector)fieldOI, structFieldData, schema);
            }
            case UNION: {
                assert (fieldOI instanceof UnionObjectInspector);
                assert (typeInfo instanceof UnionTypeInfo);
                return this.serializeUnion((UnionTypeInfo)typeInfo, (UnionObjectInspector)fieldOI, structFieldData, schema);
            }
            case STRUCT: {
                assert (fieldOI instanceof StructObjectInspector);
                assert (typeInfo instanceof StructTypeInfo);
                return this.serializeStruct((StructTypeInfo)typeInfo, (StructObjectInspector)fieldOI, structFieldData, schema);
            }
        }
        throw new AvroSerdeException("Ran out of TypeInfo Categories: " + (Object)((Object)typeInfo.getCategory()));
    }

    private Object serializeEnum(TypeInfo typeInfo, PrimitiveObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        return this.enums.retrieve(schema).retrieve(this.serializePrimitive(typeInfo, fieldOI, structFieldData, schema));
    }

    private Object serializeStruct(StructTypeInfo typeInfo, StructObjectInspector ssoi, Object o, Schema schema) throws AvroSerdeException {
        int size = schema.getFields().size();
        List<? extends StructField> allStructFieldRefs = ssoi.getAllStructFieldRefs();
        List<Object> structFieldsDataAsList = ssoi.getStructFieldsDataAsList(o);
        GenericData.Record record = new GenericData.Record(schema);
        ArrayList<TypeInfo> allStructFieldTypeInfos = typeInfo.getAllStructFieldTypeInfos();
        for (int i = 0; i < size; ++i) {
            Schema.Field field = (Schema.Field)schema.getFields().get(i);
            TypeInfo colTypeInfo = allStructFieldTypeInfos.get(i);
            StructField structFieldRef = allStructFieldRefs.get(i);
            Object structFieldData = structFieldsDataAsList.get(i);
            ObjectInspector fieldOI = structFieldRef.getFieldObjectInspector();
            Object val = this.serialize(colTypeInfo, fieldOI, structFieldData, field.schema());
            record.put(field.name(), val);
        }
        return record;
    }

    private Object serializePrimitive(TypeInfo typeInfo, PrimitiveObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        switch (fieldOI.getPrimitiveCategory()) {
            case BINARY: {
                if (schema.getType() == Schema.Type.BYTES) {
                    return AvroSerdeUtils.getBufferFromBytes((byte[])fieldOI.getPrimitiveJavaObject(structFieldData));
                }
                if (schema.getType() == Schema.Type.FIXED) {
                    GenericData.Fixed fixed = new GenericData.Fixed(schema, (byte[])fieldOI.getPrimitiveJavaObject(structFieldData));
                    return fixed;
                }
                throw new AvroSerdeException("Unexpected Avro schema for Binary TypeInfo: " + schema.getType());
            }
            case DECIMAL: {
                HiveDecimal dec = (HiveDecimal)fieldOI.getPrimitiveJavaObject(structFieldData);
                return AvroSerdeUtils.getBufferFromDecimal(dec, ((DecimalTypeInfo)typeInfo).scale());
            }
            case CHAR: {
                HiveChar ch = (HiveChar)fieldOI.getPrimitiveJavaObject(structFieldData);
                return ch.getStrippedValue();
            }
            case VARCHAR: {
                HiveVarchar vc = (HiveVarchar)fieldOI.getPrimitiveJavaObject(structFieldData);
                return vc.getValue();
            }
            case DATE: {
                Date date = ((DateObjectInspector)fieldOI).getPrimitiveJavaObject(structFieldData);
                return DateWritable.dateToDays(date);
            }
            case TIMESTAMP: {
                Timestamp timestamp = ((TimestampObjectInspector)fieldOI).getPrimitiveJavaObject(structFieldData);
                return timestamp.getTime();
            }
            case UNKNOWN: {
                throw new AvroSerdeException("Received UNKNOWN primitive category.");
            }
            case VOID: {
                return null;
            }
        }
        return fieldOI.getPrimitiveJavaObject(structFieldData);
    }

    private Object serializeUnion(UnionTypeInfo typeInfo, UnionObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        byte tag = fieldOI.getTag(structFieldData);
        return this.serialize(typeInfo.getAllUnionObjectTypeInfos().get(tag), fieldOI.getObjectInspectors().get(tag), fieldOI.getField(structFieldData), (Schema)schema.getTypes().get(tag));
    }

    private Object serializeList(ListTypeInfo typeInfo, ListObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        List<?> list = fieldOI.getList(structFieldData);
        GenericData.Array deserialized = new GenericData.Array(list.size(), schema);
        TypeInfo listElementTypeInfo = typeInfo.getListElementTypeInfo();
        ObjectInspector listElementObjectInspector = fieldOI.getListElementObjectInspector();
        Schema elementType = schema.getElementType();
        for (int i = 0; i < list.size(); ++i) {
            deserialized.add(i, this.serialize(listElementTypeInfo, listElementObjectInspector, list.get(i), elementType));
        }
        return deserialized;
    }

    private Object serializeMap(MapTypeInfo typeInfo, MapObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        if (!this.mapHasStringKey(fieldOI.getMapKeyObjectInspector())) {
            throw new AvroSerdeException("Avro only supports maps with keys as Strings.  Current Map is: " + typeInfo.toString());
        }
        ObjectInspector mapKeyObjectInspector = fieldOI.getMapKeyObjectInspector();
        ObjectInspector mapValueObjectInspector = fieldOI.getMapValueObjectInspector();
        TypeInfo mapKeyTypeInfo = typeInfo.getMapKeyTypeInfo();
        TypeInfo mapValueTypeInfo = typeInfo.getMapValueTypeInfo();
        Map<?, ?> map = fieldOI.getMap(structFieldData);
        Schema valueType = schema.getValueType();
        HashMap<Object, Object> deserialized = new HashMap<Object, Object>(fieldOI.getMapSize(structFieldData));
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            deserialized.put(this.serialize(mapKeyTypeInfo, mapKeyObjectInspector, entry.getKey(), STRING_SCHEMA), this.serialize(mapValueTypeInfo, mapValueObjectInspector, entry.getValue(), valueType));
        }
        return deserialized;
    }

    private boolean mapHasStringKey(ObjectInspector mapKeyObjectInspector) {
        return mapKeyObjectInspector instanceof PrimitiveObjectInspector && ((PrimitiveObjectInspector)mapKeyObjectInspector).getPrimitiveCategory().equals((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING);
    }

    public static class SerializeToAvroException
    extends AvroSerdeException {
        private final Schema schema;
        private final GenericData.Record record;

        public SerializeToAvroException(Schema schema, GenericData.Record record) {
            this.schema = schema;
            this.record = record;
        }

        @Override
        public String toString() {
            return "Avro could not validate record against schema (record = " + this.record + ") (schema = " + this.schema.toString(false) + ")";
        }
    }
}

