/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AliasNode
extends Node {
    private Node oldName;
    private Node newName;

    public AliasNode(ISourcePosition position, Node newName, Node oldName) {
        super(position);
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ALIASNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitAliasNode(this);
    }

    public Node getNewName() {
        return this.newName;
    }

    public Node getOldName() {
        return this.oldName;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.newName, this.oldName);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        String newerName = Helpers.interpretAliasUndefName(this.newName, runtime, context, self2, aBlock);
        String olderName = Helpers.interpretAliasUndefName(this.oldName, runtime, context, self2, aBlock);
        return Helpers.defineAlias(context, self2, newerName, olderName);
    }
}

