/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.defined;

import java.util.Map;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.defined.DefinedInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;

public abstract class DefinedObjectNameInstr
extends DefinedInstr {
    public DefinedObjectNameInstr(Operation operation, Variable result2, Operand[] operands) {
        super(operation, result2, operands);
        assert (operands.length >= 2) : "Too few operands to " + this.getClass().getName();
        assert (operands[1] instanceof StringLiteral) : "Operand 1 must be a string literal.  Was '" + operands[1].getClass() + "'";
    }

    public Operand getObject() {
        return this.operands[0];
    }

    public StringLiteral getName() {
        return (StringLiteral)this.operands[1];
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        for (int i2 = 0; i2 < this.operands.length; ++i2) {
            this.operands[i2] = this.operands[i2].getSimplifiedOperand(valueMap, force);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getObject() + ", " + this.getName() + ")";
    }
}

