/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.WriteBuffers;

public class VectorMapJoinFastKeyStore {
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinFastKeyStore.class.getName());
    private WriteBuffers writeBuffers;
    private WriteBuffers.ByteSegmentRef byteSegmentRef;
    private WriteBuffers.Position readPos;

    public long add(byte[] keyBytes, int keyStart, int keyLength) {
        boolean isKeyLengthBig = keyLength >= 1048575;
        long absoluteKeyOffset = this.writeBuffers.getWritePoint();
        if (isKeyLengthBig) {
            this.writeBuffers.writeVInt(keyLength);
        }
        this.writeBuffers.write(keyBytes, keyStart, keyLength);
        long keyRefWord = 0x1000000000000000L;
        keyRefWord = isKeyLengthBig ? (keyRefWord |= 0xFFFFF0000000000L) : (keyRefWord |= (long)keyLength << 40);
        return keyRefWord |= absoluteKeyOffset;
    }

    public boolean equalKey(long keyRefWord, byte[] keyBytes, int keyStart, int keyLength) {
        boolean isKeyLengthSmall;
        int storedKeyLengthLength = (int)((keyRefWord & 0xFFFFF0000000000L) >> 40);
        boolean bl = isKeyLengthSmall = storedKeyLengthLength != 1048575;
        if (isKeyLengthSmall && storedKeyLengthLength != keyLength) {
            return false;
        }
        long absoluteKeyOffset = keyRefWord & 0xFFFFFFFFFFL;
        this.writeBuffers.setReadPoint(absoluteKeyOffset, this.readPos);
        if (!isKeyLengthSmall && (storedKeyLengthLength = this.writeBuffers.readVInt(this.readPos)) != keyLength) {
            return false;
        }
        this.writeBuffers.getByteSegmentRefToCurrent(this.byteSegmentRef, keyLength, this.readPos);
        byte[] currentBytes = this.byteSegmentRef.getBytes();
        int currentStart = (int)this.byteSegmentRef.getOffset();
        for (int i = 0; i < keyLength; ++i) {
            if (currentBytes[currentStart + i] == keyBytes[keyStart + i]) continue;
            return false;
        }
        return true;
    }

    public VectorMapJoinFastKeyStore(int writeBuffersSize) {
        this.writeBuffers = new WriteBuffers(writeBuffersSize, 0x4000000000L);
        this.byteSegmentRef = new WriteBuffers.ByteSegmentRef();
        this.readPos = new WriteBuffers.Position();
    }

    public VectorMapJoinFastKeyStore(WriteBuffers writeBuffers) {
        this.writeBuffers = writeBuffers;
        this.byteSegmentRef = new WriteBuffers.ByteSegmentRef();
        this.readPos = new WriteBuffers.Position();
    }

    private final class IsNonZeroFlag {
        private static final int bitShift = 60;
        private static final long flagOnMask = 0x1000000000000000L;

        private IsNonZeroFlag() {
        }
    }

    private final class SmallKeyLength {
        private static final int bitLength = 20;
        private static final int allBitsOn = 1048575;
        private static final int threshold = 1048575;
        private static final int bitShift = 40;
        private static final long bitMask = 0xFFFFF0000000000L;
        private static final long allBitsOnBitShifted = 0xFFFFF0000000000L;

        private SmallKeyLength() {
        }
    }

    private final class AbsoluteKeyOffset {
        private static final int bitLength = 40;
        private static final long allBitsOn = 0xFFFFFFFFFFL;
        private static final long bitMask = 0xFFFFFFFFFFL;
        private static final long maxSize = 0x4000000000L;

        private AbsoluteKeyOffset() {
        }
    }
}

