/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class ExprNodeConstantDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final transient char[] hexArray = "0123456789ABCDEF".toCharArray();
    private Object value;
    private transient String foldedFromCol;
    private transient String foldedFromVal;

    public ExprNodeConstantDesc setFoldedFromVal(String foldedFromVal) {
        this.foldedFromVal = foldedFromVal;
        return this;
    }

    public String getFoldedFromVal() {
        return this.foldedFromVal;
    }

    public String getFoldedFromCol() {
        return this.foldedFromCol;
    }

    public void setFoldedFromCol(String foldedFromCol) {
        this.foldedFromCol = foldedFromCol;
    }

    public ExprNodeConstantDesc() {
    }

    public ExprNodeConstantDesc(TypeInfo typeInfo, Object value) {
        super(typeInfo);
        this.value = value;
    }

    public ExprNodeConstantDesc(Object value) {
        this(TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(value.getClass()), value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public ConstantObjectInspector getWritableObjectInspector() {
        return ObjectInspectorUtils.getConstantObjectInspector((ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)this.typeInfo), (Object)this.value);
    }

    public String toString() {
        return "Const " + this.typeInfo.toString() + " " + this.value;
    }

    @Override
    public String getExprString() {
        if (this.value == null) {
            return "null";
        }
        if (this.typeInfo.getTypeName().equals("string") || this.typeInfo instanceof BaseCharTypeInfo) {
            return "'" + this.value.toString() + "'";
        }
        if (this.typeInfo.getTypeName().equals("binary")) {
            byte[] bytes = (byte[])this.value;
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            return new String(hexChars);
        }
        return this.value.toString();
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeConstantDesc(this.typeInfo, this.value);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeConstantDesc)) {
            return false;
        }
        ExprNodeConstantDesc dest = (ExprNodeConstantDesc)o;
        if (!this.typeInfo.equals((Object)dest.getTypeInfo())) {
            return false;
        }
        return !(this.value == null ? dest.getValue() != null : !this.value.equals(dest.getValue()));
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(superHashCode);
        builder.append(this.value);
        return builder.toHashCode();
    }
}

