/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.hive.conf.HiveConf;

public class TezEdgeProperty {
    private HiveConf hiveConf;
    private EdgeType edgeType;
    private int numBuckets;
    private boolean isAutoReduce;
    private int minReducer;
    private int maxReducer;
    private long inputSizePerReducer;

    public TezEdgeProperty(HiveConf hiveConf, EdgeType edgeType, int buckets) {
        this.hiveConf = hiveConf;
        this.edgeType = edgeType;
        this.numBuckets = buckets;
    }

    public TezEdgeProperty(HiveConf hiveConf, EdgeType edgeType, boolean isAutoReduce, int minReducer, int maxReducer, long bytesPerReducer) {
        this(hiveConf, edgeType, -1);
        this.minReducer = minReducer;
        this.maxReducer = maxReducer;
        this.isAutoReduce = isAutoReduce;
        this.inputSizePerReducer = bytesPerReducer;
    }

    public TezEdgeProperty(EdgeType edgeType) {
        this(null, edgeType, -1);
    }

    public EdgeType getEdgeType() {
        return this.edgeType;
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public boolean isAutoReduce() {
        return this.isAutoReduce;
    }

    public int getMinReducer() {
        return this.minReducer;
    }

    public int getMaxReducer() {
        return this.maxReducer;
    }

    public long getInputSizePerReducer() {
        return this.inputSizePerReducer;
    }

    public static enum EdgeType {
        SIMPLE_EDGE,
        BROADCAST_EDGE,
        CONTAINS,
        CUSTOM_EDGE,
        CUSTOM_SIMPLE_EDGE;

    }
}

