/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.AggregationClient;
import org.apache.hadoop.hbase.client.coprocessor.DoubleColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDoubleColumnInterpreter {
    protected static Log myLog = LogFactory.getLog(TestDoubleColumnInterpreter.class);
    private static final TableName TEST_TABLE = TableName.valueOf((String)"TestTable");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"TestFamily");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"TestQualifier");
    private static final byte[] TEST_MULTI_CQ = Bytes.toBytes((String)"TestMultiCQ");
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final int ROWSIZE = 20;
    private static final int rowSeperator1 = 5;
    private static final int rowSeperator2 = 12;
    private static byte[][] ROWS = TestDoubleColumnInterpreter.makeN(ROW, 20);
    private static HBaseTestingUtility util = new HBaseTestingUtility();
    private static Configuration conf = util.getConfiguration();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf.set("hbase.coprocessor.region.classes", "org.apache.hadoop.hbase.coprocessor.AggregateImplementation");
        util.startMiniCluster(2);
        byte[][] SPLIT_KEYS = new byte[][]{ROWS[5], ROWS[12]};
        HTable table = util.createTable(TEST_TABLE, TEST_FAMILY, (byte[][])SPLIT_KEYS);
        for (int i = 0; i < 20; ++i) {
            Put put = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            Double d = new Double(i);
            put.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((double)d));
            table.put(put);
            Put p2 = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            p2.add(TEST_FAMILY, Bytes.add((byte[])TEST_MULTI_CQ, (byte[])Bytes.toBytes((double)d)), Bytes.toBytes((double)(d * 0.1)));
            table.put(p2);
        }
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])Bytes.toBytes((int)i));
        }
        return ret;
    }

    @Test(timeout=300000L)
    public void testMedianWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double median = (Double)aClient.median(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)8.0, (double)median, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double maximum = (Double)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)19.0, (double)maximum, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double max = (Double)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)14.0, (double)max, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double maximum = (Double)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)19.0, (double)maximum, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double max = (Double)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)6.0, (double)max, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Scan scan = new Scan();
        Double max = null;
        try {
            max = (Double)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            max = null;
        }
        Assert.assertEquals(null, (Object)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Scan scan = new Scan();
        scan.setStartRow(ROWS[4]);
        scan.setStopRow(ROWS[2]);
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        double max = Double.MIN_VALUE;
        try {
            max = (Double)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            max = 0.0;
        }
        Assert.assertEquals((double)0.0, (double)max, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMaxWithInvalidRange2() throws Throwable {
        double max = Double.MIN_VALUE;
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[4]);
        scan.setStopRow(ROWS[4]);
        try {
            AggregationClient aClient = new AggregationClient(conf);
            DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
            max = (Double)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Exception e) {
            max = 0.0;
        }
        Assert.assertEquals((double)0.0, (double)max, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMaxWithFilter() throws Throwable {
        Double max = 0.0;
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        scan.setFilter((Filter)f);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        max = (Double)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals(null, (Object)max);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(HConstants.EMPTY_START_ROW);
        scan.setStopRow(HConstants.EMPTY_END_ROW);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double min = (Double)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)0.0, (double)min, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double min = (Double)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)5.0, (double)min, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(HConstants.EMPTY_START_ROW);
        scan.setStopRow(HConstants.EMPTY_END_ROW);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double min = (Double)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)0.0, (double)min, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double min = (Double)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)0.6, (double)min, (double)0.001);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double min = null;
        try {
            min = (Double)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            min = null;
        }
        Assert.assertEquals(null, (Object)min);
    }

    @Test(timeout=300000L)
    public void testMinWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Double min = null;
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[4]);
        scan.setStopRow(ROWS[2]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        try {
            min = (Double)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, min);
    }

    @Test(timeout=300000L)
    public void testMinWithInvalidRange2() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[6]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double min = null;
        try {
            min = (Double)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, min);
    }

    @Test(timeout=300000L)
    public void testMinWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        scan.setFilter((Filter)f);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double min = null;
        min = (Double)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals(null, (Object)min);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double sum = (Double)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)190.0, (double)sum, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double sum = (Double)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)95.0, (double)sum, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double sum = (Double)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)209.0, (double)sum, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double sum = (Double)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)6.6, (double)sum, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double sum = null;
        try {
            sum = (Double)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, sum);
    }

    @Test(timeout=300000L)
    public void testSumWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[2]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double sum = null;
        try {
            sum = (Double)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, sum);
    }

    @Test(timeout=300000L)
    public void testSumWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setFilter((Filter)f);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double sum = null;
        sum = (Double)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals(null, (Object)sum);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)9.5, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)9.5, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)10.45, (double)avg, (double)0.01);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)6.6, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double avg = null;
        try {
            avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, avg);
    }

    @Test(timeout=300000L)
    public void testAvgWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[1]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double avg = null;
        try {
            avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, avg);
    }

    @Test(timeout=300000L)
    public void testAvgWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        scan.setFilter((Filter)f);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double avg = null;
        avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)Double.NaN, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)5.766, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)2.87, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)6.342, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        double std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        System.out.println("std is:" + std);
        Assert.assertEquals((double)0.0, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[17]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double std = null;
        try {
            std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, std);
    }

    @Test
    public void testStdWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[1]);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double std = null;
        try {
            std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, std);
    }

    @Test(timeout=300000L)
    public void testStdWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setFilter((Filter)f);
        DoubleColumnInterpreter ci = new DoubleColumnInterpreter();
        Double std = null;
        std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)Double.NaN, (double)std, (double)0.0);
    }
}

