/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.lib;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.lib.StaticUserWebFilter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestStaticUserWebFilter {
    private FilterConfig mockConfig(String username) {
        FilterConfig mock = (FilterConfig)Mockito.mock(FilterConfig.class);
        ((FilterConfig)Mockito.doReturn((Object)username).when((Object)mock)).getInitParameter("hbase.http.staticuser.user");
        return mock;
    }

    @Test
    public void testFilter() throws Exception {
        FilterConfig config = this.mockConfig("myuser");
        StaticUserWebFilter.StaticUserFilter suf = new StaticUserWebFilter.StaticUserFilter();
        suf.init(config);
        ArgumentCaptor wrapperArg = ArgumentCaptor.forClass(HttpServletRequestWrapper.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        suf.doFilter((ServletRequest)Mockito.mock(HttpServletRequest.class), (ServletResponse)Mockito.mock(ServletResponse.class), chain);
        ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)wrapperArg.capture(), (ServletResponse)Mockito.anyObject());
        HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)wrapperArg.getValue();
        Assert.assertEquals((Object)"myuser", (Object)wrapper.getUserPrincipal().getName());
        Assert.assertEquals((Object)"myuser", (Object)wrapper.getRemoteUser());
        suf.destroy();
    }

    @Test
    public void testOldStyleConfiguration() {
        Configuration conf = new Configuration();
        conf.set("dfs.web.ugi", "joe,group1,group2");
        Assert.assertEquals((Object)"joe", (Object)StaticUserWebFilter.getUsernameFromConf((Configuration)conf));
    }

    @Test
    public void testConfiguration() {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.staticuser.user", "dr.stack");
        Assert.assertEquals((Object)"dr.stack", (Object)StaticUserWebFilter.getUsernameFromConf((Configuration)conf));
    }
}

