/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCombinedBlockCache {
    @Test
    public void testCombinedCacheStats() {
        CacheStats lruCacheStats = new CacheStats("lruCacheStats", 2);
        CacheStats bucketCacheStats = new CacheStats("bucketCacheStats", 2);
        CombinedBlockCache.CombinedCacheStats stats = new CombinedBlockCache.CombinedCacheStats(lruCacheStats, bucketCacheStats);
        double delta = 0.01;
        lruCacheStats.hit(true);
        lruCacheStats.miss(true, false);
        bucketCacheStats.hit(false);
        bucketCacheStats.hit(false);
        bucketCacheStats.miss(false, true);
        Assert.assertEquals((long)5L, (long)stats.getRequestCount());
        Assert.assertEquals((long)2L, (long)stats.getRequestCachingCount());
        Assert.assertEquals((long)2L, (long)stats.getMissCount());
        Assert.assertEquals((long)1L, (long)stats.getPrimaryMissCount());
        Assert.assertEquals((long)1L, (long)stats.getMissCachingCount());
        Assert.assertEquals((long)3L, (long)stats.getHitCount());
        Assert.assertEquals((long)3L, (long)stats.getPrimaryHitCount());
        Assert.assertEquals((long)1L, (long)stats.getHitCachingCount());
        Assert.assertEquals((double)0.6, (double)stats.getHitRatio(), (double)delta);
        Assert.assertEquals((double)0.5, (double)stats.getHitCachingRatio(), (double)delta);
        Assert.assertEquals((double)0.4, (double)stats.getMissRatio(), (double)delta);
        Assert.assertEquals((double)0.5, (double)stats.getMissCachingRatio(), (double)delta);
        lruCacheStats.evicted(1000L, true);
        lruCacheStats.evicted(1000L, false);
        lruCacheStats.evict();
        bucketCacheStats.evict();
        Assert.assertEquals((long)2L, (long)stats.getEvictionCount());
        Assert.assertEquals((long)2L, (long)stats.getEvictedCount());
        Assert.assertEquals((long)1L, (long)stats.getPrimaryEvictedCount());
        Assert.assertEquals((double)1.0, (double)stats.evictedPerEviction(), (double)delta);
        lruCacheStats.failInsert();
        Assert.assertEquals((long)1L, (long)stats.getFailedInserts());
        stats.rollMetricsPeriod();
        Assert.assertEquals((long)3L, (long)stats.getSumHitCountsPastNPeriods());
        Assert.assertEquals((long)5L, (long)stats.getSumRequestCountsPastNPeriods());
        Assert.assertEquals((long)1L, (long)stats.getSumHitCachingCountsPastNPeriods());
        Assert.assertEquals((long)2L, (long)stats.getSumRequestCachingCountsPastNPeriods());
        Assert.assertEquals((double)0.6, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.5, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        lruCacheStats.hit(true);
        lruCacheStats.hit(true);
        lruCacheStats.hit(true);
        stats.rollMetricsPeriod();
        Assert.assertEquals((long)6L, (long)stats.getSumHitCountsPastNPeriods());
        Assert.assertEquals((long)8L, (long)stats.getSumRequestCountsPastNPeriods());
        Assert.assertEquals((long)4L, (long)stats.getSumHitCachingCountsPastNPeriods());
        Assert.assertEquals((long)5L, (long)stats.getSumRequestCachingCountsPastNPeriods());
        Assert.assertEquals((double)0.75, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.8, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
    }
}

