/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.FailedServers;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHBaseClient {
    @Test
    public void testFailedServer() {
        ManualEnvironmentEdge ee = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)ee);
        FailedServers fs = new FailedServers(new Configuration());
        InetSocketAddress ia = InetSocketAddress.createUnresolved("bad", 12);
        InetSocketAddress ia2 = InetSocketAddress.createUnresolved("bad", 12);
        InetSocketAddress ia3 = InetSocketAddress.createUnresolved("badtoo", 12);
        InetSocketAddress ia4 = InetSocketAddress.createUnresolved("badtoo", 13);
        Assert.assertFalse((boolean)fs.isFailedServer(ia));
        fs.addToFailedServers(ia);
        Assert.assertTrue((boolean)fs.isFailedServer(ia));
        Assert.assertTrue((boolean)fs.isFailedServer(ia2));
        ee.incValue(1L);
        Assert.assertTrue((boolean)fs.isFailedServer(ia));
        Assert.assertTrue((boolean)fs.isFailedServer(ia2));
        ee.incValue(2001L);
        Assert.assertFalse((boolean)fs.isFailedServer(ia));
        Assert.assertFalse((boolean)fs.isFailedServer(ia2));
        fs.addToFailedServers(ia);
        fs.addToFailedServers(ia3);
        fs.addToFailedServers(ia4);
        Assert.assertTrue((boolean)fs.isFailedServer(ia));
        Assert.assertTrue((boolean)fs.isFailedServer(ia2));
        Assert.assertTrue((boolean)fs.isFailedServer(ia3));
        Assert.assertTrue((boolean)fs.isFailedServer(ia4));
        ee.incValue(2001L);
        Assert.assertFalse((boolean)fs.isFailedServer(ia));
        Assert.assertFalse((boolean)fs.isFailedServer(ia2));
        Assert.assertFalse((boolean)fs.isFailedServer(ia3));
        Assert.assertFalse((boolean)fs.isFailedServer(ia4));
        fs.addToFailedServers(ia3);
        Assert.assertFalse((boolean)fs.isFailedServer(ia4));
    }
}

